<%@ Page Language="C#"%>
<%@ import namespace="System.Collections.Generic"%>
<%@ import namespace="System.IO"%>
<%@ import namespace="System.Data"%>
<%@ import namespace="System.Data.OleDb"%>
<%@ import namespace="System.Text"%>
<%@ import namespace="System.Text.RegularExpressions"%>

<script runat="server">
    // Copyright (c) 2011-2012 Quadralay Corporation.  All rights reserved.
    //
    // ePublisher 2012.2
    //

    Regex  NoneWordExpression = new Regex(@"^\W+$");

    string ReplaceEmbeddedDoubleQuotes(string  param_string)
    {
      string  result;
      StringBuilder  buffer;
      bool  preceding_is_space;
      bool following_is_space;

      // Replace embedded double-quotes (convert to \n)
      //
      buffer = new StringBuilder();
      preceding_is_space = true;
      for (int  index = 0 ; index < param_string.Length ; index +=1 )
      {
        char  character;

        character = param_string[index];

        // Following is whitespace?
        //
        following_is_space = (index == (param_string.Length - 1)) ? true : (param_string[index + 1] == ' ');

        // Handle character
        //
        if (preceding_is_space)
        {
          // Append character as is
          //
          buffer.Append(character);
        }
        else
        {
          if (following_is_space)
          {
            // Append character as is
            //
            buffer.Append(character);
          }
          else
          {
            // Neither preceding or following characters are whitespace
            //
            if (character == '"')
            {
              // Replace embedded double-quotes
              //
              buffer.Append('\n');
            }
            else
            {
              // Append character as is
              //
              buffer.Append(character);
            }
          }
        }

        // Update preceding info
        //
        preceding_is_space = (character == ' ');
      }

      result = buffer.ToString();

      return result;
    }

    List<List<string>> ParsePhrases(string param_string)
    {
      List<List<string>> result = new List<List<string>>();
      List<string> current_phrase;
      string split_chars_as_string;
      char[] split_chars;
      string[] entries;
      bool in_phrase;

      current_phrase = new List<string>();
      result.Add(current_phrase);
      split_chars_as_string = " ";
      split_chars = split_chars_as_string.ToCharArray();
      entries = param_string.Split(split_chars);
      in_phrase = false;
      for (int entry_index = 0; entry_index < entries.Length; entry_index += 1)
      {
        string  entry = entries[entry_index];
        bool  first;
        bool  last;
        string  stripped_entry;

        // Locate double-quotes
        //
        first = (entry.IndexOf('"') == 0);
        last = (entry.LastIndexOf('"') == entry.Length - 1);

        // Handle entry
        //
        if ((first) && (last))
        {
          if (in_phrase)
          {
            // Add to current phrase
            //
            in_phrase = true;
          }
          else
          {
            // Make unique phrase
            //
            current_phrase = new List<string>();
            result.Add(current_phrase);
            in_phrase = false;
          }
        }
        else if (first)
        {
          if (in_phrase)
          {
            // Open new phrase
            //
            current_phrase = new List<string>();
            result.Add(current_phrase);
            in_phrase = true;
          }
          else
          {
            // Open new phrase
            //
            current_phrase = new List<string>();
            result.Add(current_phrase);
            in_phrase = true;
          }
        }
        else if (last)
        {
          if (in_phrase)
          {
            // Use existing phrase and close out
            //
            in_phrase = false;
          }
          else
          {
            // Make unique phrase
            //
            current_phrase = new List<string>();
            result.Add(current_phrase);
            in_phrase = false;
          }
        }
        else
        {
          if (in_phrase)
          {
            // Use existing phrase
            //
          }
          else
          {
            // Make unique phrase
            //
            current_phrase = new List<string>();
            result.Add(current_phrase);
          }
        }

        // Strip double-quotes before adding to the phrase
        //
        stripped_entry = entry.Replace("\"", "");
        current_phrase.Add(stripped_entry);
      }

      return result;
    }

    string PhrasesToQueryString(List<List<string>>  param_phrases)
    {
      string  result;
      List<string>  phrases;
      StringBuilder  buffer;

      // Build phrases
      //
      phrases = new List<string>();
      buffer = new StringBuilder();
      foreach (List<string>  phrase_components in param_phrases)
      {
        buffer.Remove(0, buffer.Length);

        foreach (string  phrase_component in phrase_components)
        {
          if (buffer.Length > 0)
          {
            buffer.Append(" ");
          }
          buffer.Append(phrase_component);
        }

        // Keep non-empty phrases
        //
        if (buffer.Length > 0)
        {
          phrases.Add(buffer.ToString());
        }
      }

      // Quote phrases and handle boolean operators
      //
      buffer.Remove(0, buffer.Length);
      string boolean_expression = String.Empty;
      foreach (string phrase in phrases)
      {
        bool  bool_and = (String.Compare(phrase, "and", StringComparison.OrdinalIgnoreCase) == 0);
        bool  bool_or = (String.Compare(phrase, "or", StringComparison.OrdinalIgnoreCase) == 0);
        bool  bool_not = (String.Compare(phrase, "not", StringComparison.OrdinalIgnoreCase) == 0);
        bool  bool_operator = (bool_and || bool_or || bool_not);

        // Add phrase to expression
        //
        if (bool_operator)
        {
          // Handle boolean operators
          //
          if (buffer.Length == 0)
          {
            // Ignore it
            //
          }
          else
          {
            // Update boolean expression
            //
            if (bool_not)
            {
              // Can only be used with AND
              //
              if (String.Compare(boolean_expression, "and", StringComparison.OrdinalIgnoreCase) == 0)
              {
                boolean_expression = "AND NOT";
              }
              else
              {
                // Ignore it
                //
              }
            }
            else
            {
              boolean_expression = phrase;
            }
          }
        }
        else
        {
          // Regular entry
          //
          bool  none_word;

          none_word = false;
          if (phrase.IndexOf(" ") == -1)
          {
            none_word = NoneWordExpression.IsMatch(phrase);
          }

          // Keep if a valid word
          //
          if ( ! none_word)
          {
            // Emit boolean expression
            //
            if (buffer.Length > 0)
            {
              if (String.IsNullOrEmpty(boolean_expression))
              { 
                buffer.Append(" AND ");
              }
              else
              {
                buffer.Append(" ");
                buffer.Append(boolean_expression);
                buffer.Append(" ");

                // Boolean expression can be used only once
                //
                boolean_expression = String.Empty;
              }
            }

            // Emit phrase, double-quoted
            //
            if (phrase.IndexOf(" ") == -1)
            {
              // Search for alternate forms
              //
              buffer.Append(String.Format("FORMSOF(INFLECTIONAL,\"{0}\")", phrase));
            }
            else
            {
              // Phrase
              //
              buffer.Append("\"");
              buffer.Append(phrase);
              buffer.Append("\"");
            }
          }
        }
      }

      // Restore \n as escaped double-quotes
      //
      buffer.Replace("\n", "\"\"");
      result = buffer.ToString();

      return result;
    }

    string PrepareSearchString(string param_search_string)
    {
      string  result = "";
      string  normalized_search_string;
      string  escaped_search_string;

      // Normalize whitespace and escape single quotes
      //
      normalized_search_string = param_search_string.Trim();
      normalized_search_string = Regex.Replace(normalized_search_string, @"\s+", " ");
      normalized_search_string = normalized_search_string.Replace("'", "''");

      // Quote search words and phrases, break out boolean expressions
      //
      if (normalized_search_string.Length > 0)
      {
        List<List<string>>  phrases;

        // Escape embedded double-quotes (convert to \n for now)
        //
        escaped_search_string = ReplaceEmbeddedDoubleQuotes(normalized_search_string);
        phrases = ParsePhrases(escaped_search_string);

        // Return phrases as SQL query string
        //
        result = PhrasesToQueryString(phrases);
      }

      return result;
    }

    void TestSearchParsing(string param_string)
    {
      string parsed_string;

      parsed_string = PrepareSearchString(param_string);
      Response.Write("<pre>\n");
      Response.Write(String.Format("[{0}]\n", EscapeForHTML(param_string)));
      Response.Write(String.Format("    [{0}]\n", EscapeForHTML(parsed_string)));
      Response.Write("</pre>\n");
    }

    public void TestSearch()
    {
      TestSearchParsing("adsfasadsf");
      TestSearchParsing("asdf'adsfsadf");
      TestSearchParsing("\"adsf adf     asdf\"");
      TestSearchParsing("adsfas   ad s      f");
      TestSearchParsing("\"ab\"c\"d");
      TestSearchParsing("and asdfasd");
      TestSearchParsing("not asdfasd");
      TestSearchParsing("or asdfasd");
      TestSearchParsing("asdfasd and");
      TestSearchParsing("asdfasd or");
      TestSearchParsing("asdfasd not");
      TestSearchParsing("asdfasd and not");
      TestSearchParsing("asdfasd or not");
      TestSearchParsing("green and blue");
      TestSearchParsing("green or blue");
      TestSearchParsing("green not blue");
      TestSearchParsing("green and not blue");
      TestSearchParsing("green or not blue");
      TestSearchParsing("green not and blue");
      TestSearchParsing("green not or blue");
      TestSearchParsing("green and or or or or and not blue");
      TestSearchParsing("green and or or or or and not");

      TestSearchParsing("\"set*\" and \"portal\"");
      TestSearchParsing("\"set*\" and \"portal");

      TestSearchParsing("\"green\" and \"blue\"");
      TestSearchParsing("\"green\" or \"blue\"");
      TestSearchParsing("\"green\" not \"blue\"");
      TestSearchParsing("\"green\" and not \"blue\"");
      TestSearchParsing("\"green\" or not \"blue\"");
      TestSearchParsing("\"green\" not and \"blue\"");
      TestSearchParsing("\"green\" not or \"blue\"");
      TestSearchParsing("\"green\" and or or or or and not \"blue\"");
      TestSearchParsing("\"green\" and or or or or and not");

      TestSearchParsing("\"green phrase\" and \"blue phrase\"");
      TestSearchParsing("\"green phrase\" or \"blue phrase\"");
      TestSearchParsing("\"green phrase\" not \"blue phrase\"");
      TestSearchParsing("\"green phrase\" and not \"blue phrase\"");
      TestSearchParsing("\"green phrase\" or not \"blue phrase\"");
      TestSearchParsing("\"green phrase\" not and \"blue phrase\"");
      TestSearchParsing("\"green phrase\" not or \"blue phrase\"");
      TestSearchParsing("\"green phrase\" and or or or or and not \"blue phrase\"");
      TestSearchParsing("\"green phrase\" and or or or or and not");
      TestSearchParsing("Chimei TL-xxH2100U Series  LNET/OCV");
      TestSearchParsing("\"Chimei TL-xxH2100U Series  LNET/OCV\"");
    }

    public string EscapeForHTML(string param_string)
    {
      StringBuilder  buffer;

      buffer = new StringBuilder();
      buffer.Append(param_string);
      buffer.Replace("&", "&amp;");
      buffer.Replace("<", "&lt;");
      buffer.Replace(">", "&gt;");
      buffer.Replace("\"", "&quot;");

      return buffer.ToString();
    }
</script>

<%
    bool  debug = false;
    string  search_string;
    string  prepared_search_string;
    Dictionary<string, bool>  extensions_to_ignore;

    search_string = Request.QueryString["q"];
    prepared_search_string = PrepareSearchString(search_string);

    extensions_to_ignore = new Dictionary<string, bool>(StringComparer.OrdinalIgnoreCase);
    extensions_to_ignore[".css"] = true;
    extensions_to_ignore[".js"] = true;

    if (prepared_search_string.Length > 0) {
        using (OleDbConnection connection = new OleDbConnection("Provider=Search.CollatorDSO;Extended Properties='Application=Windows';")) {
            try {
                connection.Open();
                string directoryClause = String.Empty;
                string physicalPath = Request.PhysicalPath;
                string reverbRootDirectory = Path.GetDirectoryName(Path.GetDirectoryName(physicalPath));

                // Make a reference to a directory.
                DirectoryInfo di = new DirectoryInfo(reverbRootDirectory);

                // Get a reference to each directory in that directory.
                DirectoryInfo[] diArr = di.GetDirectories();

                // Display the names of the directories.
                for (int i = 0; i < diArr.Length; i++) {
                    if (diArr[i].Name != "connect") {
                        directoryClause += String.Format("SCOPE='file:{0}'", diArr[i].FullName.Replace('\\', '/'));

                        if ((i + 1) < diArr.Length) {
                            directoryClause += " OR ";
                        }
                    }
                }

                // ISearchQueryHelper
                // Using ISearchQueryHelper from managed code
                // http://blogs.msdn.com/b/cheller/archive/2006/12/06/using-isearchqueryhelper-from-managed-code.aspx
                //
                // System.Search values
                // http://msdn.microsoft.com/en-us/library/windows/desktop/ff521715%28v=VS.85%29.aspx
                //
                // FROM Clause
                // http://msdn.microsoft.com/en-us/library/windows/desktop/bb231297%28v=vs.85%29.aspx
                //
                // RANK BY Clause
                // http://msdn.microsoft.com/en-us/library/windows/desktop/bb231278%28v=vs.85%29.aspx
                //
                // ORDER BY Clause
                // http://msdn.microsoft.com/en-us/library/windows/desktop/bb231279%28v=VS.85%29.aspx
                //
                string query_string;
                query_string = String.Format(
                                   "SELECT System.Title, System.ItemURL, System.Search.AutoSummary, System.Search.HitCount FROM SystemIndex WHERE ({0}) AND CONTAINS(Contents, '{1}') ORDER BY System.Search.HitCount DESC",
                                   directoryClause,
                                   prepared_search_string
                               );

                if (debug) {
                    Response.Write(String.Format("<div style=\"background-color: yellow; margin: 4px; border: solid 1px black\">{0}</div>\n", search_string));
                    Response.Write(String.Format("<div style=\"background-color: yellow; margin: 4px; border: solid 1px black\">{0}</div>\n", prepared_search_string));
                    Response.Write(String.Format("<div style=\"background-color: yellow; margin: 4px; border: solid 1px black\">{0}</div>\n", query_string));
                }

                try
                {
                    bool gotResults = false;
                    Uri referenceUri = new Uri(physicalPath);
                    OleDbCommand command = new OleDbCommand(query_string, connection);
                    using (OleDbDataReader reader = command.ExecuteReader()) {
                        while (reader.Read()) {
                            // Exclude certain extensions (.css, .js, etc.)
                            //
                            string extension = Path.GetExtension(reader["System.ItemURL"].ToString());
                            if ( ! extensions_to_ignore.ContainsKey(extension)) {
                                Uri linkAbsoluteUri = new Uri(reader["System.ItemURL"].ToString());
                                Uri linkRelativeUri = referenceUri.MakeRelativeUri(linkAbsoluteUri);

                                // Ensure title was determined for this content
                                //
                                string title = reader["System.Title"].ToString();
                                if (String.IsNullOrEmpty(title)) {
                                    title = Path.GetFileName(reader["System.ItemURL"].ToString());
                                }

                                Response.Write(String.Format("<div class=\"search-result-title\"><a target=\"connect_page\" href=\"{0}\">{1}</a></div>\n", linkRelativeUri.ToString(), EscapeForHTML(title)));
                                Response.Write(String.Format("<div class=\"search-result-summary\">{0} ...</div>\n", EscapeForHTML(reader["System.Search.AutoSummary"].ToString())));

                                gotResults = true;
                            }
                        }
                    }

                    // Indexing enabled for the target directories?
                    //
                    if ( ! gotResults) {
                        // Check the directory
                        //
                        query_string = String.Format(
                                           "SELECT System.Title, System.ItemURL FROM SystemIndex WHERE ({0})",
                                           directoryClause
                                       );
                        command = new OleDbCommand(query_string, connection);
                        using (OleDbDataReader reader = command.ExecuteReader()) {
                            if (reader.Read()) {
                                // Content is indexed!
                                //
                            }
                            else {
                                // Nothing returned means the directories have not been indexed
                                //
                                Response.Write("<div style=\"color: white; background-color: red; margin: 4px; border: solid 1px black\">\n");
                                Response.Write("<div>Windows Search indexing is not currently enabled for:</div>\n");
                                Response.Write("<ul>\n");
                                Uri reverbDirectoryUri = new Uri(reverbRootDirectory);
                                for (int i = 0; i < diArr.Length; i++) {
                                    if (diArr[i].Name != "connect") {
                                        Uri directoryAbsoluteUri = new Uri(diArr[i].FullName);
                                        Uri directoryRelativeUri = reverbDirectoryUri.MakeRelativeUri(directoryAbsoluteUri);
                                        Response.Write(String.Format("<li>{0}</li>\n", directoryRelativeUri.ToString()));
                                    }
                                }
                                Response.Write("</ul>\n");
                                Response.Write("<div style=\"background-color: yellow; margin: 4px; padding: 4px; border: solid 1px black\"><a target=\"webworks_wiki\" href=\"http://wiki.webworks.com/Permalinks/Solutions/Output/WebWorksReverb/ConfiguringIIS/ConfiguringSearch/\">See configuring search for Microsoft IIS.</a></div>\n");
                                Response.Write("</div>\n");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // Report and keep moving
                    //
                    if (debug) {
                        Response.Write("<div style=\"background-color: yellow; margin: 4px; border: solid 1px black\">\n");
                        while (e != null) {
                            Response.Write(String.Format("<div>{0}</div>\n", e.Message));

                            e = e.InnerException;
                        }
                        Response.Write("</div>\n");
                    }
                }
            }
            catch (Exception e) {
                // Report and keep moving
                //
                if (debug) {
                    Response.Write("<div style=\"background-color: yellow; margin: 4px; border: solid 1px black\">\n");
                    while (e != null) {
                        Response.Write(String.Format("<div>{0}</div>\n", e.Message));

                        e = e.InnerException;
                    }
                    Response.Write("</div>\n");
                }
            }
            finally {
                connection.Close();
            }
        }
    }

    Response.Write("\n");
%>
