// Copyright (c) 2010-2012 Quadralay Corporation.  All rights reserved.
//
// ePublisher 2012.2
//
// Validated with JSLint <http://www.jslint.com/>
//

/*jslint unparam: true, sub: true, maxerr: 50, indent: 4 */
/*global window */
/*global Browser */
/*global Message */
/*global FAJAX */

var Connect_Window = window;
Connect_Window.name = 'connect_main';


// Progress
//

var Progress = { progress: 0 };

Progress.Reset = function () {
    'use strict';

    var current_progress, progress_segment, progress_div;

    // Reset progress
    //
    Progress.progress = 0;

    // Reset segments
    //
    current_progress = 0;
    while (current_progress < 100) {
        current_progress += 10;

        progress_segment = Connect_Window.document.getElementById('progress_' + current_progress);
        progress_segment.className = Browser.ReplaceClass(progress_segment.className, 'ww_skin_progress_segment_complete', 'ww_skin_progress_segment_pending');
    }

    // Show progress
    //
    progress_div = Connect_Window.document.getElementById('progress');
    progress_div.style.display = 'block';
};

Progress.Update = function (param_progress) {
    'use strict';

    var progress_segment;

    if (param_progress > Progress.progress) {
        if (param_progress <= 100) {
            while ((Progress.progress + 10) <= param_progress) {
                Progress.progress = Progress.progress + 10;

                progress_segment = Connect_Window.document.getElementById('progress_' + Progress.progress);
                progress_segment.className = Browser.ReplaceClass(progress_segment.className, 'ww_skin_progress_segment_pending', 'ww_skin_progress_segment_complete');
            }
        }
    }
};

Progress.Complete = function () {
    'use strict';

    var progress_div;

    progress_div = Connect_Window.document.getElementById('progress');
    progress_div.style.display = 'none';
};


// AJAXData
//

function AJAXData_Execute() {
    'use strict';

    var this_ajaxdata, entry, ajax, request_url, moment;

    this_ajaxdata = this;
    if (this_ajaxdata.index < this_ajaxdata.entries.length) {
        // Load entry
        //
        entry = this_ajaxdata.entries[this_ajaxdata.index];
        if (Connect_Window.document.location.protocol === 'file:') {
            ajax = new FAJAX.Object(Connect_Window);
        } else {
            ajax = Browser.GetAJAX(Connect_Window);
        }

        ajax.onreadystatechange = function () {
            if (ajax.readyState === 4) {
                // Entry retrieved
                //
                if (ajax.status === 200) {
                    // Success!
                    //
                    this_ajaxdata.success(entry, ajax);

                    // Update progress
                    //
                    this_ajaxdata.index += 1;
                    this_ajaxdata.progress((this_ajaxdata.index / this_ajaxdata.entries.length) * 100);
                } else if (ajax.status === 304) {
                    // Already trying to work around 304s?
                    //
                    if (this_ajaxdata.ajax_avoid_304) {
                        // Keep moving forward
                        //
                        this_ajaxdata.index += 1;
                        this_ajaxdata.progress((this_ajaxdata.index / this_ajaxdata.entries.length) * 100);
                    } else {
                        // Retry
                        //
                        this_ajaxdata.ajax_avoid_304 = true;
                    }
                }

                // Load next entry
                //
                Connect_Window.setTimeout(function () { this_ajaxdata.Execute(); }, 1);
            }
        };

        // Avoid 304 (not modified) responses
        //
        request_url = this_ajaxdata.get_url(entry);
        if (this_ajaxdata.ajax_avoid_304) {
            moment = new Date();
            request_url += '?moment=' + moment.getTime();
        }

        // Request entry
        //
        ajax.open('GET', request_url, true);
        ajax.send(null);
    } else {
        // Entries loaded!
        //
        this_ajaxdata.complete();
    }
}

function AJAXData_Object(param_entries, param_get_url, param_progress, param_success, param_complete) {
    'use strict';

    this.entries = param_entries;
    this.get_url = param_get_url;
    this.progress = param_progress;
    this.success = param_success;
    this.complete = param_complete;
    this.index = 0;
    this.ajax_avoid_304 = false;

    this.Execute = AJAXData_Execute;
}


// Panel
//

function Panel_Visible() {
    'use strict';

    var result;

    result = (this.panel_frame.style.display === 'block');

    return result;
}

function Panel_Show() {
    'use strict';

    if (!this.Visible()) {
        // Configure panel
        //
        if ((this.connect.layout_wide) && (this.display_as_sidebar)) {
            this.panel_frame.className = Browser.AddClass(this.panel_frame.className, 'ww_skin_panel_frame_side');
            this.panel_frame.style.width = String(this.connect.navigation_width) + 'px';
        } else {
            this.panel_frame.className = Browser.RemoveClass(this.panel_frame.className, 'ww_skin_panel_frame_side');
            this.panel_frame.style.width = '';
            this.page_div.style.visibility = 'hidden';
            this.page_div.style.display = 'none';
        }
        this.panel_frame.style.display = 'block';
        this.panel_frame.style.visibility = 'visible';

        // Handle layout changes
        //
        if ((this.connect.layout_wide) && (this.display_as_sidebar)) {
            this.Resize();
        }
    }
}

function Panel_Resize() {
    'use strict';

    this.resize();
}

function Panel_Hide() {
    'use strict';

    if (this.Visible()) {
        // Teardown
        //
        if ((this.teardown !== undefined) && (this.teardown !== null)) {
            this.teardown(this.window, this.panel_content);
            this.teardown = undefined;
        }

        // Hide panel
        //
        this.panel_frame.style.visibility = 'hidden';
        this.panel_frame.style.display = 'none';
        this.page_div.style.display = 'block';
        this.page_div.style.visibility = 'visible';
        this.page_iframe.style.display = 'block';
        this.page_iframe.style.visibility = 'visible';

        // Handle layout changes
        //
        this.window.setTimeout(function () { this.Resize(); }, 1);
    }
}

function Panel_Display(param_display_as_sidebar, param_setup, param_resize, param_teardown) {
    'use strict';

    var this_panel;

    // Setup
    //
    this.display_as_sidebar = (this.connect.navigation_width > 0) ? param_display_as_sidebar : false;
    param_setup(this.window, this.panel_content);

    // Configure resize and teardown
    //
    this.resize = param_resize;
    this.teardown = param_teardown;

    // Show!
    //
    this_panel = this;
    this.window.setTimeout(function () { this_panel.Show(); }, 1);
}

function Panel_Object(param_window, param_connect) {
    'use strict';

    this.window = param_window;
    this.connect = param_connect;
    this.display_as_sidebar = false;
    this.teardown = undefined;
    this.panel_frame = this.window.document.getElementById('panel_frame');
    this.panel_content = this.window.document.getElementById('panel_content');
    this.page_div = this.window.document.getElementById('page_div');
    this.page_iframe = this.window.document.getElementById('page_iframe');

    this.Visible = Panel_Visible;
    this.Show = Panel_Show;
    this.Resize = Panel_Resize;
    this.Hide = Panel_Hide;
    this.Display = Panel_Display;
}


// Lightbox
//

function Lightbox_Show() {
    'use strict';

    var browser_widthheight, lightbox_frame_widthheight, lightbox_frame_left, lightbox_frame_top, window_content_widthheight, background_height;

    // Calculate position
    //
    browser_widthheight = Browser.GetBrowserWidthHeight(Connect_Window);
    lightbox_frame_widthheight = Browser.GetElementWidthHeight(this.lightbox_frame);
    lightbox_frame_left = Math.floor((browser_widthheight.width - lightbox_frame_widthheight.width) / 2);
    if (lightbox_frame_left < 0) {
        lightbox_frame_left = 0;
    }
    lightbox_frame_top = Math.floor((browser_widthheight.height - lightbox_frame_widthheight.height) / 2);
    if (lightbox_frame_top < 0) {
        lightbox_frame_top = 0;
    }

    // Set up the background
    //
    window_content_widthheight = Browser.GetWindowContentWidthHeight(Connect_Window);
    background_height = window_content_widthheight.height;
    if (browser_widthheight.height > background_height) {
        background_height = browser_widthheight.height;
    }
    if (lightbox_frame_widthheight.height > background_height) {
        background_height = lightbox_frame_widthheight.height;
    }
    if (Connect.page_info !== undefined) {
        if (Connect.page_info.dimensions.height > background_height) {
            background_height = Connect.page_info.dimensions.height;
        }
    }
    this.lightbox_background.style.top = '0px';
    this.lightbox_background.style.height = String(background_height) + 'px';
    this.lightbox_background.style.display = 'block';

    // Configure the frame
    //
    this.lightbox_frame.style.left = String(lightbox_frame_left) + 'px';
    this.lightbox_frame.style.top = String(lightbox_frame_top) + 'px';
    this.lightbox_frame.style.visibility = 'visible';
}

function Lightbox_Hide() {
    'use strict';

    // Hide lightbox
    //
    this.lightbox_frame.style.visibility = 'hidden';
    this.lightbox_frame.style.top = '0px';
    this.lightbox_frame.style.left = '0px';
    this.lightbox_background.style.display = 'none';

    // Teardown
    //
    if ((this.teardown !== undefined) && (this.teardown !== null)) {
        this.teardown(this.lightbox_content);
        this.teardown = undefined;
    }
}

function Lightbox_Display(param_setup, param_teardown) {
    'use strict';

    var this_lightbox;

    // Setup
    //
    param_setup(this.lightbox_content);

    // Configure teardown
    //
    this.teardown = param_teardown;

    // Show!
    //
    this_lightbox = this;
    Connect_Window.setTimeout(function () { this_lightbox.Show(); }, 1);
}

function Lightbox_Object() {
    'use strict';

    var this_lightbox;

    this.lightbox_background = Connect_Window.document.getElementById('lightbox_background');
    this.lightbox_frame = Connect_Window.document.getElementById('lightbox_frame');
    this.lightbox_content = Connect_Window.document.getElementById('lightbox_content');
    this.lightbox_close = Connect_Window.document.getElementById('lightbox_close');
    this.teardown = undefined;

    this_lightbox = this;
    this.page_iframe = Connect_Window.document.getElementById('page_iframe');
    this.lightbox_close.onclick = function () { this_lightbox.Hide(); };

    this.Show = Lightbox_Show;
    this.Hide = Lightbox_Hide;
    this.Display = Lightbox_Display;
}


var Connect = { loading: false };

Connect.OnLoadAction = function () {
    'use strict';

    var url_header, base_pathname, base_url, splash_page_url, css_rules, css_rules_index, css_rule, parcel_anchors, index;

    url_header = Connect_Window.location.href.substring(0, Connect_Window.location.href.indexOf(Connect_Window.location.pathname));
    base_pathname = Connect_Window.location.pathname.substring(0, Connect_Window.location.pathname.lastIndexOf('/') + 1);
    base_url = url_header + base_pathname;
    splash_page_url = base_url + 'connect/splash.html';

    Connect.base_url = base_url;
    Connect.default_page_url = splash_page_url;
    Connect.splash_page_url = splash_page_url;
    Connect.search_page_url = base_url + 'connect/search.html';
    Connect.show_first_document = false;
    Connect.layout_wide = false;
    Connect.adjust_for_content_size_timeout = null;
    Connect.ajax_avoid_304 = false;
    Connect.parcels_loaded = false;
    Connect.ignore_page_load = false;
    Connect.hash = '';
    Connect.parcel_anchors = [];
    Connect.parcel_ix = [];
    Connect.parcel_sx = [];
    Connect.parcel_title = {};
    Connect.navigation_width = 200;
    Connect.navigation_minimum_page_width = 800;
    Connect.lightbox_min_pixel_margin = 48;
    Connect.disqus_id = '';
    Connect.email = '';
    Connect.toc_class_states = {};
    Connect.toc_selected_entry_key = undefined;
    Connect.toc_cleanup_folders = true;
    Connect.search_input = null;
    Connect.search_query = '';
    Connect.button_behavior_expression = new RegExp('ww_behavior_[a-z]+', 'g');
    Connect.buttons = {};
    Connect.button_behaviors = {'ww_behavior_toc': Connect.Button_TOC,
            'ww_behavior_index': Connect.Button_Index,
            'ww_behavior_search': Connect.Button_Search,
            'ww_behavior_globe': Connect.Button_Globe,
            'ww_behavior_prev': Connect.Button_Previous,
            'ww_behavior_next': Connect.Button_Next,
            'ww_behavior_email': Connect.Button_Email,
            'ww_behavior_print': Connect.Button_Print,
            'ww_behavior_pdf': Connect.Button_PDF
        };
    Connect.button_degradation_order = ['ww_behavior_globe', 'ww_behavior_index', 'ww_behavior_search', 'ww_behavior_toc'];
    Connect.globe_enabled = false;
    Connect.globalized_sized_count = 0;

    Connect.link_bridge = {
        last_link: null,
        Next: {},
        Prev: {},
        HREFs: { 'splash': splash_page_url },
        Track: function (param_first_link, param_last_link) {
            var firstPageID, lastPageID, lastLinkID;

            firstPageID = param_first_link.id.replace(/\:first$/, '');
            lastPageID = param_last_link.id.replace(/\:last$/, '');

            // Associate previous/next and handle no splash
            //
            if (this.last_link === null) {
                if (Connect.show_first_document) {
                    Connect.default_page_url = param_first_link.href;
                } else {
                    this.Prev[firstPageID] = 'splash';
                }
                this.Next['splash'] = firstPageID;
            } else {
                lastLinkID = this.last_link.id.replace(/\:last$/, '');
                this.Prev[firstPageID] = lastLinkID;
                this.Next[lastLinkID] = firstPageID;
            }

            // Map ids to URIs
            //
            this.HREFs[firstPageID] = param_first_link.href;
            this.HREFs[lastPageID] = param_last_link.href;

            // Remember last link loaded
            //
            this.last_link = param_last_link;
        },

        GetPrev: function (param_page_id) {
            var result;

            result = null;

            if (this.Prev[param_page_id] !== undefined) {
                result = this.HREFs[this.Prev[param_page_id]];
            }

            return result;
        },

        GetNext: function (param_page_id) {
            var result;

            result = null;

            if (this.Next[param_page_id] !== undefined) {
                result = this.HREFs[this.Next[param_page_id]];
            }

            return result;
        },

        Get: function (param_type, param_page_id) {
            var result;

            result = null;

            if (param_type === 'Prev') {
                result = this.GetPrev(param_page_id);
            } else if (param_type === 'Next') {
                result = this.GetNext(param_page_id);
            }

            return result;
        }
    };

    // Layout offsets
    //
    Connect.layout_wide_offset = 0;
    Connect.layout_narrow_offset = 0;
    Connect.layout_current_offset = 0;
    Connect.layout_height_tolerance = 6;
    Connect.panel_side_offset = 0;
    if (Connect_Window.navigator.userAgent.indexOf('MSIE') !== -1) {
        // Internet Explorer requires a bigger buffer
        //
        Connect.layout_height_tolerance = 20;
    }
    css_rules = Connect_Window.document.styleSheets[0].cssRules;
    if (css_rules === undefined) {
        css_rules = Connect_Window.document.styleSheets[0].rules;
    }
    for (css_rules_index = 0; css_rules_index < css_rules.length; css_rules_index += 1) {
        css_rule = css_rules[css_rules_index];

        if (css_rule.selectorText === '.layout_wide') {
            Connect.layout_wide_offset += parseInt(css_rule.style.paddingLeft, 10);
            Connect.layout_wide_offset += parseInt(css_rule.style.paddingRight, 10);
        } else if (css_rule.selectorText === '.layout_narrow') {
            Connect.layout_narrow_offset += parseInt(css_rule.style.paddingLeft, 10);
            Connect.layout_narrow_offset += parseInt(css_rule.style.paddingRight, 10);
        } else if (css_rule.selectorText === '.ww_skin_panel_frame_side') {
            Connect.panel_side_offset += parseInt(css_rule.style.paddingLeft, 10);
            Connect.panel_side_offset += parseInt(css_rule.style.paddingRight, 10);
        }
    }

    // Cache <div>s
    //
    Connect.layout_div = Connect_Window.document.getElementById('layout_div');
    Connect.toolbar_div = Connect_Window.document.getElementById('toolbar_div');
    Connect.presentation_div = Connect_Window.document.getElementById('presentation_div');
    Connect.parcels_div = Connect_Window.document.getElementById('parcels');
    Connect.page_div = Connect_Window.document.getElementById('page_div');
    Connect.page_iframe = Connect_Window.document.getElementById('page_iframe');
    Connect.panels_div = Connect_Window.document.getElementById('panels');
    Connect.panel_progress_div = Connect_Window.document.getElementById('panel_progress');
    Connect.toc_div = Connect_Window.document.getElementById('toc');
    Connect.index_div = Connect_Window.document.getElementById('index');
    Connect.search_div = Connect_Window.document.getElementById('search');
    Connect.search_iframe = Connect_Window.document.getElementById('search_iframe');

    // Size content <div>
    //
    Connect_Window.onresize = Connect.OnResize;
    if (Connect_Window.addEventListener !== undefined) {
        Connect_Window.addEventListener('orientationchange', Connect.OnResize, false);
    }

    // Panel
    //
    Connect.Panel = new Panel_Object(Connect_Window, Connect);
    Connect.panel_changing = false;
    Connect.sidebar_behavior = undefined;
    Connect.sidebar_auto_display = (Connect.navigation_width > 0);

    // Lightbox
    //
    Connect.Lightbox = new Lightbox_Object();

    // Load parcels
    //
    Connect.parcel_anchors = [];
    Connect.parcel_context_ids = {};
    Connect.parcel_prefixes = {};
    Connect.parcel_prefixes[Connect.base_url + 'connect/'] = true;
    Connect.toc_div.innerHTML = Connect.parcels_div.innerHTML;
    Connect.parcels_div.innerHTML = '';
    Connect.parcels_div.style.display = 'none';
    parcel_anchors = Connect.toc_div.getElementsByTagName('a');
    if (parcel_anchors.length === 0) {
        parcel_anchors = Connect_Window.document.links;
    }
    for (index = 0; index < parcel_anchors.length; index += 1) {
        Connect.parcel_anchors[Connect.parcel_anchors.length] = parcel_anchors[index];
    }
    Connect.Parcel_Load();

    // Setup for listening
    //
    Connect.dispatch_listen = undefined;
    Message.Listen(Connect_Window, Connect.Listen);
};

Connect.OnLoad = function () {
    'use strict';

    if (!Connect.loading) {
        Connect.loading = true;
        Connect.OnLoadAction();
    }
};

// Start running as soon as possible
//
if (window.addEventListener !== undefined) {
    window.document.addEventListener('DOMContentLoaded', Connect.OnLoad, false);
}

Connect.AddParcel = function (param_parcel_context,
                             param_parcel_id,
                             param_parcel_url,
                             param_parcel_title) {
    'use strict';

    var parcel_directory_url;

    parcel_directory_url = param_parcel_url.substring(0, param_parcel_url.lastIndexOf('.'));

    // Track context
    //
    Connect.parcel_context_ids[param_parcel_context] = param_parcel_id;

    // Include original file and directory prefix
    //
    Connect.parcel_prefixes[param_parcel_url] = true;
    Connect.parcel_prefixes[parcel_directory_url] = true;
    Connect.parcel_ix.push({ 'id': param_parcel_id, 'url': parcel_directory_url + '_ix.html' });
    Connect.parcel_sx.push(parcel_directory_url + '_sx.js');
    Connect.parcel_title[param_parcel_id] = param_parcel_title;
};

Connect.KnownParcelURL = function (param_url) {
    'use strict';

    var result, parcel_base_url;

    result = false;

    for (parcel_base_url in Connect.parcel_prefixes) {
        if (typeof Connect.parcel_prefixes[parcel_base_url] === 'boolean') {
            if (Browser.SameHierarchy(parcel_base_url, param_url)) {
                result = true;
                break;
            }
        }
    }

    return result;
};

Connect.KnownParcelBaggageURL = function (param_url) {
    'use strict';

    var result, parcel_base_url, baggage_url;

    result = false;

    for (parcel_base_url in Connect.parcel_prefixes) {
        if (typeof Connect.parcel_prefixes[parcel_base_url] === 'boolean') {
            if (Browser.SameHierarchy(parcel_base_url, param_url)) {
                baggage_url = parcel_base_url + '/baggage/';
                result = Browser.SameHierarchy(baggage_url, param_url);
                break;
            }
        }
    }

    return result;
};

Connect.CalculateLayoutWide = function () {
    'use strict';

    var result, browser_widthheight, scrollbar_widthheight;

    browser_widthheight = Browser.GetBrowserWidthHeight(Connect_Window);
    scrollbar_widthheight = Browser.GetScrollbarWidthHeight(Connect_Window);
    result = ((browser_widthheight.width - Connect.layout_wide_offset - scrollbar_widthheight.width) >= Connect.navigation_minimum_page_width);

    return result;
};

Connect.AdjustToolbarForBrowserSize = function () {
    'use strict';

    var handle_showhide, browser_widthheight, toolbar_table_widthheight, show, index, done;

    // Define show/hide handling
    //
    handle_showhide = function (param_index, param_show) {
        var done, button_behavior, toolbar_button, browser_widthheight, toolbar_table_widthheight;

        done = false;

        // Possible button to show/hide
        //
        button_behavior = Connect.button_degradation_order[param_index];
        toolbar_button = Connect.buttons[button_behavior];
        if (toolbar_button !== undefined) {
            // Show/hide
            //
            if (param_show) {
                toolbar_button.style.display = 'inline-block';
            } else {
                toolbar_button.style.display = 'none';
            }

            // Keep change?
            //
            browser_widthheight = Browser.GetBrowserWidthHeight(Connect_Window);
            toolbar_table_widthheight = Browser.GetElementWidthHeight(Connect.toolbar_div.firstChild);
            if (param_show) {
                if (toolbar_table_widthheight.width > (browser_widthheight.width - Connect.layout_current_offset)) {
                    // Revert change
                    //
                    toolbar_button.style.display = 'none';
                    done = true;
                }
            } else {
                if (toolbar_table_widthheight.width <= (browser_widthheight.width - Connect.layout_current_offset)) {
                    // Met the goal size
                    //
                    done = true;
                }
            }
        }

        return done;
    };

    // Show/hide non-critical toolbar buttons based on available space
    //
    browser_widthheight = Browser.GetBrowserWidthHeight(Connect_Window);
    toolbar_table_widthheight = Browser.GetElementWidthHeight(Connect.toolbar_div.firstChild);
    show = (toolbar_table_widthheight.width <= (browser_widthheight.width - Connect.layout_current_offset));
    if (show) {
        // Show buttons in reverse order
        //
        for (index = Connect.button_degradation_order.length - 1; index >= 0; index -= 1) {
            done = handle_showhide(index, show);
            if (done) {
                break;
            }
        }
    } else {
        // Hide buttons in default order
        //
        for (index = 0; index < Connect.button_degradation_order.length; index += 1) {
            done = handle_showhide(index, show);
            if (done) {
                break;
            }
        }
    }
};

Connect.AdjustLayoutForBrowserSize = function () {
    'use strict';

    var previous_layout_wide, toolbar_buttons, left_button, right_button, index, toolbar_button;

    // Adjust navigation based on available space
    //
    previous_layout_wide = Connect.layout_wide;
    Connect.layout_wide = Connect.CalculateLayoutWide();

    // Layout changed?
    //
    if (Connect.layout_wide) {
        // Layout
        //
        Connect.layout_div.className = 'layout_wide';
        Connect.layout_current_offset = Connect.layout_wide_offset;

        // Switched from small view?
        //
        if (previous_layout_wide === false) {
            Connect.sidebar_auto_display = (Connect.navigation_width > 0);
        }
    } else {
        // Layout
        //
        Connect.layout_div.className = 'layout_narrow';
        Connect.layout_current_offset = Connect.layout_narrow_offset;
    }

    // Update toolbar buttons
    //
    toolbar_buttons = Connect.toolbar_div.getElementsByTagName('span');
    for (index = 0; index < toolbar_buttons.length; index += 1) {
        toolbar_button = toolbar_buttons[index];
        if ((Browser.ContainsClass(toolbar_button.className, 'ww_skin_toolbar_button_left')) || (Browser.ContainsClass(toolbar_button.className, 'ww_skin_toolbar_button_center')) || (Browser.ContainsClass(toolbar_button.className, 'ww_skin_toolbar_button_right'))) {
            if (left_button === undefined) {
                left_button = toolbar_button;
            }
            right_button = toolbar_button;
        }
    }
    if (left_button !== undefined) {
        if (Connect.layout_wide) {
            left_button.className = Browser.AddClass(left_button.className, 'ww_skin_toolbar_left_background');
        } else {
            left_button.className = Browser.RemoveClass(left_button.className, 'ww_skin_toolbar_left_background');
        }
    }
    if (right_button !== undefined) {
        if (Connect.layout_wide) {
            right_button.className = Browser.AddClass(right_button.className, 'ww_skin_toolbar_right_background');
        } else {
            right_button.className = Browser.RemoveClass(right_button.className, 'ww_skin_toolbar_right_background');
        }
    }

    // Update search form
    //
    if (Connect.search_input !== null) {
        if (Connect.layout_wide) {
            if ((Connect.Panel.Visible()) && (!Connect.Panel.display_as_sidebar)) {
                Connect.search_input.style.display = 'none';
            } else {
                Connect.search_input.style.display = 'inline';
            }
        } else {
            Connect.search_input.style.display = 'none';
        }
    }

    // Update side panel layout
    //
    if (Connect.Panel.Visible()) {
        // Adjust layout
        //
        if ((Connect.layout_wide) && (Connect.Panel.display_as_sidebar)) {
            Connect.Panel.panel_frame.className = Browser.AddClass(Connect.Panel.panel_frame.className, 'ww_skin_panel_frame_side');
            Connect.Panel.panel_frame.style.width = String(Connect.navigation_width) + 'px';
            Connect.Panel.page_div.style.display = 'block';
            Connect.Panel.page_div.style.visibility = 'visible';
            Connect.page_iframe.style.display = 'block';
            Connect.page_iframe.style.visibility = 'visible';
        } else {
            Connect.Panel.panel_frame.className = Browser.RemoveClass(Connect.Panel.panel_frame.className, 'ww_skin_panel_frame_side');
            Connect.Panel.panel_frame.style.width = 'auto';
            Connect.Panel.page_div.style.visibility = 'hidden';
            Connect.Panel.page_div.style.display = 'none';
        }
    } else {
        // Display default side panel
        //
        if (!Connect.panel_changing) {
            if ((Connect.layout_wide) && (Connect.sidebar_auto_display) && (Connect.sidebar_behavior !== undefined)) {
                Connect.button_behaviors[Connect.sidebar_behavior]();
            }
        }
    }
};

Connect.AdjustForContentSize = function () {
    'use strict';

    var navigation_widthheight, browser_widthheight, target_page_width, data, page_document, page_widthheight, height, element;

    // Halt adjustment requests
    //
    if (Connect.adjust_for_content_size_timeout !== null) {
        Connect_Window.clearTimeout(Connect.adjust_for_content_size_timeout);
        Connect.adjust_for_content_size_timeout = null;
    }

    // Adjust navigation based on available space
    //
    Connect.AdjustLayoutForBrowserSize();

    // Determine navigation width
    //
    navigation_widthheight = { width: 0, height: 0 };
    if (Connect.Panel.Visible()) {
        navigation_widthheight.width = Connect.navigation_width + Connect.panel_side_offset;
    }

    // Set content width
    //
    browser_widthheight = Browser.GetBrowserWidthHeight(Connect_Window);
    Connect.presentation_div.style.width = String(browser_widthheight.width - Connect.layout_current_offset) + 'px';
    target_page_width = browser_widthheight.width - navigation_widthheight.width - Connect.layout_current_offset;
    Connect.page_div.style.width = String(target_page_width) + 'px';

    // Adjust toolbar
    //
    Connect.AdjustToolbarForBrowserSize();

    // Consider page content?
    //
    if (Connect.page_div.style.visibility === 'visible') {
        // Parcel page?
        //
        if (Connect.page_info !== undefined) {
            // Set max width for page (minus a couple of pixels)
            //
            data = {
                'action': 'page_set_max_width',
                'max_width': String(target_page_width - 4) + 'px',
                'target_width': target_page_width
            };
            Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
        } else {
            // Try to update the frame directly
            //
            try {
                // Set max width for page (minus a couple of pixels)
                //
                page_document = Browser.GetDocument(Connect.page_iframe);
                page_document.body.style.maxWidth = String(target_page_width - 4) + 'px';

                // Adjust for content width
                //
                page_widthheight = Browser.GetIFrameContentWidthHeight(Connect.page_iframe);
                if (page_widthheight.width > target_page_width) {
                    Connect.presentation_div.style.width = String(navigation_widthheight.width + page_widthheight.width) + 'px';
                    Connect.page_div.style.width = String(page_widthheight.width) + 'px';
                }

                // Set content height
                //
                Connect_Window.setTimeout(Connect.AdjustForContentSize_Height, 1);
            } catch (possible) {
                // Set to browser height and let scrollbars do their thing
                //
                height = browser_widthheight.height;
                element = Connect.page_div;
                while (element !== Connect_Window.document.body) {
                    height -= element.offsetTop;

                    element = element.offsetParent;
                }
                height -= Connect.layout_height_tolerance;
                Connect.page_div.style.height = String(height) + 'px';
            }
        }
    }
};

Connect.AdjustForContentSize_Height = function () {
    'use strict';

    var update_height, page_widthheight, page_div_height;

    // Update content height?
    //
    update_height = true;
    page_widthheight = Browser.GetIFrameContentWidthHeight(Connect.page_iframe);
    page_div_height = parseInt(Connect.page_div.style.height, 10);

    // Address IE short-comings
    //
    if (Connect_Window.navigator.userAgent.indexOf('MSIE') !== -1) {
        page_widthheight.height += (Connect.layout_height_tolerance - 2);
    }

    // Need to update height?
    //
    if (!isNaN(page_div_height)) {
        if ((page_widthheight.height >= page_div_height) && (page_widthheight.height < (page_div_height + Connect.layout_height_tolerance))) {
            update_height = false;
        }
        if (Connect.globe_enabled) {
            Connect.globalized_sized_count += 1;
            if (Connect.globalized_sized_count > 3) {
                update_height = false;
            }
        }
    }

    // Set content height
    //
    if (update_height) {
        Connect.page_div.style.height = String(page_widthheight.height) + 'px';
    }
};

Connect.OnResize = function () {
    'use strict';

    // Adjust for content size
    //
    if (Connect.adjust_for_content_size_timeout !== null) {
        Connect_Window.clearTimeout(Connect.adjust_for_content_size_timeout);
    }
    Connect.adjust_for_content_size_timeout = Connect_Window.setTimeout(Connect.AdjustForContentSize, 100);
};

Connect.Parcel_Load = function () {
    'use strict';

    var ajaxdata;

    ajaxdata = new AJAXData_Object(Connect.parcel_anchors,
        function (param_entry) {
            return param_entry.href;
        },
        function (param_percent) {
            Progress.Update(param_percent);
        },
        function (param_entry, param_ajax) {
            var parcel_div, context_and_id, parcel_context, parcel_id, parcel_toc_div_id, parcel_toc_div, toc_ul, parcel_data_div_id, parcel_data_div, first_page_div, last_page_div, first_page_a, last_page_a;

            // Access parcel
            //
            parcel_div = Connect_Window.document.createElement('div');
            parcel_div.style.visibility = 'hidden';
            parcel_div.innerHTML = param_ajax.responseText;
            Connect_Window.document.body.appendChild(parcel_div);

            // Add to collection of valid parcels
            //
            context_and_id = param_entry.id.split(':');
            parcel_context = context_and_id[0];
            parcel_id = context_and_id[1];
            Connect.AddParcel(parcel_context, parcel_id, param_entry.href, param_entry.innerHTML);

            // TOC
            //
            parcel_toc_div_id = 'toc:' + parcel_id;
            parcel_toc_div = Connect_Window.document.getElementById(parcel_toc_div_id);
            if (parcel_toc_div !== null) {
                toc_ul = Browser.FirstChildElementWithTagName(parcel_toc_div, 'ul');
                if (toc_ul !== null) {
                    // Extract TOC data
                    //
                    if (Connect.parcel_anchors.length === 1) {
                        // Suppress parcel (group) folder
                        //
                        param_entry.parentNode.parentNode.parentNode.parentNode.appendChild(toc_ul);
                    } else {
                        // Preserve parcel (group) folder
                        //
                        param_entry.parentNode.parentNode.appendChild(toc_ul);
                    }
                }
            }

            // Data
            //
            parcel_data_div_id = 'data:' + parcel_id;
            parcel_data_div = Connect_Window.document.getElementById(parcel_data_div_id);
            if (parcel_data_div !== null) {
                Connect.parcels_div.appendChild(parcel_data_div);

                // Add "bridge" links
                //
                first_page_div = Connect_Window.document.getElementById('page:' + parcel_id + ':first');
                last_page_div = Connect_Window.document.getElementById('page:' + parcel_id + ':last');
                first_page_a = Browser.FirstChildElementWithTagName(first_page_div, 'a');
                last_page_a = Browser.FirstChildElementWithTagName(last_page_div, 'a');
                Connect.link_bridge.Track(first_page_a, last_page_a);
            }

            // Remove parcel data
            //
            Connect_Window.document.body.removeChild(parcel_div);

            // Disable parcel link
            //
            if (Connect.parcel_anchors.length === 1) {
                param_entry.parentNode.parentNode.parentNode.parentNode.removeChild(param_entry.parentNode.parentNode.parentNode);
            } else {
                Browser.RemoveAttribute(param_entry, 'href', '');
            }
        },
        function () {
            var buttons_to_remove, button_to_remove;

            // Parcels loaded!
            //
            Connect.parcels_loaded = true;

            // Configure TOC levels
            //
            Connect.ConfigureTOCLevels(Connect.toc_div);

            // Intercept all clicks
            //
            Browser.ApplyToChildElementsWithTagName(Connect.toc_div, 'a',
                function (param_link) {
                    param_link.onclick = Connect.NavigationLink;

                    // Track container clicks as well
                    //
                    param_link.parentNode.onclick = Connect.NavigationEntryClick;
                });

            // Track folder clicks
            //
            Browser.ApplyToChildElementsWithTagName(Connect.toc_div, 'div',
                function (param_div) {
                    if (Browser.ContainsClass(param_div.className, 'ww_skin_toc_folder')) {
                        param_div.onclick = Connect.NavigationEntryClick;
                    }
                });

            // Intercept toolbar links
            //
            buttons_to_remove = [];
            Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'a',
                function (param_link) {
                    var match, button_key, button_span, keep;

                    param_link.onclick = Connect.ToolbarLink;

                    // Track buttons
                    //
                    match = param_link.className.match(Connect.button_behavior_expression);
                    if (match !== null) {
                        button_key = match[0];
                        button_span = Browser.FindParentWithTagName(param_link, 'span');
                        if (button_span !== null) {
                            // Keep button?
                            //
                            keep = true;
                            if (Connect_Window.document.location.protocol === 'file:') {
                                if (button_key === 'ww_behavior_globe') {
                                    keep = false;
                                }
                            }

                            // Process button
                            //
                            if (keep) {
                                Connect.buttons[button_key] = button_span;

                                // Initialize sidebar behavior
                                //
                                if ((Connect.sidebar_behavior === undefined) && ((button_key === 'ww_behavior_toc') || (button_key === 'ww_behavior_index'))) {
                                    Connect.sidebar_behavior = button_key;
                                }
                            } else {
                                buttons_to_remove[buttons_to_remove.length] = button_span;
                            }
                        }
                    }
                });

            // Remove buttons
            //
            while (buttons_to_remove.length > 0) {
                button_to_remove = buttons_to_remove.shift();
                button_to_remove.parentNode.removeChild(button_to_remove);
            }

            // Handle toolbar search
            //
            if (Connect_Window.navigator.userAgent.indexOf('MSIE') === -1) {
                // Use toolbar search form
                //
                Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'form',
                    function (param_form) {
                        if (Browser.ContainsClass(param_form.className, 'ww_skin_search_form')) {
                            param_form.onsubmit = function () { Connect.Button_Search(); return false; };
                        }
                    });
                Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'input',
                    function (param_input) {
                        if (Browser.ContainsClass(param_input.className, 'ww_skin_search_input')) {
                            Connect.search_input = param_input;
                        }
                    });
            } else {
                // Eliminate toolbar search form for IE
                //
                Browser.ApplyToChildElementsWithTagName(Connect.toolbar_div, 'form',
                    function (param_form) {
                        var parent_element, button_span;

                        // Promote button to form peer
                        //
                        parent_element = param_form.parentNode;
                        button_span = Connect.buttons['ww_behavior_search'];
                        if (button_span !== undefined) {
                            parent_element.insertBefore(button_span, param_form);
                        }

                        // Remove search form
                        //
                        parent_element.removeChild(param_form);
                    });
            }

            // Display specified document
            //
            if (Connect_Window.location.hash.length > 0) {
                // Use hash
                //
                Connect.DisplaySpecifiedDocument();
            } else {
                // Process default page load
                //
                Connect.DisplayPage(Connect.default_page_url);
            }

            // Check for hash changes
            //
            if (('onhashchange' in Connect_Window) && (typeof Connect_Window.history.pushState === 'function')) {
                // Events are so nice!
                //
                Connect_Window.onhashchange = Connect.HashChanged;
            } else {
                // Poll
                //
                Connect.poll_onhashchange = function () {
                    Connect.HashChanged();

                    Connect_Window.setTimeout(Connect.poll_onhashchange, 100);
                };
                Connect_Window.setTimeout(Connect.poll_onhashchange, 1);
            }

            // Done!
            //
            Progress.Complete();

            // Show
            //
            Connect.presentation_div.style.visibility = 'visible';
        });
    ajaxdata.Execute();
};

Connect.DisplaySpecifiedDocument = function () {
    'use strict';

    var specified_document_url, context_and_topic, topic_index, context, topic, parcel_id, topic_id, topic_anchor, search_words_parameter, search_words, page_base_relative_url, page_url;

    // Hide panel
    //
    if ((!Connect.layout_wide) || (!Connect.Panel.display_as_sidebar)) {
        Connect.Panel.Hide();
    }

    // Start page load
    //
    specified_document_url = Connect.default_page_url;
    if ((Connect_Window.location.hash === '') || (Connect_Window.location.hash === '#')) {
        // Show default page
        //
        specified_document_url = Connect.default_page_url;
    } else if ((Connect_Window.location.hash.indexOf('#context/') === 0)) {
        // Context/topic requested
        //
        context_and_topic = Connect_Window.location.hash.substring(9);
        topic_index = context_and_topic.indexOf('/');
        context = context_and_topic.substring(0, topic_index);
        topic = context_and_topic.substring(topic_index + 1);

        // Resolve context
        //
        if ((context.length > 0) && (topic.length > 0) && (typeof Connect.parcel_context_ids[context] === 'string')) {
            parcel_id = Connect.parcel_context_ids[context];
            topic_id = 'topic:' + parcel_id + ':' + topic;
            topic_anchor = Connect_Window.document.getElementById(topic_id);
            if (topic_anchor !== null) {
                // Found topic!
                //
                specified_document_url = topic_anchor.href;
            }
        }
    } else if (Connect_Window.location.hash.indexOf('#search/') === 0) {
        // Search enabled?
        //
        if (Connect.search_div !== null) {
            // Page requested
            //
            search_words_parameter = Connect_Window.location.hash.substring(8);
            search_words = decodeURI(search_words_parameter);

            // Display search and default page on close
            //
            specified_document_url = undefined;
            Connect.Button_Search(search_words, Connect.default_page_url);
        }
    } else if (Connect_Window.location.hash.indexOf('#page/') === 0) {
        // Page requested
        //
        page_base_relative_url = Connect_Window.location.hash.substring(6);

        // Ignore top-level files
        //
        if (page_base_relative_url.indexOf('/') >= 0) {
            // Build secure URI
            //
            page_base_relative_url = decodeURI(page_base_relative_url);
            page_base_relative_url = page_base_relative_url.replace(/[\\<>:;"']|%5C|%3C|%3E|%3A|%3B|%22|%27/gi, '').replace(/%23/gi, '#');

            page_url = Connect.base_url + page_base_relative_url;
            specified_document_url = page_url;
        }
    }

    // Display specified document
    //
    if (specified_document_url !== undefined) {
        Connect.DisplayPage(specified_document_url);
    }
};

Connect.HashChanged = function () {
    'use strict';

    if (Connect_Window.location.hash !== Connect.hash) {
        // Update document
        //
        Connect.DisplaySpecifiedDocument();
    }
};

Connect.LocateTOCEntry = function () {
    'use strict';

    var result, page_id, possible_toc_entry_id, possible_toc_link, toc_page_element, toc_page_li, parent_li, toc_links, index, toc_link, division_index, linkid;

    result = null;

    // See if page exists in TOC
    //
    if (Connect.page_info !== undefined) {
        page_id = Connect.page_info.id;

        // Page ID defined?
        //
        if ((typeof page_id === 'string') && (page_id.length > 0)) {
            // Try instant lookup with document hash
            //
            if ((Connect.page_info.hash.length > 1) && (Connect.page_info.hash.charAt(0) === '#')) {
                possible_toc_entry_id = page_id + ':' + Connect.page_info.hash.substring(1);
                possible_toc_link = Connect_Window.document.getElementById(possible_toc_entry_id);
                if (possible_toc_link !== null) {
                    // TOC link located!
                    //
                    result = Browser.FindParentWithTagName(possible_toc_link, 'li');
                }
            }

            // Result found?
            //
            if (result === null) {
                // Check for page ID in TOC
                //
                toc_page_element = Connect_Window.document.getElementById(page_id);
                if (toc_page_element !== null) {
                    // Found page!
                    //
                    toc_page_li = Browser.FindParentWithTagName(toc_page_element, 'li');
                    parent_li = toc_page_li;
                    while ((result === null) && (parent_li !== null)) {
                        // Look for TOC entry
                        //
                        toc_links = parent_li.getElementsByTagName('a');
                        for (index = 0; index < toc_links.length; index += 1) {
                            // Check link ID
                            //
                            toc_link = toc_links[index];

                            // Same page?
                            //
                            if (toc_link.id.indexOf(page_id) === 0) {
                                // Locate division between page id and linkid
                                //
                                division_index = toc_link.id.indexOf(':');
                                if (division_index >= 0) {
                                    // Extract linkid and find it
                                    //
                                    linkid = toc_link.id.substring(division_index + 1);
                                    result = Browser.FindParentWithTagName(toc_link, 'li');
                                    break;
                                }
                            } else {
                                // Page changed, entry not found
                                //
                                parent_li = null;
                                break;
                            }
                        }

                        // Advance to next li
                        //
                        if (parent_li !== null) {
                            parent_li = parent_li.nextSibling;
                            while ((parent_li !== null) && (parent_li.nodeName.toLowerCase() !== 'li')) {
                                parent_li = parent_li.nextSibling;
                            }
                        }
                    }

                    if (result === null) {
                        // Fallback and use page match
                        //
                        result = toc_page_li;
                    }
                }
            }
        }
    }

    return result;
};

Connect.ConfigureTOCLevels = function (param_container_element) {
    'use strict';

    // Configure TOC levels
    //
    Browser.ApplyToChildElementsWithTagName(param_container_element, 'ul',
        function (param_ul) {
            var level, current_node, class_name;

            // Determine level
            //
            level = 1;
            current_node = param_ul.parentNode;
            while (current_node !== param_container_element) {
                if (current_node.nodeName.toLowerCase() === 'ul') {
                    level += 1;
                }

                current_node = current_node.parentNode;
            }

            // Initialize open/close
            //
            class_name = 'ww_skin_toc_level ww_skin_toc_level_' + level;
            if (level === 1) {
                class_name += ' ww_skin_toc_container_open';
            } else {
                class_name += ' ww_skin_toc_container_closed';
            }

            // Update class name
            //
            param_ul.className = class_name;
        });
};

Connect.ToolbarLink = function (param_event) {
    'use strict';

    var event, result;

    // Access event
    //
    event = param_event || window.event;

    // Cancel event bubbling
    //
    event.cancelBubble = true;
    if (event.stopPropagation) {
        event.stopPropagation();
    } else {
        event.cancelBubble = true;
    }

    // Process event
    //
    result = Connect.HandleToolbarLink(this);

    return result;
};

Connect.NavigationLink = function (param_event) {
    'use strict';

    var event, parent_div, result;

    // Access event
    //
    event = param_event || window.event;

    // Cancel event bubbling
    //
    event.cancelBubble = true;
    if (event.stopPropagation) {
        event.stopPropagation();
    } else {
        event.cancelBubble = true;
    }

    // Expand if closed folder
    //
    parent_div = Browser.FindParentWithTagName(this, 'div');
    if ((parent_div !== null) && (Browser.ContainsClass(parent_div.className, 'ww_skin_toc_folder'))) {
        Connect.TOCFolder_Open(parent_div);
    }

    // Process event
    //
    result = Connect.HandleInterceptLink(this);
    if (result === false) {
        // Hide panel
        //
        if ((Connect.layout_wide) && (Connect.Panel.display_as_sidebar)) {
            // Keep the panel active!
            //
            Connect.toc_cleanup_folders = false;
        } else {
            Connect.Panel.Hide();
        }
    }

    return result;
};

Connect.IndexLink = function (param_event) {
    'use strict';

    var result, event, hash_index, see_also_id, index_entry, position_element, scrollToLeft, scrollToTop;

    result = false;

    // Access event
    //
    event = param_event || window.event;

    // Cancel event bubbling
    //
    event.cancelBubble = true;
    if (event.stopPropagation) {
        event.stopPropagation();
    } else {
        event.cancelBubble = true;
    }

    // See/See Also link?
    //
    if (this.rel.toLowerCase() === 'see') {
        hash_index = this.href.indexOf('#');
        if (hash_index >= 0) {
            see_also_id = this.href.substring(hash_index + 1);

            index_entry = Connect_Window.document.getElementById(see_also_id);
            if (index_entry !== null) {
                position_element = index_entry;
                scrollToLeft = 0;
                scrollToTop = 0;
                while (position_element !== null) {
                    scrollToLeft += position_element.offsetLeft;
                    scrollToTop += position_element.offsetTop;

                    position_element = position_element.offsetParent;
                }
                Connect_Window.scrollTo(scrollToLeft, scrollToTop);
            }
        }

        result = false;
    } else {
        // Document link
        //
        result = Connect.HandleInterceptLink(this);
        if (result !== true) {
            // Hide panel
            //
            if ((!Connect.layout_wide) || (!Connect.Panel.display_as_sidebar)) {
                Connect.Panel.Hide();
            }
        }
    }

    return result;
};

Connect.TOC_ElementKey = function (param_element) {
    'use strict';

    var element_key, element_in_path, position, sibling;

    // Build key
    //
    element_key = '';
    element_in_path = param_element;
    while ((element_in_path !== undefined) && (element_in_path !== null) && ((typeof element_in_path.id !== 'string') || (element_in_path.id.length === 0))) {
        position = 0;
        sibling = element_in_path;
        while (sibling !== null) {
            position += 1;
            sibling = sibling.previousSibling;
        }
        element_key = element_in_path.nodeName + ':' + position + ':' + element_key;
        element_in_path = element_in_path.parentNode;
    }
    if ((element_in_path !== undefined) && (element_in_path !== null)) {
        element_key = element_in_path.id + ':' + element_key;
    }

    return element_key;
};

Connect.TOC_RecordClassState = function (param_element) {
    'use strict';

    var element_key;

    // Track original class info if enabled
    //
    if (Connect.toc_class_states !== null) {
        // Build key
        //
        element_key = Connect.TOC_ElementKey(param_element);

        // Already tracking?
        //
        if (typeof Connect.toc_class_states[element_key] !== 'object') {
            Connect.toc_class_states[element_key] = { 'element': param_element, 'className': param_element.className};
        }
    }
};

Connect.TOC_RestoreClassStates = function (param_folder_exceptions) {
    'use strict';

    var element_key, preserved_toc_class_states, entry_state;

    if (Connect.toc_class_states !== null) {
        preserved_toc_class_states = {};
        for (element_key in Connect.toc_class_states) {
            if (typeof Connect.toc_class_states[element_key] === 'object') {
                entry_state = Connect.toc_class_states[element_key];
                entry_state.element.className = entry_state.className;

                // Keep folder open?
                //
                if (Browser.ContainsClass(entry_state.className, 'ww_skin_toc_folder')) {
                    if ((param_folder_exceptions !== undefined) && (typeof param_folder_exceptions[element_key] === 'boolean')) {
                        // Keep folder open
                        //
                        preserved_toc_class_states[element_key] = entry_state;
                    } else {
                        // Collapse folder
                        //
                        Connect.TOCFolder_Close(entry_state.element);
                    }
                }
            }
        }

        // Reset tracked states
        //
        Connect.toc_class_states = preserved_toc_class_states;
    }
};

Connect.TOCFolder_Open = function (param_entry_div) {
    'use strict';

    var child_span, sibling_ul;

    if (Browser.ContainsClass(param_entry_div.className, 'ww_skin_toc_folder')) {
        Connect.TOC_RecordClassState(param_entry_div);

        child_span = Browser.FirstChildElementWithTagName(param_entry_div, 'span');
        if (child_span !== null) {
            child_span.className = Browser.ReplaceClass(child_span.className, 'ww_skin_toc_dropdown_closed', 'ww_skin_toc_dropdown_open');
        }
        sibling_ul = Browser.NextSiblingElementWithTagName(param_entry_div, 'ul');
        if (sibling_ul !== null) {
            sibling_ul.className = Browser.ReplaceClass(sibling_ul.className, 'ww_skin_toc_container_closed', 'ww_skin_toc_container_open');
        }
    }
};

Connect.TOCFolder_Close = function (param_entry_div) {
    'use strict';

    var child_span, sibling_ul;

    if (Browser.ContainsClass(param_entry_div.className, 'ww_skin_toc_folder')) {
        Connect.TOC_RecordClassState(param_entry_div);

        child_span = Browser.FirstChildElementWithTagName(param_entry_div, 'span');
        if (child_span !== null) {
            child_span.className = Browser.ReplaceClass(child_span.className, 'ww_skin_toc_dropdown_open', 'ww_skin_toc_dropdown_closed');
        }
        sibling_ul = Browser.NextSiblingElementWithTagName(param_entry_div, 'ul');
        if (sibling_ul !== null) {
            sibling_ul.className = Browser.ReplaceClass(sibling_ul.className, 'ww_skin_toc_container_open', 'ww_skin_toc_container_closed');
        }
    }
};

Connect.TOCFolder_Toggle = function (param_entry_div) {
    'use strict';

    var sibling_ul;

    if (Browser.ContainsClass(param_entry_div.className, 'ww_skin_toc_folder')) {
        sibling_ul = Browser.NextSiblingElementWithTagName(param_entry_div, 'ul');
        if (sibling_ul !== null) {
            if (Browser.ContainsClass(sibling_ul.className, 'ww_skin_toc_container_open')) {
                Connect.TOCFolder_Close(param_entry_div);
            } else if (Browser.ContainsClass(sibling_ul.className, 'ww_skin_toc_container_closed')) {
                Connect.TOCFolder_Open(param_entry_div);
            }
        }
    }
};

Connect.NavigationEntryClick = function (param_event) {
    'use strict';

    var result, event, child_link;

    // Access event
    //
    event = param_event || window.event;

    // Intended for the <div> tag?
    //
    if (this.nodeName.toLowerCase() === 'div') {
        // Clicked folder?
        //
        if (Browser.ContainsClass(this.className, 'ww_skin_toc_folder')) {
            // Toggle open/closed
            //
            Connect.TOCFolder_Toggle(this);
        } else {
            // Access child link
            //
            child_link = Browser.FirstChildElementWithTagName(this, 'a');
            if ((child_link !== null) && (child_link.href !== '')) {
                // Hide panel
                //
                if ((!Connect.layout_wide) || (!Connect.Panel.display_as_sidebar)) {
                    Connect.Panel.Hide();
                }

                // Display document as current page
                //
                Connect.DisplayPage(child_link.href);
            }
        }
    }

    return result;
};

Connect.DisplayPage = function (param_href) {
    'use strict';

    var target_href, desired_hash, same_document, data;

    // Workaround Google Chrome issues
    //
    Connect.page_iframe.style.display = 'block';
    Connect.page_iframe.style.visibility = 'visible';

    // Ensure target href is valid
    //
    target_href = param_href;
    if ((target_href === undefined) || (target_href === null) || (target_href.length === 0)) {
        target_href = Connect.splash_page_url;
    }

    if (Connect.page_info !== undefined) {
        // Determine desired hash
        //
        desired_hash = '';
        if (target_href.indexOf('#') !== -1) {
            desired_hash = target_href.substring(target_href.indexOf('#'));
        }

        // Load new document or update hash
        //
        same_document = Browser.SameDocument(Connect.page_info.href, target_href);
        if (same_document) {
            // Update hash
            //
            data = {
                'action': 'update_hash',
                'hash': desired_hash
            };
            Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);

            // Clear target_href
            //
            target_href = undefined;
        }
    }

    // Display target href if not already handled
    //
    if (target_href !== undefined) {
        // Display document as page
        //
        if (('onhashchange' in Connect_Window) && (typeof Connect_Window.history.pushState === 'function')) {
            Connect.page_iframe.contentWindow.location.replace(target_href);
        } else {
            Connect.page_iframe.contentWindow.location.assign(target_href);
        }
    }
};

Connect.InterceptLink = function (param_event) {
    'use strict';

    var result;

    result = Connect.HandleInterceptLink(this);

    return result;
};

Connect.HandleToolbarLink = function (param_link) {
    'use strict';

    var result, behavior;

    result = true;

    if (typeof param_link.className === 'string') {
        // Determine handlers for button
        //
        for (behavior in Connect.button_behaviors) {
            if (typeof Connect.button_behaviors[behavior] === 'function') {
                if (Browser.ContainsClass(param_link.className, behavior)) {
                    Connect.button_behaviors[behavior]();
                    result = false;
                    break;
                }
            }
        }
    }

    return result;
};

Connect.HandleInterceptLink = function (param_link) {
    'use strict';

    var result;

    result = Connect.HandleToolbarLink(param_link);
    if (result === true) {
        // Standard link
        //
        if ((param_link.href !== undefined) && (param_link.href !== null) && (param_link.href !== '')) {
            if ((param_link.target === undefined) || (param_link.target === null) || (param_link.target === '') || (param_link.target === 'connect_page')) {
                // Use existing page iframe
                //
                Connect.DisplayPage(param_link.href);
            } else {
                // Display in requested window
                //
                Connect_Window.open(param_link.href, param_link.target);
            }

            // Prevent default link behavior
            //
            result = false;
        }
    }

    return result;
};

Connect.DocumentBookkeeping = function (param_same_document) {
    'use strict';

    var cleanup_folders, relative_path, page_hash, page_href, data, behavior;

    // Handle TOC sync
    //
    cleanup_folders = Connect.toc_cleanup_folders;
    Connect.toc_cleanup_folders = true;

    // Determine relative path
    //
    if (Connect.page_info !== undefined) {
        // Update hash
        //
        if (Browser.SameHierarchy(Connect.base_url, Connect.page_info.href)) {
            relative_path = Browser.RelativePath(Connect.base_url, Connect.page_info.href);
            page_hash = '#page/' + encodeURI(relative_path);

            // Splash page?
            //
            if (Browser.SameDocument(Connect.default_page_url, Connect.page_info.href)) {
                if ((Connect_Window.location.hash === page_hash) || (Connect_Window.location.hash === decodeURI(page_hash)) || (Connect_Window.location.hash === '')) {
                    // No change!
                    //
                    page_hash = Connect_Window.location.hash;
                }
            }

            if ((Connect_Window.location.hash !== page_hash) && (Connect_Window.location.hash !== decodeURI(page_hash))) {
                // Determine updated href with new hash
                //
                page_href = Connect_Window.location.href;
                if (Connect_Window.location.hash.length > 0) {
                    page_href = page_href.substring(0, page_href.lastIndexOf(Connect_Window.location.hash));
                }
                page_href += page_hash;

                // Update hash
                //
                if (('onhashchange' in Connect_Window) && (typeof Connect_Window.history.pushState === 'function')) {
                    Connect_Window.history.pushState('', '', page_href);
                } else {
                    Connect_Window.location.replace(page_href);
                }
            }
        }

        // Track current hash
        //
        Connect.hash = Connect_Window.location.hash;

        // Scroll to top if necessary
        //
        if (Connect.page_info.hash === '') {
            Connect_Window.scroll(0, 0);
        }

        // Make visible
        //
        Connect.page_div.style.visibility = 'visible';

        // Sync TOC
        //
        Connect.SyncTOC(cleanup_folders);

        // Adjust for content size
        //
        if (param_same_document) {
            Connect.AdjustLayoutForBrowserSize();
        } else {
            Connect.AdjustForContentSize();

            // Update anchors
            //
            data = {
                'action': 'update_anchors',
                'target': Connect_Window.name,
                'base_url': Connect.base_url,
                'parcel_prefixes': Connect.parcel_prefixes,
                'button_behaviors': {}
            };
            for (behavior in Connect.button_behaviors) {
                if (typeof Connect.button_behaviors[behavior] === 'function') {
                    data.button_behaviors[behavior] = true;
                }
            }
            Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
        }
    }
};

Connect.Socialize = function () {
    'use strict';

    var data;

    // Socialize
    //
    data = {
        'action': 'page_socialize',
        'disqus_id': Connect.disqus_id
    };
    Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
};

Connect.Globalize = function () {
    'use strict';

    var data;

    // Google Translation
    //
    if (Connect.globe_enabled) {
        data = {
            'action': 'page_globalize'
        };
        Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
    }
};

Connect.AdjustForSearchContentSize = function () {
    'use strict';

    var data;

    data = {
        'action': 'search_get_page_size',
        'stage': 'width'
    };
    Message.Post(Connect.search_iframe.contentWindow, data, Connect_Window);
};

Connect.UpdatePrevNextButton = function (param_button_behavior, param_link_rel) {
    'use strict';

    var button_span, button_a, prevnext_link, enabled_class, disabled_class, updated_className;

    button_span = Connect.buttons[param_button_behavior];
    if (button_span !== undefined) {
        button_a = Browser.FirstChildElementWithTagName(button_span, 'a');
        if (button_a !== null) {
            prevnext_link = Connect.GetPrevNext(param_link_rel);
            enabled_class = 'ww_skin_' + param_link_rel.toLowerCase() + '_enabled';
            disabled_class = 'ww_skin_' + param_link_rel.toLowerCase() + '_disabled';

            // Update class name
            //
            updated_className = Browser.RemoveClass(Browser.RemoveClass(button_a.className, enabled_class), disabled_class);
            if (prevnext_link !== undefined) {
                // Enable
                //
                updated_className = Browser.AddClass(updated_className, enabled_class);
            } else {
                // Disable
                //
                updated_className = Browser.AddClass(updated_className, disabled_class);
            }
            button_a.className = updated_className;
        }
    }
};

Connect.Listen = function (param_event) {
    'use strict';

    // Initialize listen dispatcher
    //
    if (Connect.dispatch_listen === undefined) {
        Connect.dispatch_listen = {
            'page_load': function (param_data) {
                Connect.page_info = param_data;
                delete Connect.page_info['action'];

                Connect.OnDocumentLoad();
                Connect.ignore_page_load = true;
            },
            'page_unload': function (param_data) {
                Connect.page_info = undefined;
            },
            'page_size': function (param_data) {
                var navigation_widthheight, data, update_height, page_div_height;

                if (Connect.page_info !== undefined) {
                    // Update dimensions
                    //
                    Connect.page_info.dimensions = param_data.dimensions;

                    // Handle resize
                    //
                    if (param_data.stage === 'width') {
                        if (Connect.page_info.dimensions.width > param_data.target_width) {
                            // Determine navigation width
                            //
                            navigation_widthheight = { width: 0, height: 0 };
                            if (Connect.Panel.Visible()) {
                                navigation_widthheight.width = Connect.navigation_width + Connect.panel_side_offset;
                            }

                            Connect.presentation_div.style.width = String(navigation_widthheight.width + Connect.page_info.dimensions.width) + 'px';
                            Connect.page_div.style.width = String(Connect.page_info.dimensions.width) + 'px';
                        }

                        // Update height
                        //
                        data = {
                            'action': 'get_page_size',
                            'stage': 'height'
                        };
                        Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
                    } else if (param_data.stage === 'height') {
                        // Update content height?
                        //
                        update_height = true;
                        page_div_height = parseInt(Connect.page_div.style.height, 10);

                        // Address IE short-comings
                        //
                        if (Connect_Window.navigator.userAgent.indexOf('MSIE') !== -1) {
                            Connect.page_info.dimensions.height += (Connect.layout_height_tolerance - 2);
                        }

                        // Need to update height?
                        //
                        if (!isNaN(page_div_height)) {
                            if ((Connect.page_info.dimensions.height >= page_div_height) && (Connect.page_info.dimensions.height < (page_div_height + Connect.layout_height_tolerance))) {
                                update_height = false;
                            }
                            if (Connect.globe_enabled) {
                                Connect.globalized_sized_count += 1;
                                if (Connect.globalized_sized_count > 3) {
                                    update_height = false;
                                }
                            }
                        }

                        // Set content height
                        //
                        if (update_height) {
                            Connect.page_div.style.height = String(Connect.page_info.dimensions.height) + 'px';
                        }
                    }
                }
            },
            'page_bookkeeping': function (param_data) {
                // Document bookkeeping
                //
                Connect.DocumentBookkeeping(true);
            },
            'notify_page_max_width_set': function (param_data) {
                var data;

                // Adjust for content width
                //
                if (Connect.page_div.style.visibility === 'visible') {
                    data = {
                        'action': 'get_page_size',
                        'stage': 'width'
                    };
                    Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
                }
            },
            'page_content_changed': function (param_data) {
                // Initiate resize operation
                //
                Connect.OnResize();
            },
            'handle_toolbar_link' : function (param_data) {
                // Invoke toolbar link
                //
                Connect.button_behaviors[param_data.behavior]();
            },
            'display_link': function (param_data) {
                if ((param_data.target === undefined) || (param_data.target === null) || (param_data.target === '') || (param_data.target === 'connect_page')) {
                    // Use existing page iframe
                    //
                    Connect.DisplayPage(param_data.href);
                } else {
                    // Display in requested window
                    //
                    Connect_Window.open(param_data.href, param_data.target);
                }
            },
            'display_image': function (param_data) {
                Connect.DisplayFullsizeImage(param_data);
            },
            'search_page_load': function (param_data) {
                var data;

                // Record page info
                //
                Connect.search_page_info = param_data;
                delete Connect.search_page_info['action'];

                // Send search file list
                //
                data = {
                    'action': 'search_connect_info',
                    'target': Connect_Window.name,
                    'base_url': Connect.base_url,
                    'parcel_prefixes': Connect.parcel_prefixes,
                    'parcel_sx': Connect.parcel_sx
                };
                Message.Post(Connect.search_iframe.contentWindow, data, Connect_Window);
            },
            'search_ready': function (param_data) {
                var data;

                // Search panel displayed?
                //
                if (Connect.search_div.parentNode !== Connect.panels_div) {
                    // Execute search
                    //
                    data = {
                        'action': 'search_execute',
                        'query': Connect.search_query
                    };
                    Message.Post(Connect.search_iframe.contentWindow, data, Connect_Window);
                }
            },
            'search_complete': function (param_data) {
                // Update search words
                //
                Connect.search_query = param_data.query;

                // Update dimensions
                //
                Connect.search_page_info.dimensions = param_data.dimensions;

                // Adjust layout for search content
                //
                Connect.AdjustForSearchContentSize();
            },
            'search_page_size': function (param_data) {
                var data, update_height, search_div_height;

                // Update dimensions
                //
                Connect.search_page_info.dimensions = param_data.dimensions;

                // Handle resize
                //
                if (param_data.stage === 'width') {
                    // Update height
                    //
                    data = {
                        'action': 'search_get_page_size',
                        'stage': 'height'
                    };
                    Message.Post(Connect.search_iframe.contentWindow, data, Connect_Window);
                } else if (param_data.stage === 'height') {
                    // Update content height?
                    //
                    update_height = true;
                    search_div_height = parseInt(Connect.search_div.style.height, 10);

                    // Address IE short-comings
                    //
                    if (Connect_Window.navigator.userAgent.indexOf('MSIE') !== -1) {
                        Connect.search_page_info.dimensions.height += (Connect.layout_height_tolerance - 2);
                    }

                    // Need to update height?
                    //
                    if (!isNaN(search_div_height)) {
                        if ((Connect.search_page_info.dimensions.height >= search_div_height) && (Connect.search_page_info.dimensions.height < (search_div_height + Connect.layout_height_tolerance))) {
                            update_height = false;
                        }
                    }

                    // Set content height
                    //
                    if (update_height) {
                        Connect.search_div.style.height = String(Connect.search_page_info.dimensions.height) + 'px';
                    }
                }
            },
            'search_display_link': function (param_data) {
                // Queue page for display
                //
                Connect.Panel.page_url = param_data.href;

                // Shutdown panel
                //
                Connect_Window.setTimeout(Connect.Button_Search, 1);
            }
        };
    }

    // Dispatch event
    //
    try {
        Connect.dispatch_listen[param_event.data.action](param_event.data);
    } catch (ignore) {
        // Keep on rolling
        //
    }
};

Connect.OnDocumentLoad = function () {
    'use strict';

    var title, page_document;

    // Environment initialized?
    //
    if (Connect.ignore_page_load) {
        Connect.ignore_page_load = false;
    } else {
        if (Connect.parcels_loaded) {
            // Document bookkeeping
            //
            Connect.DocumentBookkeeping(false);

            // Update window title
            //
            title = '';
            if (Connect.page_info !== undefined) {
                title = Connect.page_info.title;
            } else {
                page_document = Browser.GetDocument(Connect.page_iframe);
                if (page_document !== undefined) {
                    title = page_document.title;
                }
            }
            Connect_Window.document.title = title;

            // Update prev/next
            //
            Connect.UpdatePrevNextButton('ww_behavior_prev', 'Prev');
            Connect.UpdatePrevNextButton('ww_behavior_next', 'Next');

            // Socialize and Globalize
            //
            Connect_Window.setTimeout(function () { Connect.Socialize(); Connect.Globalize(); }, 1);

            // Double-check sizing
            //
            Connect.OnResize();
        }
    }
};

Connect.DisplayFullsizeImage = function (param_image_data) {
    'use strict';

    var browser_widthheight, fullsize_image;

    // Retrieve width/height info
    //
    browser_widthheight = Browser.GetBrowserWidthHeight(Connect_Window);

    // Enough room for lightbox?
    //
    if (((param_image_data.width + Connect.lightbox_min_pixel_margin) < browser_widthheight.width) && ((param_image_data.height + Connect.lightbox_min_pixel_margin) < browser_widthheight.height)) {
        // Create image to display
        //
        fullsize_image = Connect_Window.document.createElement('img');
        Browser.SetAttribute(fullsize_image, 'width', param_image_data.width);
        Browser.SetAttribute(fullsize_image, 'height', param_image_data.height);
        Browser.SetAttribute(fullsize_image, 'src', param_image_data.src);

        // Display lightbox
        //
        Connect.Lightbox.Display(
            function (param_lightbox_content) {
                param_lightbox_content.appendChild(fullsize_image);
            },
            function (param_lightbox_content) {
                param_lightbox_content.removeChild(fullsize_image);
            }
        );
    } else {
        // Replace displayed document
        //
        Connect.DisplayPage(param_image_data.href);
    }
};

Connect.SyncTOC = function (param_cleanup_folders) {
    'use strict';

    var entry_state, toc_entry, entry_div, folder_exceptions, parent_ul, parent_entry_div;

    // Clear highlight
    //
    if (Connect.toc_selected_entry_key !== undefined) {
        entry_state = Connect.toc_class_states[Connect.toc_selected_entry_key];
        if (entry_state !== undefined) {
            entry_state.element.className = entry_state.className;
        }

        Connect.toc_selected_entry_key = undefined;
    }

    // Locate TOC entry
    //
    toc_entry = Connect.LocateTOCEntry();

    // Expand TOC for context
    //
    if (toc_entry !== null) {
        // Highlight entry
        //
        entry_div = Browser.FirstChildElementWithTagName(toc_entry, 'div');
        if (entry_div !== null) {
            // Clean up folders?
            //
            if (param_cleanup_folders) {
                folder_exceptions = {};
                if (Browser.ContainsClass(entry_div.className, 'ww_skin_toc_folder')) {
                    folder_exceptions[Connect.TOC_ElementKey(entry_div)] = true;
                }
                parent_ul = Browser.FindParentWithTagName(entry_div, 'ul');
                while (parent_ul !== null) {
                    parent_entry_div = Browser.PreviousSiblingElementWithTagName(parent_ul, 'div');
                    if (parent_entry_div !== null) {
                        if (Browser.ContainsClass(parent_entry_div.className, 'ww_skin_toc_folder')) {
                            folder_exceptions[Connect.TOC_ElementKey(parent_entry_div)] = true;
                        }
                    }

                    parent_ul = Browser.FindParentWithTagName(parent_ul, 'ul');
                }
                Connect.TOC_RestoreClassStates(folder_exceptions);
            }

            // Highlight
            //
            Connect.TOC_RecordClassState(entry_div);
            entry_div.className = Browser.AddClass(entry_div.className, 'ww_skin_toc_entry_selected');
            Connect.toc_selected_entry_key = Connect.TOC_ElementKey(entry_div);

            // Expand entry and parents
            //
            Connect.TOCFolder_Open(entry_div);
            parent_ul = Browser.FindParentWithTagName(entry_div, 'ul');
            while (parent_ul !== null) {
                parent_entry_div = Browser.PreviousSiblingElementWithTagName(parent_ul, 'div');
                if (parent_entry_div !== null) {
                    Connect.TOCFolder_Open(parent_entry_div);
                }

                parent_ul = Browser.FindParentWithTagName(parent_ul, 'ul');
            }
        }
    }
};

Connect.Button_TOC = function () {
    'use strict';

    var button_span;

    button_span = Connect.buttons['ww_behavior_toc'];

    if (!Connect.Panel.Visible()) {
        // Show
        //
        Connect.Panel.Display(true,
            function (param_window, param_panel_content) {
                // Highlight toolbar button
                //
                if (button_span !== undefined) {
                    button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
                }

                // Sync TOC
                //
                Connect.SyncTOC(Connect.toc_cleanup_folders);

                // On Stage
                //
                param_panel_content.appendChild(Connect.toc_div);
            },
            function () {
                Connect.AdjustForContentSize();
            },
            function (param_window, param_panel_content) {
                // Backstage
                //
                Connect.panels_div.appendChild(Connect.toc_div);

                // Restore class info
                //
                Connect.TOC_RestoreClassStates();

                // Highlight toolbar button
                //
                if (button_span !== undefined) {
                    button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
                }
            });
    } else {
        // Panel currently displayed?
        //
        if ((button_span !== undefined) && (Browser.ContainsClass(button_span.className, 'ww_skin_toolbar_background_selected'))) {
            // Disable sidebar auto display
            //
            Connect.sidebar_auto_display = false;

            // Hide
            //
            Connect.Panel.Hide();
        } else {
            // Hide current panel
            //
            Connect.panel_changing = true;
            Connect.Panel.Hide();
            Connect.panel_changing = false;

            // Show this panel
            //
            Connect.Button_TOC();
        }
        Connect.OnResize();
    }
};

Connect.Button_Index = function () {
    'use strict';

    var button_span;

    button_span = Connect.buttons['ww_behavior_index'];

    if (!Connect.Panel.Visible()) {
        // Show
        //
        Connect.Panel.Display(true,
            function (param_window, param_panel_content) {
                var progress_div;

                // Highlight toolbar button
                //
                if (button_span !== undefined) {
                    button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
                }

                // On Stage
                //
                if (Connect.parcel_ix.length > 0) {
                    // Show progress
                    //
                    Connect.panel_progress_div.innerHTML = '';
                    progress_div = Connect_Window.document.getElementById('progress');
                    Connect.panel_progress_div.appendChild(progress_div);
                    param_panel_content.appendChild(Connect.panel_progress_div);
                    Progress.Reset();

                    // Initiate index load
                    //
                    Connect.index_div.innerHTML = '';
                    Connect_Window.setTimeout(Connect.Index_Load, 1);
                } else {
                    // Show index
                    //
                    param_panel_content.appendChild(Connect.index_div);
                }
            },
            function () {
                Connect.AdjustForContentSize();
            },
            function (param_window, param_panel_content) {
                // Backstage
                //
                Connect.panels_div.appendChild(Connect.index_div);

                // Highlight toolbar button
                //
                if (button_span !== undefined) {
                    button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
                }
            });
    } else {
        // Panel currently displayed?
        //
        if ((button_span !== undefined) && (Browser.ContainsClass(button_span.className, 'ww_skin_toolbar_background_selected'))) {
            // Disable sidebar auto display
            //
            Connect.sidebar_auto_display = false;

            // Hide
            //
            Connect.Panel.Hide();
        } else {
            // Hide current panel
            //
            Connect.panel_changing = true;
            Connect.Panel.Hide();
            Connect.panel_changing = false;

            // Show this panel
            //
            Connect.Button_Index();
        }
        Connect.OnResize();
    }
};

Connect.Index_Load = function () {
    'use strict';

    var ajaxdata;

    ajaxdata = new AJAXData_Object(Connect.parcel_ix,
        function (param_entry) {
            return param_entry.url;
        },
        function (param_percent) {
            Progress.Update(param_percent);
        },
        function (param_entry, param_ajax) {
            var parcel_data, parcel_index_div_id, parcel_index_div, parcel_entry_div;

            // Access parcel data
            //
            parcel_data = Connect_Window.document.createElement('div');
            parcel_data.style.visibility = 'hidden';
            parcel_data.innerHTML = param_ajax.responseText;
            Connect_Window.document.body.appendChild(parcel_data);

            // Index
            //
            parcel_index_div_id = 'index:' + param_entry.id;
            parcel_index_div = Connect_Window.document.getElementById(parcel_index_div_id);
            if ((parcel_index_div !== null) && (parcel_index_div.innerHTML.length > 0)) {
                parcel_entry_div = Connect_Window.document.createElement('div');
                parcel_entry_div.className = 'ww_skin_index_title';
                parcel_entry_div.innerHTML = Connect.parcel_title[param_entry.id];
                Connect.index_div.appendChild(parcel_entry_div);
                Connect.index_div.appendChild(parcel_index_div);
            }

            // Remove parcel data
            //
            Connect_Window.document.body.removeChild(parcel_data);
        },
        function () {
            var progress_div;

            // Parcel indexes loaded!
            //
            Connect.parcel_ix = [];

            // Intercept all clicks
            //
            Browser.ApplyToChildElementsWithTagName(Connect.index_div, 'a',
                function (param_link) {
                    param_link.onclick = Connect.IndexLink;
                });

            // Done!
            //
            Progress.Complete();
            progress_div = Connect_Window.document.getElementById('progress');
            Connect.panels_div.appendChild(Connect.panel_progress_div);
            Connect_Window.document.body.appendChild(progress_div);

            // On stage!
            //
            Connect.Panel.panel_content.appendChild(Connect.index_div);
        });
    ajaxdata.Execute();
};

Connect.Button_Search = function (param_search_words, param_page_url) {
    'use strict';

    var button_span;

    button_span = Connect.buttons['ww_behavior_search'];

    if (!Connect.Panel.Visible()) {
        // Show
        //
        Connect.Panel.Display(false,
            function (param_window, param_panel_content) {
                var search_words, search_document, page_pathname, page_document, data;

                // Highlight toolbar button
                //
                if (button_span !== undefined) {
                    button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
                }

                // Track default return page
                //
                Connect.Panel.page_url = param_page_url;

                // Hide search input
                //
                if (Connect.search_input !== null) {
                    Connect.search_input.style.display = 'none';
                }

                // Get search words
                //
                search_words = '';
                if ((param_search_words !== undefined) && (typeof param_search_words === 'string')) {
                    search_words = param_search_words;
                } else {
                    if ((Connect.search_input !== null)) {
                        search_words = Connect.search_input.value;
                    } else {
                        search_words = Connect.search_query;
                    }
                }

                // Update search words
                //
                Connect.search_query = search_words;

                // On Stage
                //
                param_panel_content.appendChild(Connect.search_div);

                // Execute search
                //
                if (Connect.search_iframe.src !== Connect.search_page_url) {
                    // Load page
                    //
                    Connect.search_iframe.src = Connect.search_page_url;
                } else {
                    // Search
                    //
                    data = {
                        'action': 'search_execute',
                        'query': Connect.search_query
                    };
                    Message.Post(Connect.search_iframe.contentWindow, data, Connect_Window);
                }
            },
            function () {
                Connect.AdjustForSearchContentSize();
            },
            function (param_window, param_panel_content) {
                var search_document;

                // Update search words
                //
                if (Connect.search_input !== null) {
                    Connect.search_input.value = Connect.search_query;
                }

                // Restore search input
                //
                if (Connect.search_input !== null) {
                    if (Connect.layout_wide) {
                        Connect.search_input.style.display = 'inline';
                    } else {
                        Connect.search_input.style.display = 'none';
                    }
                }

                // Backstage
                //
                Connect.panels_div.appendChild(Connect.search_div);

                // Highlight toolbar button
                //
                if (button_span !== undefined) {
                    button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
                }
            });
    } else {
        // Panel currently displayed?
        //
        if ((button_span !== undefined) && (Browser.ContainsClass(button_span.className, 'ww_skin_toolbar_background_selected'))) {
            // Hide
            //
            Connect.Panel.Hide();

            // Display specified page
            //
            if (Connect.Panel.page_url !== undefined) {
                Connect.DisplayPage(Connect.Panel.page_url);
                Connect.Panel.page_url = undefined;
            }
        } else {
            // Hide current panel
            //
            Connect.panel_changing = true;
            Connect.Panel.Hide();
            Connect.panel_changing = false;

            // Show this panel
            //
            Connect.Button_Search();
        }
        Connect.OnResize();
    }
};

Connect.Button_Globe = function () {
    'use strict';

    var button_span, page_document;

    // Panel visible?
    //
    if ((Connect.Panel.Visible()) && (!(Connect.Panel.display_as_sidebar))) {
        // Hide
        //
        Connect.Panel.Hide();
    }

    // Enabled?
    //
    button_span = Connect.buttons['ww_behavior_globe'];
    if (!Connect.globe_enabled) {
        // Highlight toolbar button
        //
        if (button_span !== undefined) {
            button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_default', 'ww_skin_toolbar_background_selected');
        }

        // Globalize
        //
        Connect.globe_enabled = true;
        Connect.globalized_sized_count = 0;
        Connect_Window.setTimeout(Connect.Globalize, 1);
    } else {
        // Disable globalization
        //
        Connect.globe_enabled = false;
        Connect.globalized_sized_count = 0;
        page_document = Browser.GetDocument(Connect.page_iframe);
        if (page_document !== undefined) {
            Connect_Window.setTimeout(function () { page_document.location.reload(); }, 1);
        }

        // Highlight toolbar button
        //
        if (button_span !== undefined) {
            button_span.className = Browser.ReplaceClass(button_span.className, 'ww_skin_toolbar_background_selected', 'ww_skin_toolbar_background_default');
        }
    }
};

Connect.GetPrevNext = function (param_prevnext) {
    'use strict';

    var result;

    if (Connect.page_info !== undefined) {
        result = Connect.page_info[param_prevnext];
        if (result === undefined) {
            // Spanning parcels?
            //
            if (Connect.link_bridge.Get(param_prevnext, Connect.page_info.id) !== null) {
                result = Connect.link_bridge.Get(param_prevnext, Connect.page_info.id);
            }
        }
    }

    return result;
};

Connect.GotoPrevNext = function (param_prevnext) {
    'use strict';

    var link_href;

    link_href = Connect.GetPrevNext(param_prevnext);
    if (link_href !== undefined) {
        Connect.DisplayPage(link_href);
    }
};

Connect.Button_Previous = function () {
    'use strict';

    // Panel visible?
    //
    if ((Connect.Panel.Visible()) && (!(Connect.Panel.display_as_sidebar))) {
        // Hide
        //
        Connect.Panel.Hide();
    }

    Connect.GotoPrevNext('Prev');
};

Connect.Button_Next = function () {
    'use strict';

    // Panel visible?
    //
    if ((Connect.Panel.Visible()) && (!(Connect.Panel.display_as_sidebar))) {
        // Hide
        //
        Connect.Panel.Hide();
    }

    Connect.GotoPrevNext('Next');
};

Connect.Button_Email = function () {
    'use strict';

    var location, message, mailto;

    // Panel visible?
    //
    if ((Connect.Panel.Visible()) && (!(Connect.Panel.display_as_sidebar))) {
        // Hide
        //
        Connect.Panel.Hide();
    }

    if (Connect.email.length > 0) {
        location = encodeURI(Connect_Window.location.href);
        message = 'Feedback: ' + location;
        if (Connect_Window.navigator.userAgent.indexOf('MSIE') !== -1) {
            message = message.replace('#', '%23');
        }
        mailto = 'mailto:' + Connect.email + '?subject=' + message + '&body=' + message;

        Connect_Window.open(mailto, '_blank');
    }
};

Connect.Button_Print = function () {
    'use strict';

    var page_window, data;

    // Try direct method
    //
    try {
        page_window = Connect.page_iframe.contentWindow || Connect_Window.frames['connect_page'];
        if ((page_window !== undefined) && (page_window !== null)) {
            page_window.print();
        }
    } catch (access_denied) {
        // Try page action
        //
        data = {
            'action': 'ww_behavior_print'
        };
        Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
    }
};

Connect.Button_PDF = function () {
    'use strict';

    var pdf_link, page_document, links, index, link, data;

    // Try page action
    //
    data = {
        'action': 'ww_behavior_pdf'
    };
    Message.Post(Connect.page_iframe.contentWindow, data, Connect_Window);
};
