// Copyright (c) 2010-2012 Quadralay Corporation.  All rights reserved.
//
// ePublisher 2012.2
//
// Validated with JSLint <http://www.jslint.com/>
//

/*jslint maxerr: 50, indent: 4 */
/*global window */
/*global Browser */
/*global Message */
/*global Parcels */

function WebWorks_WriteArrow(param_id, param_expanded) {
    'use strict';

    var arrow_class, dropdown_arrow_id;

    arrow_class = (param_expanded) ? 'ww_skin_page_dropdown_arrow_expanded' : 'ww_skin_page_dropdown_arrow_collapsed';
    dropdown_arrow_id = param_id + ":dd:arrow";
    window.document.write('&#160;<span id="' + dropdown_arrow_id + '" class="ww_skin ww_skin_dropdown_arrow ' + arrow_class + '">&#160;</span>');
}

function WebWorks_WriteDIVOpen(param_id, param_expanded) {
    'use strict';

    var dropdown_div_class, dropdown_div_id;

    dropdown_div_class = (param_expanded) ? 'ww_skin_page_dropdown_div_expanded' : 'ww_skin_page_dropdown_div_collapsed';
    dropdown_div_id = param_id + ":dd";
    window.document.write('<div id="' + dropdown_div_id + '" class="' + dropdown_div_class + '">');
}

function WebWorks_WriteDIVClose() {
    'use strict';

    window.document.write('</div>');
}

function WebWorks_ToggleDIV(param_id) {
    'use strict';

    var dropdown_div_id, dropdown_arrow_id, dropdown_div, dropdown_a, dropdown_div_className, dropdown_a_className;

    dropdown_div_id = param_id + ":dd";
    dropdown_arrow_id = param_id + ":dd:arrow";

    dropdown_div = window.document.getElementById(dropdown_div_id);
    dropdown_a = window.document.getElementById(dropdown_arrow_id);
    if ((dropdown_div !== null) && (dropdown_a !== null)) {
        dropdown_div_className = dropdown_div.className.replace('ww_skin_page_dropdown_div_expanded', '').replace('ww_skin_page_dropdown_div_collapsed', '');
        dropdown_a_className = dropdown_a.className.replace(' ww_skin_page_dropdown_arrow_expanded', '').replace(' ww_skin_page_dropdown_arrow_collapsed', '');
        if (dropdown_div.className.indexOf('ww_skin_page_dropdown_div_expanded') >= 0) {
            dropdown_div_className += 'ww_skin_page_dropdown_div_collapsed';
            dropdown_a_className += ' ww_skin_page_dropdown_arrow_collapsed';
        } else {
            dropdown_div_className += 'ww_skin_page_dropdown_div_expanded';
            dropdown_a_className += ' ww_skin_page_dropdown_arrow_expanded';
        }
        dropdown_div.className = dropdown_div_className;
        dropdown_a.className = dropdown_a_className;
    }

    Page.ContentChanged();

    return false;
}


// Page
//

var Page = {
    'window': window
};

Page.KnownParcelURL = function (param_url) {
    'use strict';

    var result;

    result = Parcels.KnownParcelURL(Page.connect_info.parcel_prefixes, param_url);

    return result;
};

Page.KnownParcelBaggageURL = function (param_url) {
    'use strict';

    var result;

    result = Parcels.KnownParcelBaggageURL(Page.connect_info.parcel_prefixes, param_url);

    return result;
};

Page.HandleToolbarLink = function (param_link) {
    'use strict';

    var result, behavior, data;

    result = true;

    if (typeof param_link.className === 'string') {
        // Determine handlers for button
        //
        for (behavior in Page.connect_info.button_behaviors) {
            if (typeof Page.connect_info.button_behaviors[behavior] === 'boolean') {
                if (Browser.ContainsClass(param_link.className, behavior)) {
                    // Invoke handler
                    //
                    data = {
                        'action': 'handle_toolbar_link',
                        'behavior': behavior
                    };
                    Message.Post(Page.window.parent, data, Page.window);

                    result = false;
                    break;
                }
            }
        }
    }

    return result;
};

Page.HandleInterceptLink = function (param_link) {
    'use strict';

    var result, image_src, resolved_image_src, data;

    result = Page.HandleToolbarLink(param_link);
    if (result === true) {
        if (Browser.GetAttribute(param_link, 'wwx:original-href') !== null) {
            // Resolve path to full-size image
            //
            image_src = Browser.GetAttribute(param_link, 'wwx:original-href');
            resolved_image_src = Browser.ResolveURL(Page.window.location.href, image_src);

            // Display image
            //
            data = {
                'action': 'display_image',
                'href': param_link.href,
                'src': resolved_image_src,
                'width': parseInt(Browser.GetAttribute(param_link, 'wwx:original-width'), 10),
                'height': parseInt(Browser.GetAttribute(param_link, 'wwx:original-height'), 10)
            };
            Message.Post(Page.window.parent, data, Page.window);

            // Prevent default link behavior
            //
            result = false;
        } else {
            // Standard link
            //
            if ((param_link.href !== undefined) && (param_link.href !== null) && (param_link.href !== '')) {
                // Display link
                //
                data = {
                    'action': 'display_link',
                    'href': param_link.href,
                    'target': param_link.target
                };
                Message.Post(Page.window.parent, data, Page.window);

                // Prevent default link behavior
                //
                result = false;
            }
        }
    }

    return result;
};

Page.InterceptLink = function (param_event) {
    'use strict';

    var result;

    // PDF?
    //
    if (Browser.ContainsClass(this.className, 'ww_behavior_pdf')) {
        // Process normally
        //
        result = true;
    } else {
        // Process event
        //
        result = Page.HandleInterceptLink(this);
    }

    return result;
};

Page.UpdateAnchors = function (param_document) {
    'use strict';

    var index, link;

    if (Page.anchors_updated === undefined) {
        Page.anchors_updated = true;

        for (index = param_document.links.length - 1; index >= 0; index -= 1) {
            link = param_document.links[index];

            // Update targets
            //
            if (Browser.SameHierarchy(Page.connect_info.base_url, link.href)) {
                // Verify parcel is known
                //
                if (Page.KnownParcelURL(link.href)) {
                    // Parcel is known
                    //
                    link.onclick = Page.InterceptLink;
                } else {
                    // Unknown parcel, kill link
                    //
                    Browser.RemoveAttribute(link, 'href', '');
                }
            } else {
                // Link to external (non-parcel) content
                //

                // Assign window target if not already defined
                //
                if ((link.target === undefined) || (link.target === null) || (link.target === '')) {
                    // Replace current window
                    //
                    link.target = Page.connect_info.target;
                }
            }
        }
    }
};

Page.GetPrevNext = function (param_document, param_prevnext) {
    'use strict';

    var result, link_href;

    try {
        link_href = Browser.GetLinkRelHREF(param_document, param_prevnext);
        if ((link_href !== '') && (link_href !== '#')) {
            // Ensure link is fully resolved
            // (workaround IE's compatibility view)
            //
            result = Browser.ResolveURL(param_document.location.href, link_href);
        }
    } catch (ignore) {
        // Ignore all errors!
        //
    }

    return result;
};

Page.Listen = function (param_event) {
    'use strict';

    if (Page.dispatch === undefined) {
        Page.dispatch = {
            'get_page_size': function (param_data) {
                var data;

                data = {
                    'action': 'page_size',
                    'dimensions': Browser.GetWindowContentWidthHeight(Page.window),
                    'stage': param_data.stage
                };
                Message.Post(Page.window.parent, data, Page.window);
            },
            'update_hash': function (param_data) {
                var target_element, data;

                Page.window.document.location.hash = param_data.hash;

                // Manually scroll into view (ensure view updated)
                //
                target_element = Page.window.document.getElementById(param_data.hash.substring(1));
                if ((target_element !== null) && (target_element.scrollIntoView !== undefined)) {
                    target_element.scrollIntoView();
                }

                data = {
                    'action': 'page_bookkeeping'
                };
                Message.Post(Page.window.parent, data, Page.window);
            },
            'update_anchors': function (param_data) {
                Page.connect_info = param_data;
                Page.UpdateAnchors(Page.window.document);
            },
            'page_set_max_width': function (param_data) {
                var data;

                Page.window.document.body.style.maxWidth = param_data.max_width;

                // Notify
                //
                data = {
                    'action': 'notify_page_max_width_set',
                    'target_width': param_data.target_width
                };
                Message.Post(Page.window.parent, data, Page.window);
            },
            'ww_behavior_print': function (param_data) {
                Page.window.print();
            },
            'ww_behavior_pdf': function (param_data) {
                var pdf_link, links, index, link, data;

                // Find PDF link
                //
                pdf_link = null;
                links = Page.window.document.body.getElementsByTagName('a');
                for (index = 0; index < links.length; index += 1) {
                    link = links[index];

                    if ((Browser.ContainsClass(link.className, 'ww_behavior_pdf')) && (link.href !== undefined) && (link.href.length > 0)) {
                        // Found our link!
                        //
                        pdf_link = link;
                        break;
                    }
                }

                // PDF link found?
                //
                if (pdf_link !== null) {
                    // Display link
                    //
                    data = {
                        'action': 'display_link',
                        'href': pdf_link.href,
                        'target': pdf_link.target
                    };
                    Message.Post(Page.window.parent, data, Page.window);
                }
            },
            'page_socialize': function (param_data) {
                var social_ids, social_id, social_element, twitter_span, twitter_iframe, facebook_span, facebook_iframe, google_span, google_script, first_script, disqus_div, disqus_script;

                // Handle file protocol
                //
                if (Page.window.document.location.protocol === 'file:') {
                    social_ids = [ 'social_twitter', 'social_facebook_like', 'social_google_plus1', 'disqus_thread' ];
                    while (social_ids.length > 0) {
                        social_id = social_ids.pop();
                        social_element = Page.window.document.getElementById(social_id);
                        if (social_element !== null) {
                            social_element.parentNode.removeChild(social_element);
                        }
                    }
                }

                // Twitter
                //
                twitter_span = Page.window.document.getElementById('social_twitter');
                if (twitter_span !== null) {
                    twitter_iframe = Browser.FirstChildElementWithTagName(twitter_span, 'iframe');
                    if (twitter_iframe !== null) {
                        twitter_iframe.contentWindow.location.replace('http://platform.twitter.com/widgets/tweet_button.html?lang=en&count=horizontal&url=' + encodeURI(Page.window.document.location.href));
                    }
                }

                // FaceBook Like
                //
                facebook_span = Page.window.document.getElementById('social_facebook_like');
                if (facebook_span !== null) {
                    facebook_iframe = Browser.FirstChildElementWithTagName(facebook_span, 'iframe');
                    if (facebook_iframe !== null) {
                        facebook_iframe.contentWindow.location.replace('http://www.facebook.com/plugins/like.php?layout=button_count&show_faces=false&action=like&colorscheme=light&width=90&height=20&href=' + encodeURI(Page.window.document.location.href));
                    }
                }

                // Google +1
                //
                google_span = Page.window.document.getElementById('social_google_plus1');
                if (google_span !== null) {
                    google_script = Page.window.document.createElement('script');
                    google_script.type = 'text/javascript';
                    google_script.async = true;
                    google_script.src = 'https://apis.google.com/js/plusone.js';
                    first_script = Page.window.document.getElementsByTagName('script')[0];
                    first_script.parentNode.insertBefore(google_script, first_script);
                }

                // Disqus
                //
                if (param_data.disqus_id.length > 0) {
                    disqus_div = Page.window.document.getElementById('disqus_thread');
                    if (disqus_div !== null) {
                        disqus_script = Page.window.document.createElement('script');
                        disqus_script.type = 'text/javascript';
                        disqus_script.async = true;
                        disqus_script.src = 'http://' + param_data.disqus_id + '.disqus.com/embed.js';
                        disqus_div.parentNode.appendChild(disqus_script);
                    }
                }
            },
            'page_globalize': function (param_data) {
                var google_translate_div, google_translate_script;

                // Google Translation
                //
                google_translate_div = Page.window.document.getElementById('google_translate_element');
                if (google_translate_div !== null) {
                    google_translate_script = Page.window.document.createElement('script');
                    google_translate_script.type = 'text/javascript';
                    google_translate_script.async = true;
                    google_translate_script.src = '//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
                    google_translate_div.appendChild(google_translate_script);
                }
            }
        };
    }

    try {
        // Dispatch
        //
        Page.dispatch[param_event.data.action](param_event.data);
    } catch (ignore) {
        // Keep on rolling
        //
    }
};

Page.ContentChanged = function () {
    'use strict';

    var data;

    data = {
        'action': 'page_content_changed'
    };
    Message.Post(Page.window.parent, data, Page.window);
};

Page.OnUnload = function () {
    'use strict';

    var data;

    // Notify parent
    //
    data = {
        'action': 'page_unload'
    };
    Message.Post(Page.window.parent, data, Page.window);
};

Page.OnLoad = function () {
    'use strict';

    var data;

    if (Page.window !== Page.window.top) {
        // Track unload
        //
        Page.window.onunload = Page.OnUnload;

        // Setup for listeninge
        //
        Message.Listen(Page.window, function (param_event) {
            Page.Listen(param_event);
        });

        // Track document content changes
        //
        Browser.TrackDocumentChanges(Page.window, Page.window.document, Page.ContentChanged);

        // Notify parent
        //
        data = {
            'action': 'page_load',
            'dimensions': Browser.GetWindowContentWidthHeight(Page.window),
            'id': Page.window.document.body.id,
            'title': Page.window.document.title,
            'href': Page.window.document.location.href,
            'hash': Page.window.document.location.hash,
            'Prev': Page.GetPrevNext(Page.window.document, 'Prev'),
            'Next': Page.GetPrevNext(Page.window.document, 'Next')
        };
        Message.Post(Page.window.parent, data, Page.window);
    }
};

// Start running as soon as possible
//
if (window.addEventListener !== undefined) {
    window.addEventListener('load', Page.OnLoad, false);
} else if (window.attachEvent !== undefined) {
    window.attachEvent('onload', Page.OnLoad);
}

