// Copyright (c) 2011-2012 Quadralay Corporation.  All rights reserved.
//
// ePublisher 2012.2
//
// Validated with JSLint <http://www.jslint.com/>
//

/*jslint white: true, maxerr: 50, indent: 4 */
/*global Unicode */

var SearchClient = {};

SearchClient.SearchReplace = function (paramString, paramSearchString, paramReplaceString) {
    'use strict';

    var  result, index;

    result = paramString;

    if (
        (paramSearchString.length > 0)
         &&
        (result.length > 0)
       ) {
        index = 0;
        while ((index = result.indexOf(paramSearchString, index)) !== -1) {
            result = result.substring(0, index) + paramReplaceString + result.substring(index + paramSearchString.length, result.length);
            index += paramReplaceString.length;
        }
    }

    return result;
};

SearchClient.EscapeHTML = function (paramHTML) {
    'use strict';

    var  escapedHTML = paramHTML;

    // Escape problematic characters
    // & < > "
    //
    escapedHTML = SearchClient.SearchReplace(escapedHTML, "&", "&amp;");
    escapedHTML = SearchClient.SearchReplace(escapedHTML, "<", "&lt;");
    escapedHTML = SearchClient.SearchReplace(escapedHTML, ">", "&gt;");
    escapedHTML = SearchClient.SearchReplace(escapedHTML, "\"", "&quot;");

    return escapedHTML;
};

SearchClient.ParseWordsAndPhrases = function (ParamInput) {
    'use strict';

    var WordSplits, Results, StringWithSpace, CurrentPhrase, CurrentWord, WordIndex, StartQuotes;

    WordSplits = [];
    Results = [];
    StringWithSpace = 'x x';
    CurrentPhrase = '';
    CurrentWord = '';
    WordIndex = 0;
    StartQuotes = false;

    if (ParamInput.length > 0) {
        WordSplits = ParamInput.split(StringWithSpace.substring(1, 2));
        for (WordIndex = 0; WordIndex < WordSplits.length; WordIndex += 1) {
            CurrentWord = WordSplits[WordIndex];
            if (CurrentWord.length > 0) {
                // If the current word does not start with or end with a double quote
                // and a phrase has not been started, then add it to the result word list
                // and continue
                //
                if (CurrentWord.charAt(0) === '"') {
                    if (StartQuotes) {
                        // This entry ends the current phrase and the word following
                        // the quote will be added as a separate word, unless there is
                        // a second quote at the start that will start a new phrase
                        //
                        Results[Results.length] = CurrentPhrase.substring(0, CurrentPhrase.length - 1);
                        CurrentPhrase = '';

                        while (
                               (CurrentWord.length > 0)
                                &&
                               (CurrentWord.charAt(0) === '"')
                              ) {
                            CurrentWord = CurrentWord.substring(1, CurrentWord.length);
                        }
                        if (CurrentWord.length > 0) {
                            CurrentPhrase += CurrentWord + ' ';
                        }
                    } else {
                        StartQuotes = true;

                        // Strip off the leading quotes and process the word
                        //
                        while (
                               (CurrentWord.length > 0)
                                &&
                               (CurrentWord.charAt(0) === '"')
                              ) {
                            CurrentWord = CurrentWord.substring(1, CurrentWord.length);
                        }

                        if (CurrentWord.length > 0) {
                            // One Word Phrase - Add it as a word and set StartQuotes to false
                            //
                            if (CurrentWord.charAt(CurrentWord.length - 1) === '"') {
                                StartQuotes = false;
                                // Strip off trailing quotes and add it as a word
                                //
                                while (
                                       (CurrentWord.length > 0)
                                        &&
                                       (CurrentWord.charAt(CurrentWord.length - 1) === '"')
                                      ) {
                                    CurrentWord = CurrentWord.substring(0, CurrentWord.length - 1);
                                }

                                // Add the Word to the result array
                                //
                                Results[Results.length] = CurrentWord;
                            } else {
                                // The current word starts a phrase
                                //
                                CurrentPhrase += CurrentWord + ' ';
                            }
                        }
                    }
                } else if (CurrentWord.charAt(CurrentWord.length - 1) === '"') {
                    // Strip off trailing quotes regardless
                    //
                    while (
                           (CurrentWord.length > 0)
                            &&
                           (CurrentWord.charAt(CurrentWord.length - 1) === '"')
                          ) {
                        CurrentWord = CurrentWord.substring(0, CurrentWord.length - 1);
                    }

                    // Only process the word if the length is greater than 0 after
                    // stripping the trailing quotes
                    //
                    if (CurrentWord.length > 0) {
                        if (StartQuotes) {
                            CurrentPhrase += CurrentWord;

                            Results[Results.length] = CurrentPhrase;
                            StartQuotes = false;
                            CurrentPhrase = '';
                        } else {
                            // The phrase is not started
                            //
                            Results[Results.length] = CurrentWord;
                        }
                    }
                } else {
                    // The word is either a single word or in the middle of a phrase
                    //
                    if (StartQuotes) {
                        CurrentPhrase += CurrentWord + ' ';
                    } else {
                        Results[Results.length] = CurrentWord;
                    }
                }
            }
        }
    }

    return Results;
};

SearchClient.ApplyWordBreaks = function (paramString)
{
    'use strict';

    var result, index, insert_break;

    result = "";

    // Apply Unicode rules for word breaking
    // These rules taken from http://www.unicode.org/unicode/reports/tr29/
    //
    for (index = 0; index < paramString.length ; index += 1) {
        // Break?
        //
        insert_break = Unicode.CheckBreakAtIndex(paramString, index);
        if (insert_break) {
            result += " " + paramString.charAt(index);
        } else {
            result += paramString.charAt(index);
        }
    }

    return result;
};

SearchClient.ParseSearchWords = function (paramSearchWordsString, paramMinimumWordLength, paramStopWords) {
    'use strict';

    var result, wordsAndPhrases, wordsAndPhrasesIndex, wordOrPhrase, words, wordsIndex, word;

    result = [];

    // Add search words to hash
    //
    wordsAndPhrases = SearchClient.ParseWordsAndPhrases(paramSearchWordsString);
    for (wordsAndPhrasesIndex = 0 ; wordsAndPhrasesIndex < wordsAndPhrases.length ; wordsAndPhrasesIndex += 1) {
        wordOrPhrase = SearchClient.ApplyWordBreaks(wordsAndPhrases[wordsAndPhrasesIndex]);
        words = SearchClient.ParseWordsAndPhrases(wordOrPhrase);
        for (wordsIndex = 0; wordsIndex < words.length; wordsIndex += 1) {
            word = words[wordsIndex];

            // Skip words below the minimum word length
            //
            if (
                (word.length > 0)
                 &&
                (word.length >= paramMinimumWordLength)
               )
            {
                // Skip stop words
                //
                if (paramStopWords[word] === undefined) {
                    // Add to search words list
                    //
                    result[result.length] = word;
                }
            }
        }
    }

    return result;
};

SearchClient.ComparePageWithScore = function (param_alpha, param_beta) {
    'use strict';

    var result = 0;

    if (param_alpha.score < param_beta.score) {
        result = 1;
    }
    else if (param_alpha.score > param_beta.score) {
        result = -1;
    }

    return result;
};
