// Copyright (c) 2010-2012 Quadralay Corporation.  All rights reserved.
//
// ePublisher 2012.2
//
// Validated with JSLint <http://www.jslint.com/>
//

/*jslint white: true, nomen: true, maxerr: 50, indent: 4 */
/*global window */
/*global google */
/*global _gaq */
/*global Browser */
/*global Message */
/*global Parcels */
/*global SearchClient */

var implementation = 'search-implementation-google';

var analyticsID;
var searchID;

// Search
//

var Search = {
    'window': window,
    'control': undefined,
    'loading': false,
    'query': ''
};

Search.KnownParcelURL = function (param_url) {
    'use strict';

    var result;

    result = Parcels.KnownParcelURL(Search.connect_info.parcel_prefixes, param_url);

    return result;
};

Search.KnownParcelBaggageURL = function (param_url) {
    'use strict';

    var result;

    result = Parcels.KnownParcelBaggageURL(Search.connect_info.parcel_prefixes, param_url);

    return result;
};

Search.ASPX_Object = function () {
    'use strict';

    this.draw = function (param_id) {
        var cse, search_input, search_button, search_form, container;

        cse = window.document.getElementById('custom-search-engine');
        cse.innerHTML = '';
        search_input = window.document.createElement('input');
        search_input.id = 'search-input-text';
        search_input.name = 'search-input-text';
        search_input.type = 'text';
        search_input.value = Search.query;
        search_button = window.document.createElement('input');
        search_button.id = 'search-button';
        search_button.name = 'search-button';
        search_button.type = 'submit';
        search_button.value = 'Search';
        search_form = window.document.createElement('form');
        search_form.id = 'search-form';
        search_form.onsubmit = function (element) {
                var input;

                input = window.document.getElementById('search-input-text');
                Search.Execute(input.value);
                return false;
            };
        search_form.appendChild(search_input);
        search_form.appendChild(search_button);
        cse.appendChild(search_form);

        container = window.document.createElement('div');
        container.id = 'search-results-container';
        cse.appendChild(container);
        container.innerHTML = '';
    };

    this.setSearchStartingCallback = function (param_object, param_method) {
        this.search_starting = { object: param_object, method: param_method };
    };

    this.setSearchCompleteCallback = function (param_object, param_method) {
        this.search_complete = { object: param_object, method: param_method };
    };

    this.setLinkTarget = function (param_target) {
        this.target = param_target;
    };

    this.execute = function (param_search_words) {
        var ajax;

        this.search_starting.method.call(this.search_starting.object, this.search_starting.object, null, param_search_words);

        ajax = Browser.GetAJAX(window);

        ajax.onreadystatechange = function() {
            if (ajax.readyState === 4)  {
                var container = window.document.getElementById('search-results-container');
                if (ajax.responseText.length <= 2) {
                  container.innerHTML = '<div>No results for you!</div>';
                }
                else {
                  container.innerHTML = ajax.responseText;
                }

                Search.control.search_complete.method.call(Search.control.search_complete.object, Search.control.search_complete.object, null);
            }
        };
        ajax.open('GET', 'Search.aspx?q=' + encodeURI(Search.query), true);
        ajax.send(null);
    };

    this.clearAllResults = function() {
        var container = window.document.getElementById('search-results-container');
        container.innerHTML = '';
    };
};

Search.InBrowser_Object = function () {
    'use strict';

    var stop_words_array, stop_words_array_index, stop_word;

    // Search configuration
    //
    this.minimum_word_length = 0;
    stop_words_array = 'and or'.split(' ');
    this.stop_words = {};
    for (stop_words_array_index = 0; stop_words_array_index < stop_words_array.length; stop_words_array_index += 1) {
        stop_word = stop_words_array[stop_words_array_index];
        if (stop_word.length > 0) {
            this.stop_words[stop_word] = 1;
        }
    }

    // Initialize search data
    //
    this.data_queue = undefined;
    this.data = [];

    this.draw = function (param_id) {
        var cse, search_input, search_button, search_form, container;

        cse = window.document.getElementById('custom-search-engine');
        cse.innerHTML = '';
        search_input = window.document.createElement('input');
        search_input.id = 'search-input-text';
        search_input.name = 'search-input-text';
        search_input.type = 'text';
        search_input.value = Search.query;
        search_button = window.document.createElement('input');
        search_button.id = 'search-button';
        search_button.name = 'search-button';
        search_button.type = 'submit';
        search_button.value = 'Search';
        search_form = window.document.createElement('form');
        search_form.id = 'search-form';
        search_form.onsubmit = function (element) {
                var input;

                input = window.document.getElementById('search-input-text');
                Search.Execute(input.value);
                return false;
            };
        search_form.appendChild(search_input);
        search_form.appendChild(search_button);
        cse.appendChild(search_form);

        container = window.document.createElement('div');
        container.id = 'search-results-container';
        cse.appendChild(container);
        container.innerHTML = '';
    };

    this.setSearchStartingCallback = function (param_object, param_method) {
        this.search_starting = { object: param_object, method: param_method };
    };

    this.setSearchCompleteCallback = function (param_object, param_method) {
        this.search_complete = { object: param_object, method: param_method };
    };

    this.setLinkTarget = function (param_target) {
        this.target = param_target;
    };

    this.execute = function (param_search_words) {
        var data_entry, script_element, ajax, words, word_matches, word_index, word, data_index, info, page_matches, page_match_index, page, page_with_score, word_match_index, word_page_matches, pages, pages_to_check, page_id, pages_to_remove, pages_array, pages_array_index, buffer, container;

        // Initialize data queue?
        //
        if (this.data_queue === undefined) {
            this.data_queue = Search.connect_info.parcel_sx.slice(0);
        }

        // Need to load search data?
        //
        if (this.data_queue.length > 0) {
            data_entry = this.data_queue.shift();

            // Load data
            //
            if (window.document.location.protocol === 'file:') {
                // Advance progress
                //
                Search.control.advance = function (param_info) {
                    // Track data
                    //
                    Search.control.data.push(param_info);

                    // Invoke method to load more data or perform search
                    //
                    Search.control.execute(param_search_words);
                };

                // Use script element
                //
                script_element = Search.window.document.createElement('script');
                script_element.src = data_entry;
                Search.window.document.body.appendChild(script_element);
            } else {
                // Use AJAX
                //
                ajax = Browser.GetAJAX(window);

                ajax.onreadystatechange = function() {
                        var info_as_text, info_prefix, info_suffix, info;

                        if (ajax.readyState === 4)  {
                            // Prep info
                            //
                            info_as_text = ajax.responseText;
                            info_prefix = 'var info =';
                            info_suffix = ';Search.control.advance(info);';
                            info_as_text = info_as_text.substring(
                                info_as_text.indexOf(info_prefix) + info_prefix.length,
                                info_as_text.lastIndexOf(info_suffix)
                            );

                            // Parse JSON
                            //
                            if (window.JSON && window.JSON.parse) {
                                info = window.JSON.parse(info_as_text);
                            } else {
                                info = eval('(' + info_as_text + ')');
                            }

                            // Track data
                            //
                            Search.control.data.push(info);

                            // Invoke method to load more data or perform search
                            //
                            Search.control.execute(param_search_words);
                        }
                    };

                ajax.open('GET', data_entry, true);
                ajax.send(null);
            }
        }
        else {
            this.search_starting.method.call(this.search_starting.object, this.search_starting.object, null, param_search_words);

            // Get words
            //
            words = SearchClient.ParseSearchWords(Search.query.toLowerCase(), this.minimum_word_length, this.stop_words);
            word_matches = {};
            for (word_index = 0 ; word_index < words.length ; word_index += 1) {
                word = words[word_index];

                word_matches[word] = [];
            }

            // Process parcels
            //
            for (data_index = 0 ; data_index < this.data.length ; data_index += 1) {
                info = this.data[data_index];

                // Add page info to word matches
                //
                for (word_index = 0 ; word_index < words.length ; word_index += 1) {
                    word = words[word_index];

                    // Match?
                    //
                    page_matches = info.words[word];
                    if (page_matches !== undefined) {
                        // Add page info (page index and score alternate)
                        //
                        for (page_match_index = 0 ; page_match_index < page_matches.length ; page_match_index += 2) {
                            page = info.pages[page_matches[page_match_index]];
                            page_with_score = { 'page': page, 'score': page_matches[page_match_index + 1] };
                            word_matches[word].push(page_with_score);
                        }
                    }
                }
            }

            // Combine search results for each word
            //
            pages = {};
            for (word_index = 0 ; word_index < words.length ; word_index += 1) {
                word = words[word_index];

                word_page_matches = word_matches[word];
                if (word_page_matches.length === 0) {
                    // Based on implicit AND there are no results possible for this query
                    //
                    pages = {};
                    break;
                } else if (word_index === 0) {
                    // Add all pages
                    //
                    for (page_match_index = 0 ; page_match_index < word_page_matches.length ; page_match_index += 1) {
                        page_with_score = word_page_matches[page_match_index];

                        pages[page_with_score.page[0]] = page_with_score;
                    }
                } else {
                    // Based on implicit AND, combine like pages and remove pages not present in both page lists
                    //
                    pages_to_check = {};
                    for (page_match_index = 0 ; page_match_index < word_page_matches.length ; page_match_index += 1) {
                        page_with_score = word_page_matches[page_match_index];

                        pages_to_check[page_with_score.page[0]] = 1;

                        // Combine scoring info
                        //
                        if (pages[page_with_score.page[0]] !== undefined) {
                            pages[page_with_score.page[0]].score += page_with_score.score;
                        }
                    }
                    pages_to_remove = {};
                    for (page_id in pages) {
                        if (pages.hasOwnProperty(page_id)) {
                            if (pages_to_check[page_id] === undefined) {
                                pages_to_remove[page_id] = 1;
                            }
                        }
                    }
                    for (page_id in pages_to_remove) {
                        if (pages_to_remove.hasOwnProperty(page_id)) {
                            delete pages[page_id];
                        }
                    }
                }
            }

            // Sort pages by rank
            //
            pages_array = [];
            for (page_id in pages) {
                if (pages.hasOwnProperty(page_id)) {
                    pages_array.push(pages[page_id]);
                }
            }
            if (pages_array.length > 0) {
                pages_array = pages_array.sort(SearchClient.ComparePageWithScore);
            }

            // Display results
            //
            buffer = [];
            for (pages_array_index = 0; pages_array_index < pages_array.length; pages_array_index += 1) {
                page_with_score = pages_array[pages_array_index];
                page = page_with_score.page;

                buffer.push('<div class="search-result-title"><a target="connect_page" href="../' + SearchClient.EscapeHTML(page[0]) + '">' + SearchClient.EscapeHTML(page[1]) + '</a></div>');
                if (page[2].length > 0) {
                    buffer.push('<div class="search-result-summary">' + SearchClient.EscapeHTML(page[2]) + '</div>');
                }
            }

            container = window.document.getElementById('search-results-container');
            if (buffer.length === 0) {
                container.innerHTML = '<div>No results for you!</div>';
            } else {
                container.innerHTML = buffer.join('\n');
            }

            this.search_complete.method.call(this.search_complete.object, this.search_complete.object, null);
        }
    };

    this.clearAllResults = function() {
        var container = window.document.getElementById('search-results-container');
        container.innerHTML = '';
    };
};

Search.Execute = function (param_query) {
    'use strict';

    // Update search words
    //
    if (param_query !== undefined) {
        Search.query = param_query;
    }

    // Check for a search query string and execute it
    //
    if (Search.query !== '') {
        // Search!
        //
        Search.control.execute(Search.query);
    } else {
        Search.control.clearAllResults();
    }
};

Search.Listen = function (param_event) {
    'use strict';

    if (Search.dispatch === undefined) {
        Search.dispatch = {
            'search_get_page_size': function (param_data) {
                var data;

                data = {
                    'action': 'search_page_size',
                    'dimensions': Browser.GetWindowContentWidthHeight(Search.window),
                    'stage': param_data.stage
                };
                Message.Post(Search.window.parent, data, Search.window);
            },
            'search_connect_info': function (param_data) {
                var data;

                Search.connect_info = param_data;
                delete Search.connect_info['action'];

                data = {
                    'action': 'search_ready'
                };
                Message.Post(Search.window.parent, data, Search.window);
            },
            'search_execute': function (param_data) {
                Search.Execute(param_data.query);
            }
        };
    }

    try {
        // Dispatch
        //
        Search.dispatch[param_event.data.action](param_event.data);
    } catch (ignore) {
        // Keep on rolling
        //
    }
};

Search.Load = function() {
    'use strict';

    var onSearchStart, onSearchLinkClick, onSearchComplete, data;

    // Setup for listeninge
    //
    Message.Listen(window, function (param_event) {
        Search.Listen(param_event);
    });

    // Define callbacks
    //
    onSearchStart = function(param_search_control, param_searcher, param_query) {
        var search_input, container;

        // Set search words
        //
        Search.query = param_query;
        search_input = window.document.getElementById('search-input-text');
        if (search_input !== null) {
            search_input.value = Search.query;
        }

        // Replace results with progress indicator
        //
        container = window.document.getElementById('search-results-container');
        if (container !== null) {
            container.innerHTML = '<div>Searching...</div>';
        }
    };

    onSearchLinkClick = function(param_event) {
        var data;

        data = {
            'action': 'search_display_link',
            'href': this.href
        };
        Message.Post(Search.window.parent, data, Search.window);

        return false;
    };

    onSearchComplete = function(param_search_control, param_searcher) {
        var index, link, search_uri, encoded_search_uri, data;

        // Intercept search result links
        //
        for (index = 0; index < window.document.links.length; index += 1) {
            link = window.document.links[index];

            if (link.target === 'connect_page') {
                // Same hierarchy?
                //
                if (Browser.SameHierarchy(Search.connect_info.base_url, link.href)) {
                    // Verify parcel is known
                    //
                    if ((Search.KnownParcelURL(link.href)) && (!Search.KnownParcelBaggageURL(link.href))) {
                        // Handle via Connect run-time
                        //
                        link.onclick = onSearchLinkClick;
                    } else {
                        // Open in a new window
                        //
                        link.target = '_blank';
                    }
                } else {
                    // Open in a new window
                    //
                    link.target = '_blank';
                }
            }
        }

        // Track search words in Google Analytics, if enabled
        //
        if ((analyticsID !== undefined) && (_gaq !== undefined)) {
            // Track them!
            //
            search_uri = window.document.location.pathname + '?q=' + Search.query;
            encoded_search_uri = encodeURI(search_uri);
            _gaq.push(['_setAccount', analyticsID]);
            _gaq.push(['_trackPageview', encoded_search_uri]);
        }

        // Notify parent
        //
        data = {
            'action': 'search_complete',
            'query': Search.query,
            'dimensions': Browser.GetWindowContentWidthHeight(Search.window)
        };
        Message.Post(Search.window.parent, data, Search.window);
    };

    // Search control settings
    //
    if (implementation === 'search-implementation-aspx') {
        Search.control = new Search.ASPX_Object();
    } else if (implementation === 'search-implementation-client') {
        Search.control = new Search.InBrowser_Object();
    } else {
        if (searchID !== undefined) {
            Search.control = new google.search.CustomSearchControl(searchID);
        } else {
            Search.control = new google.search.CustomSearchControl();
        }
        Search.control.setResultSetSize(google.search.Search.FILTERED_CSE_RESULTSET);
    }
    Search.control.setSearchStartingCallback(this, onSearchStart);
    Search.control.setSearchCompleteCallback(this, onSearchComplete);
    Search.control.setLinkTarget('connect_page');
    //Search.control.enableAds('<Your_AdSense_Publisher_ID>');

    // Draw the control
    //
    Search.control.draw('custom-search-engine');

    // Ready to search
    //
    data = {
        'action': 'search_page_load',
        'dimensions': Browser.GetWindowContentWidthHeight(Search.window)
    };
    Message.Post(Search.window.parent, data, Search.window);
};

// Handle load
//

Search.OnLoad = function() {
    'use strict';

    if (implementation === 'search-implementation-aspx') {
        if ( ! Search.loading) {
            Search.loading = true;
            Search.Load();
        }
    } else if (implementation === 'search-implementation-client') {
        if ( ! Search.loading) {
            Search.loading = true;
            Search.Load();
        }
    }
};

if (implementation === 'search-implementation-aspx') {
    // Start running as soon as possible
    //
    if (window.addEventListener !== undefined) {
        window.addEventListener('DOMContentLoaded', Search.OnLoad, false);
    }
}
else if (implementation === 'search-implementation-client') {
    // Start running as soon as possible
    //
    if (window.addEventListener !== undefined) {
        window.addEventListener('DOMContentLoaded', Search.OnLoad, false);
    }
}
else {
    google.load('search', '1');
    google.setOnLoadCallback(Search.Load, true);
}
