<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" 
                              xmlns:html="http://www.w3.org/1999/xhtml" 
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              exclude-result-prefixes="html xsl wwmode wwdoc wwsplits wwimaging wwlog wwuri wwprojext wwfilesystem"
>
  <xsl:import href="wwtransform:super" />

  <!-- Begin Customization -->
  <!-- Equation fix to enable right-aligned equation numbers.
  Received from Jesse Wiles for 2011-01-12 Study Hall session via WebWorks wiki page:
  http://wiki.webworks.com/DevCenter/Projects/EquationOverrides2009.3Later/Discussion
  (customized version of this file attached to page in Equations-fromJesse-011210.zip)
  -->
  <xsl:template match="wwdoc:Paragraph[@stylename = 'Equations w/number, catalog']" mode="wwmode:content">
    <xsl:param name="ParamParagraph" select="." />
    <xsl:param name="ParamSplits"/>
    <xsl:param name="ParamSplit"/>

    <html:table style="width: 100%;">
      <html:tr>
        <html:td style="padding-left: 5%; text-align: left;">
          <xsl:for-each select="$ParamParagraph/wwdoc:TextRun">
            <xsl:for-each select="wwdoc:Frame | wwdoc:Text">
              <xsl:variable name="VarItem" select="." />
              <xsl:choose>
                <xsl:when test="local-name() = 'Frame'">
                  <xsl:for-each select="$ParamSplits[1]">
                    <xsl:variable name="VarSplitsFrame" select="key('wwsplits-frames-by-id', $VarItem/@id)[@documentID = $ParamSplit/@documentID]" />
                    <xsl:variable name="VarImageInfo" select="wwimaging:GetInfo($VarSplitsFrame/@path)" />
     
                    <xsl:variable name="VarSrc" select="wwuri:GetRelativeTo($VarImageInfo/@path, $ParamSplit/@path)" />
                    <html:img src="{$VarSrc}" class="EquationGraphic" style="border: 0px; vertical-align: baseline;" />
                  </xsl:for-each>
                </xsl:when>

                <xsl:otherwise>
                  <html:span><xsl:value-of select="@value" /></html:span>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:for-each>
          </xsl:for-each>
        </html:td>  

        <!-- Second cell with fixed width -->
        <!--                                 -->
        <html:td style="padding-right: 20px; text-align: right;">
          <xsl:for-each select="$ParamParagraph/wwdoc:Number">
            <html:div style="font-weight: bold; font-size: large;">
              <xsl:for-each select="descendant::wwdoc:Text">
                <xsl:value-of select="@value" />
              </xsl:for-each>
            </html:div>
          </xsl:for-each>
        </html:td>
      </html:tr>
    </html:table>
  </xsl:template>
  <!-- End Customization -->
  
  
  <!-- Override default MiniTOC template -->
  
  <xsl:template name="MiniTOC">
   <xsl:param name="ParamSplit" />
   <xsl:param name="ParamTOCEntry" />
   <xsl:param name="ParamEmitTOCEntry" />
   <xsl:param name="ParamMiniTOCSubLevels" />

   <xsl:if test="($ParamEmitTOCEntry = true()) or (count($ParamTOCEntry/wwtoc:Entry[1]) = 1)">
    <html:div class="WebWorks_MiniTOC">

     <!-- [rofish 2007-04-05] -->  
     <!-- [VPI customization] -->
     <!-- [http://wiki.webworks.com/HelpCenter/Tips/AddingHeadingsToMiniTOCs] -->
     <html:div class="MiniTOCHeading">
      In this section:
     </html:div>
     <!-- [END customization] -->

     <!-- Emit top-level entry? -->
     <!--                       -->
     <xsl:choose>
      <xsl:when test="$ParamEmitTOCEntry = true()">
       <html:div class="WebWorks_MiniTOC_Level1">
        <!-- Paragraph -->
        <!--           -->
        <xsl:call-template name="MiniTOCParagraph">
         <xsl:with-param name="ParamParagraph" select="$ParamTOCEntry/wwdoc:Paragraph" />
        </xsl:call-template>
       </html:div>

       <!-- Children -->
       <!--          -->
       <xsl:call-template name="MiniTOCEntries">
        <xsl:with-param name="ParamReferencePath" select="$ParamSplit/@path" />
        <xsl:with-param name="ParamParent" select="$ParamTOCEntry" />
        <xsl:with-param name="ParamMiniTOCSubLevels" select="$ParamMiniTOCSubLevels" />
        <xsl:with-param name="ParamLevel" select="2" />
       </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
       <!-- Children -->
       <!--          -->
       <xsl:call-template name="MiniTOCEntries">
        <xsl:with-param name="ParamReferencePath" select="$ParamSplit/@path" />
        <xsl:with-param name="ParamParent" select="$ParamTOCEntry" />
        <xsl:with-param name="ParamMiniTOCSubLevels" select="$ParamMiniTOCSubLevels" />
        <xsl:with-param name="ParamLevel" select="1" />
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </html:div>
   </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>
