<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <xsl:output method="text" />


 <xsl:template match="/">
  <xsl:variable name="VarTopicRefNodes" select="//*[contains(@class, ' map/topicref ') and (string-length(@href) &gt; 0)]" />

  <!-- Determine DITA extension name -->
  <!--                               -->
  <xsl:variable name="VarDitaExtensionName">
   <xsl:if test="count($VarTopicRefNodes) &gt; 0">
    <xsl:variable name="VarFileName">
     <xsl:call-template name="FileName">
      <xsl:with-param name="ParamPath" select="$VarTopicRefNodes[1]/@href" />
     </xsl:call-template>
    </xsl:variable>

    <xsl:call-template name="Extension">
     <xsl:with-param name="ParamFileName" select="$VarFileName" />
    </xsl:call-template>
   </xsl:if>
  </xsl:variable>

  <!-- Emit DITA extension name or default -->
  <!--                                     -->
  <xsl:choose>
   <xsl:when test="string-length($VarDitaExtensionName) &gt; 0">
    <xsl:text>.</xsl:text>
    <xsl:value-of select="$VarDitaExtensionName" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:text>.xml</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="FileName">
  <xsl:param name="ParamPath" />

  <xsl:variable name="VarFileNameWithAnchor">
   <xsl:call-template name="Parse-Last-Entry">
    <xsl:with-param name="ParamString" select="translate($ParamPath, '\', '/')" />
    <xsl:with-param name="ParamDelimiter" select="'/'" />
   </xsl:call-template>
  </xsl:variable>

  <xsl:choose>
   <xsl:when test="contains($VarFileNameWithAnchor, '#')">
    <xsl:value-of select="substring-before($VarFileNameWithAnchor, '#')" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:value-of select="$VarFileNameWithAnchor" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="Extension">
  <xsl:param name="ParamFileName" />

  <xsl:call-template name="Parse-Last-Entry">
   <xsl:with-param name="ParamString" select="$ParamFileName" />
   <xsl:with-param name="ParamDelimiter" select="'.'" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="Parse-Last-Entry">
  <xsl:param name="ParamString" />
  <xsl:param name="ParamDelimiter" />

  <xsl:choose>
   <xsl:when test="contains($ParamString, $ParamDelimiter)">
    <xsl:call-template name="Parse-Last-Entry">
     <xsl:with-param name="ParamString" select="substring-after($ParamString, $ParamDelimiter)" />
     <xsl:with-param name="ParamDelimiter" select="$ParamDelimiter" />
    </xsl:call-template>
   </xsl:when>

   <xsl:otherwise>
    <xsl:value-of select="$ParamString" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
