<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wwstyles="urn:WebWorks-Styles-Schema"
                              xmlns:wwtype="urn:WebWorks-Type-Schema"
                              exclude-result-prefixes="xsl wwstyles wwtype">
 <xsl:output method="xml" indent="yes"/>


 <xsl:template match="/">
  <wwstyles:Styles>
   <!-- Page style markers -->
   <!--                    -->
   <wwstyles:Style name="Default" type="Page" />

   <!-- Filename and Pathname markers -->
   <!--                               -->
   <wwstyles:Style name="Filename" type="Marker" />
   <wwstyles:Style name="Pathname" type="Marker" />

   <!-- DITA Map Title markers -->
   <!--                        -->
   <wwstyles:Style name="Map Title" type="Marker" />

   <!-- DITA Select Attributes markers -->
   <!--                                -->
   <wwstyles:Style name="Select Attribute - platform" type="Marker" />
   <wwstyles:Style name="Select Attribute - product" type="Marker" />
   <wwstyles:Style name="Select Attribute - audience" type="Marker" />
   <wwstyles:Style name="Select Attribute - otherprops" type="Marker" />
   <wwstyles:Style name="Select Attribute - importance" type="Marker" />
   <wwstyles:Style name="Select Attribute - rev" type="Marker" />
   <wwstyles:Style name="Select Attribute - status" type="Marker" />

   <!-- DITA Product Info VRM markers -->
   <!--                               -->
   <wwstyles:Style name="Product Info - Version First" type="Marker" />
   <wwstyles:Style name="Product Info - Version Last" type="Marker" />
   <wwstyles:Style name="Product Info - Release First" type="Marker" />
   <wwstyles:Style name="Product Info - Release Last" type="Marker" />
   <wwstyles:Style name="Product Info - Modification First" type="Marker" />
   <wwstyles:Style name="Product Info - Modification Last" type="Marker" />

   <xsl:apply-templates />
  </wwstyles:Styles>
 </xsl:template>


 <!-- Typed Elements -->
 <!--                -->
 <xsl:template match="*[string-length(@wwtype:type) &gt; 0]">
  <xsl:param name="ParamNode" select="." />

  <!-- Style Name -->
  <!--            -->
  <xsl:variable name="VarStyleName">
   <xsl:choose>
    <xsl:when test="string-length($ParamNode/@outputclass) &gt; 0">
     <xsl:value-of select="$ParamNode/@outputclass" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="local-name($ParamNode)" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Determine effective type -->
  <!--                          -->
  <xsl:variable name="VarEffectiveType">
   <xsl:choose>
    <xsl:when test="$ParamNode/@wwtype:type = 'Note'">
     <xsl:text>Paragraph</xsl:text>
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="$ParamNode/@wwtype:type" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  
  <!-- Style -->
  <!--       -->
  <wwstyles:Style name="{$VarStyleName}" type="{$VarEffectiveType}" />

  <!-- Remaining Style Name -->
  <!--                      -->
  <xsl:if test="string-length($ParamNode/@wwtype:remainderclass) &gt; 0">
   <wwstyles:Style name="{$ParamNode/@wwtype:remainderclass}" type="{$VarEffectiveType}" />
  </xsl:if>

  <!-- Handle @markopen and @markclose? -->
  <!--                                  -->
  <xsl:if test="(string-length($ParamNode/@wwtype:markopen) &gt; 0) or (string-length($ParamNode/@wwtype:markclose) &gt; 0)">
   <!-- Determine mark type -->
   <!--                     -->
   <xsl:variable name="VarMarkType">
    <xsl:choose>
     <xsl:when test="$VarEffectiveType = 'Structure'">
      <xsl:text>Paragraph</xsl:text>
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="$VarEffectiveType" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Handle @markopen -->
   <!--                  -->
   <xsl:if test="string-length($ParamNode/@wwtype:markopen) &gt; 0">
    <wwstyles:Style name="{$ParamNode/@wwtype:markopen}" type="{$VarMarkType}" />
   </xsl:if>

   <!-- Handle @markclose -->
   <!--                   -->
   <xsl:if test="string-length($ParamNode/@wwtype:markclose) &gt; 0">
    <wwstyles:Style name="{$ParamNode/@wwtype:markclose}" type="{$VarMarkType}" />
   </xsl:if>
  </xsl:if>

  <!-- Graphic scale -->
  <!--               -->
  <xsl:if test="$VarEffectiveType = 'Graphic'">
   <xsl:if test="string-length($ParamNode/@scale) &gt; 0">
    <wwstyles:Style name="GraphicScale" type="Marker" />
   </xsl:if>
  </xsl:if>

  <xsl:apply-templates />
 </xsl:template>


 <!-- Default matches -->
 <!--                 -->
 <xsl:template match="*">
  <xsl:param name="ParamNode" select="." />

  <xsl:apply-templates />
 </xsl:template>


 <xsl:template match="comment() | processing-instruction() | text()">
  <!-- Suppress -->
  <!--          -->
 </xsl:template>
</xsl:stylesheet>
