<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wwstyles="urn:WebWorks-Styles-Schema"
                              exclude-result-prefixes="xsl wwstyles">
 <xsl:output method="xml" indent="yes"/>


 <xsl:key name="wwstyles-styles-by-name-type" match="wwstyles:Style" use="concat(@name, ':', @type)" />


 <xsl:template match="/">
  <wwstyles:Styles>

   <xsl:for-each select="//wwstyles:Style">
    <xsl:variable name="VarStyle" select="." />

    <!-- Preserve first unique style name/type -->
    <!--                                       -->
    <xsl:variable name="VarStylesWithNameType" select="key('wwstyles-styles-by-name-type', concat($VarStyle/@name, ':', $VarStyle/@type))" />
    <xsl:if test="count($VarStyle | $VarStylesWithNameType[1]) = 1">
     <xsl:copy-of select="$VarStyle" />
    </xsl:if>
   </xsl:for-each>

  </wwstyles:Styles>
 </xsl:template>
</xsl:stylesheet>
