<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              xmlns:fox="http://xml.apache.org/fop/extensions"
                              exclude-result-prefixes="xsl fo">
 <xsl:output method="xml" encoding="utf-8" indent="no" />


 <xsl:key name="fo-nodes-by-id" match="fo:*" use="@id" />


 <!-- Locate first page-sequence -->
 <!--                            -->
 <xsl:variable name="GlobalFirstPageSequenceOrPageSequenceWrapper" select="(/fo:root/fo:page-sequence[1] | /fo:root/fo:page-sequence-wrapper[1])[1]" />


 <xsl:template match="/">
  <xsl:apply-templates />
 </xsl:template>


 <!-- Map fox:outline to fo:bookmark-tree -->
 <!--                                     -->

 <xsl:template match="fox:outline">
  <!-- Suppress -->
  <!--          -->
 </xsl:template>


 <xsl:template match="fo:page-sequence | fo:page-sequence-wrapper">
  <!-- First instance of page-sequence or page-sequence-wrapper? -->
  <!--                                                           -->
  <xsl:if test="count(. | $GlobalFirstPageSequenceOrPageSequenceWrapper) = 1">
   <!-- Migrate fox:outline to fox:bookmark-tree here -->
   <!--                                               -->

   <!-- Anything to migrate? -->
   <!--                      -->
   <xsl:if test="count(/fo:root/fox:outline[1]) &gt; 0">
    <!-- Begin migration -->
    <!--                 -->
    <fo:bookmark-tree>
     <xsl:apply-templates select="/" mode="outline-to-bookmark-tree" />
    </fo:bookmark-tree>
   </xsl:if>
  </xsl:if>

  <!-- Copy and continue -->
  <!--                   -->
  <xsl:copy>
   <xsl:choose>
    <xsl:when test="count(key('fo-nodes-by-id', @id)[1] | .) = 1">
     <xsl:copy-of select="@*" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:copy-of select="@*[local-name() != 'id']" />
    </xsl:otherwise>
   </xsl:choose>

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>


 <!-- Handle issues related to broken links and references -->
 <!--                                                      -->

 <xsl:template match="fo:basic-link[(string-length(@external-destination) = 0) and (string-length(@internal-destination) = 0)]">
  <!-- Drop invalid links -->
  <!--                    -->
  <xsl:apply-templates />
 </xsl:template>


 <xsl:template match="fo:page-number-citation[string-length(@ref-id) = 0]">
  <!-- Drop invalid links -->
  <!--                    -->
  <xsl:apply-templates />
 </xsl:template>


 <!-- Workaround empty fo:inline elements with ids -->
 <!--                                              -->

 <xsl:template match="fo:block[string-length(@id) = 0]">
  <!-- Search for empty fo:inline elements -->
  <!--                                     -->
  <xsl:variable name="VarIgnoredId">
   <xsl:for-each select="./fo:inline[(string-length(@id) &gt; 0) and (count(./* | ./text()) = 0)][1]">
    <xsl:if test="count(key('fo-nodes-by-id', @id)[1] | .) = 1">
     <xsl:value-of select="@id" />
    </xsl:if>
   </xsl:for-each>
  </xsl:variable>

  <xsl:copy>
   <!-- Preserve ignored @id on this element -->
   <!--                                      -->
   <xsl:if test="string-length($VarIgnoredId) &gt; 0">
    <xsl:attribute name="id">
     <xsl:value-of select="$VarIgnoredId" />
    </xsl:attribute>
   </xsl:if>
   <xsl:copy-of select="@*[local-name() != 'id']" />

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>

 <xsl:template match="fo:inline[string-length(@id) &gt; 0]">
  <!-- Emit if the element has children -->
  <!--                                  -->
  <xsl:if test="count(./* | ./text()) &gt; 0">
   <xsl:copy>
    <xsl:choose>
     <xsl:when test="count(key('fo-nodes-by-id', @id)[1] | .) = 1">
      <xsl:copy-of select="@*" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:copy-of select="@*[local-name() != 'id']" />
     </xsl:otherwise>
    </xsl:choose>

    <xsl:apply-templates />
   </xsl:copy>
  </xsl:if>
 </xsl:template>


 <!-- Copy nodes by default -->
 <!--                       -->

 <xsl:template match="*">
  <xsl:copy>
   <xsl:choose>
    <xsl:when test="count(key('fo-nodes-by-id', @id)[1] | .) = 1">
     <xsl:copy-of select="@*" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:copy-of select="@*[local-name() != 'id']" />
    </xsl:otherwise>
   </xsl:choose>

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="comment() | processing-instruction() | text()">
  <xsl:copy />
 </xsl:template>


 <!-- fox:outline to fo:bookmark-tree migration -->
 <!--                                           -->

 <xsl:template match="fox:outline" mode="outline-to-bookmark-tree">
  <fo:bookmark>
   <xsl:choose>
    <xsl:when test="count(key('fo-nodes-by-id', @id)[1] | .) = 1">
     <xsl:copy-of select="@*" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:copy-of select="@*[local-name() != 'id']" />
    </xsl:otherwise>
   </xsl:choose>

   <xsl:apply-templates mode="outline-to-bookmark-tree" />
  </fo:bookmark>
 </xsl:template>


 <xsl:template match="fox:label[parent::fox:outline]" mode="outline-to-bookmark-tree">
  <fo:bookmark-title>
   <xsl:value-of select="./text()" />
  </fo:bookmark-title>
 </xsl:template>


 <xsl:template match="*" mode="outline-to-bookmark-tree">
  <xsl:apply-templates mode="outline-to-bookmark-tree" />
 </xsl:template>


 <xsl:template match="comment() | processing-instruction() | text()" mode="outline-to-bookmark-tree">
  <!-- Suppress -->
  <!--          -->
 </xsl:template>
</xsl:stylesheet>
