<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xslout="http://www.w3.org/1999/XSL/TransformAlias"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwtype="urn:WebWorks-Type-Schema"
                              exclude-result-prefixes="xsl xslout wwmode">
 <!-- Based on DITA-1.4.1 "xsl/xslhtml/rel-links.xsl" -->
 <!--                                                 -->


 <xsl:output method="xml" indent="no"/>


 <xsl:key name="link" match="*[contains(@class, ' topic/link ')][not(ancestor::*[contains(@class, ' topic/linklist ')])]" use="concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*)"/>
 <xsl:key name="linkdup" match="*[contains(@class, ' topic/link ')][not(ancestor::*[contains(@class, ' topic/linklist ')])][not(@role='child' or @role='parent' or @role='previous' or @role='next' or @role='ancestor' or @role='descendant')]" use="concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href)"/>
 <xsl:key name="hideduplicates" match="*[contains(@class, ' topic/link ')][not(ancestor::*[contains(@class, ' topic/linklist ')])][not(@role) or @role='previous' or @role='next' or @role='cousin' or @role='external' or @role='friend' or @role='other' or @role='sample' or @role='sibling']" use="concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ',@href,@scope,@audience,@platform,@product,@otherprops,@rev,@type,normalize-space(child::*))"/>
 <xsl:key name="topics_by_id" match="*[contains(@class, ' topic/topic ')]" use="@id" />


 <xsl:template match="/">
  <xsl:apply-templates />
 </xsl:template>


 <!--main template for setting up all links after the body - applied to the related-links container-->
 <xsl:template match="*[contains(@class,' topic/related-links ')]">
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <!-- Group links per DITA HTML output rules -->
   <!--                                        -->

   <xsl:call-template name="prereq-links" />

   <xsl:call-template name="ul-child-links"/><!--handle child/descendants outside of linklists in collection-type=unordered or choice-->

   <xsl:call-template name="ol-child-links"/><!--handle child/descendants outside of linklists in collection-type=ordered/sequence-->

   <xsl:call-template name="next-prev-parent-links"/><!--handle next and previous links-->

   <xsl:call-template name="concept-links"/><!--sort remaining concept links by type-->

   <xsl:call-template name="task-links"/><!--sort remaining task links by type-->

   <xsl:call-template name="reference-links"/><!--sort remaining reference links by type-->

   <xsl:call-template name="relinfo-links"/><!--handle remaining untyped and unknown-type links-->

   <!--linklists - last but not least, create all the linklists and their links, with no sorting or re-ordering-->
   <xsl:apply-templates select="*[contains(@class,' topic/linklist ')]"/>
  </xsl:copy>
 </xsl:template>


 <!--create prerequisite links with all dups eliminated. -->
 <xsl:template name="prereq-links">
  <!--if there are any prereqs create a list with dups-->
  <xsl:if test="descendant::*[contains(@class, ' topic/link ')][not(ancestor::*[contains(@class, ' topic/linklist ')])][@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='previous' or @role='cousin')]">
   <linkpool class="- topic/linkpool ">
     <!--only create link if there is an href, its importance is required, and the role is compatible (don't want a prereq showing up for a "next" or "parent" link, for example) - remove dups-->
     <xsl:apply-templates select="descendant::*[count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1]
                                  [@href]
                                  [@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='previous' or @role='cousin')]
                                  [not(ancestor::*[contains(@class, ' topic/linklist ')])]"/>
   </linkpool>
  </xsl:if>
 </xsl:template>


 <!-- children links - handle all child or descendant links except those in linklists or ordered collection-types. -->
 <xsl:template name="ul-child-links">
  <xsl:if test="descendant::*[contains(@class, ' topic/link ')][@role='child' or @role='descendant'][not(parent::*/@collection-type='sequence')][not(ancestor::*[contains(@class, ' topic/linklist ')])]">
   <!--once you've tested that at least one child/descendant exists, apply templates to only the unique ones-->
   <xsl:variable name="child-links" select="descendant::*
                                            [count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1]
                                            [contains(@class, ' topic/link ')]
                                            [@role='child' or @role='descendant']
                                            [not(parent::*/@collection-type='sequence')]
                                            [not(ancestor::*[contains(@class, ' topic/linklist ')])]"/>

   <linkpool class="- topic/linkpool ">
    <xsl:copy-of select="$child-links[1]/parent::*/@collection-type" />

    <xsl:apply-templates select="$child-links" mode="webworks-child-links" />
   </linkpool>
  </xsl:if>
 </xsl:template>

 <!-- children links - handle all child or descendant links in ordered collection-types. -->
 <xsl:template name="ol-child-links">
  <xsl:if test="descendant::*[contains(@class, ' topic/link ')][@role='child' or @role='descendant'][parent::*/@collection-type='sequence'][not(ancestor::*[contains(@class, ' topic/linklist ')])]">
   <!--once you've tested that at least one child/descendant exists, apply templates to only the unique ones-->
   <xsl:variable name="child-links" select="descendant::*
                                            [count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1]
                                            [contains(@class, ' topic/link ')]
                                            [@role='child' or @role='descendant']
                                            [parent::*/@collection-type='sequence']
                                            [not(ancestor-or-self::*[contains(@class, ' topic/linklist ')])]"/>

   <linkpool class="- topic/linkpool ">
    <xsl:copy-of select="$child-links[1]/parent::*/@collection-type" />

    <xsl:apply-templates select="$child-links" mode="webworks-child-links" />
   </linkpool>
  </xsl:if>
 </xsl:template>


 <!--create the next and previous links, with accompanying parent link if any; create group for each unique parent, as well as for any next and previous links that aren't in the same group as a parent -->
 <xsl:template name="next-prev-parent-links">
  <xsl:variable name="descendant-links" select="descendant::*
                                               [contains(@class, ' topic/link ')]
                                               [(@role='parent' and
                                                 count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1
                                                ) or (@role='next' and
                                                      count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1
                                                ) or (@role='previous' and
                                                      count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1
                                               )]/parent::*" />

  <xsl:if test="count($descendant-links[1]) = 1">
   <linkpool class="- topic/linkpool ">
    <xsl:for-each select="$descendant-links">
     <xsl:choose>
      <xsl:when test="*[@href][@role='parent']">
       <xsl:for-each select="*[@href][@role='parent']">
        <!-- Only keep my real parent! -->
        <!--                           -->
        <xsl:variable name="target_id" select="substring-after(./@href, '#')" />
        <xsl:variable name="parent_id" select="./ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/parent::*[contains(@class, ' topic/topic ')]/@id" />
        <xsl:if test="$target_id = $parent_id">
         <xsl:apply-templates select="." />
        </xsl:if>
       </xsl:for-each>
      </xsl:when>

      <xsl:otherwise>
       <xsl:for-each select="*[@href][@role='ancestor']">
        <!-- Only keep my real parent! -->
        <!--                           -->
        <xsl:variable name="target_id" select="substring-after(./@href, '#')" />
        <xsl:variable name="parent_id" select="./ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/parent::*[contains(@class, ' topic/topic ')]/@id" />
        <xsl:if test="$target_id = $parent_id">
         <xsl:apply-templates select="." />
        </xsl:if>
       </xsl:for-each>
      </xsl:otherwise>
     </xsl:choose>

     <xsl:for-each select="*[@href][@role='previous']">
      <xsl:apply-templates select="." />
     </xsl:for-each>
     <xsl:for-each select="*[@href][@role='next']">
      <xsl:apply-templates select="." />
     </xsl:for-each>
    </xsl:for-each>
   </linkpool>
  </xsl:if>
 </xsl:template>


 <!-- type templates: concept, task, reference, relinfo -->

 <xsl:template name="concept-links">
  <!--related concepts - all the related concept links that haven't already been covered as a child/descendant/ancestor/next/previous/prerequisite, and aren't in a linklist -->
  <xsl:if test="descendant::*[contains(@class, ' topic/link ')]
                [not(ancestor::*[contains(@class,' topic/linklist ')])]
                [not(@role='child' or @role='descendant' or @role='ancestor' or @role='parent' or @role='next' or @role='previous')]
                [not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
                [@type='concept']">
   <linkpool class="- topic/linkpool ">
    <!--once the related concepts section is set up, sort links by role within the section, using a shared sorting routine so that it's consistent across sections-->
    <xsl:call-template name="sort-links-by-role"><xsl:with-param name="type">concept</xsl:with-param></xsl:call-template>
   </linkpool>
  </xsl:if>
 </xsl:template>

 <xsl:template name="task-links">
  <!--related tasks - all the related task links that haven't already been covered as a child/descendant/ancestor/next/previous/prerequisite, and aren't in a linklist-->
  <xsl:if test="descendant::*[contains(@class, ' topic/link ')]
                [not(ancestor::*[contains(@class,' topic/linklist ')])]
                [not(@role='child' or @role='descendant' or @role='ancestor' or @role='parent' or @role='next' or @role='previous')]
                [not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
                [@type='task']">
   <linkpool class="- topic/linkpool ">
     <!--once the related tasks section is set up, sort links by role within the section, using a shared sorting routine so that it's consistent across sections-->
     <xsl:call-template name="sort-links-by-role"><xsl:with-param name="type">task</xsl:with-param></xsl:call-template>
   </linkpool>
  </xsl:if>
 </xsl:template>


 <xsl:template name="reference-links">
  <!--related reference - all the related reference links that haven't already been covered as a child/descendant/ancestor/next/previous/prerequisite, and aren't in a linklist-->
   <xsl:if test="descendant::*
                 [contains(@class, ' topic/link ')]
                 [not(ancestor::*[contains(@class,' topic/linklist ')])]
                 [not(@role='child' or @role='descendant' or @role='ancestor' or @role='parent' or @role='next' or @role='previous')]
                 [not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]
                 [@type='reference']">
   <linkpool class="- topic/linkpool ">
     <!--once the related reference section is set up, sort links by role within the section, using a shared sorting routine so that it's consistent across sections-->
     <xsl:call-template name="sort-links-by-role"><xsl:with-param name="type">reference</xsl:with-param></xsl:call-template>
   </linkpool>
  </xsl:if>
 </xsl:template>


 <xsl:template name="relinfo-links">
  <!--other info- - not currently sorting by role, since already mixing any number of types in here-->
  <!--if there are links not covered by any of the other routines - ie, not in a linklist, not a child or descendant, not a concept/task/reference, not ancestor/next/previous, not prerequisite - create a section for them and create the links-->
  <xsl:if test="descendant::*
                [contains(@class, ' topic/link ')]
                [not(ancestor::*[contains(@class,' topic/linklist ')])]
                [not(@role='child' or @role='descendant' or @role='ancestor' or @role='parent' or @role='next' or @role='previous' or @type='concept' or @type='task' or @type='reference')]
                [not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]">
   <linkpool class="- topic/linkpool ">
    <!--once section is created, create the links, using the same rules as bove plus a uniqueness check-->
    <xsl:for-each select="descendant::*
                          [not(ancestor::*[contains(@class,' topic/linklist ')])]
                          [count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1]
                          [contains(@class, ' topic/link ')]
                          [not(@role='child' or @role='descendant' or @role='ancestor' or @role='parent' or @role='next' or @role='previous' or @type='concept' or @type='task' or @type='reference')]
                          [not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]">
     <xsl:apply-templates select="."/>
    </xsl:for-each>
   </linkpool>
  </xsl:if>
 </xsl:template>


 <!--template used within concept/task/reference sections to sort links-->
 <xsl:template name="sort-links-by-role">
  <xsl:param name="type">topic</xsl:param>

  <!--create all sibling links of the specified type-->
  <xsl:call-template name="create-links"><xsl:with-param name="role">sibling</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
  <!--create all cousin links of the specified type-->
  <xsl:call-template name="create-links"><xsl:with-param name="role">cousin</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
  <!--create all friend links of the specified type-->
  <xsl:call-template name="create-links"><xsl:with-param name="role">friend</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
  <!--create all links with role="other" of the specified type-->
  <xsl:call-template name="create-links"><xsl:with-param name="role">other</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
  <!--create all links with no role of the specified type-->
  <xsl:call-template name="create-links"><xsl:with-param name="role">#none#</xsl:with-param><xsl:with-param name="type"><xsl:value-of select="$type"/></xsl:with-param></xsl:call-template>
 </xsl:template>


 <xsl:template name="create-links">
  <!--create links of the specified type and role-->
  <xsl:param name="type">topic</xsl:param>
  <xsl:param name="role">friend</xsl:param>

  <xsl:choose>
   <!--when processing links with no role, apply templates to links that are unique, not in a linklist, don't have a role attribute, match the specified type, and aren't prerequisites-->
   <xsl:when test="$role='#none#'">
    <xsl:for-each select="descendant::*
                          [count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1]
                          [contains(@class, ' topic/link ')]
                          [not(ancestor::*[contains(@class,' topic/linklist ')])]
                          [not(@role)]
                          [@type=$type]
                          [not(@importance='required')]">
     <xsl:apply-templates select="."/>
    </xsl:for-each>
   </xsl:when>

   <!--when processing links with a specified role, apply templates to links that are unique, not in a linklist, match the specified role and type, and aren't prerequisites-->
   <xsl:otherwise>
    <xsl:for-each select="descendant::*
                          [count( . | key('link',concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1]) = 1]
                          [not(ancestor::*[contains(@class,' topic/linklist ')])]
                          [contains(@class, ' topic/link ')]
                          [@role=$role]
                          [@type=$type]
                          [not(@importance='required' and (@role='sibling' or @role='friend' or @role='previous' or @role='cousin'))]">
       <xsl:apply-templates select="."/>
    </xsl:for-each>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <!--basic child processing-->
 <xsl:template match="*[contains(@class, ' topic/link ')][@role='child' or @role='descendant']" priority="2" name="topic.link_child">
  <xsl:copy-of select="." />
 </xsl:template>


 <!--ordered child processing-->
 <xsl:template match="*[@collection-type='sequence']/*[contains(@class, ' topic/link ')][@role='child' or @role='descendant']">
  <xsl:copy-of select="." />
 </xsl:template>


 <xsl:template match="*[contains(@class, ' topic/link ')]">
  <xsl:choose>
   <!-- Linklist links put out <br/> in "processlinklist" -->
   <xsl:when test="ancestor::*[contains(@class,' topic/linklist ')]">
    <xsl:copy-of select="." />
   </xsl:when>

   <!-- Ancestor links go in the breadcrumb trail, and should not get a <br/> -->
   <xsl:when test="@role='ancestor'">
    <xsl:copy-of select="." />
   </xsl:when>

   <!-- Items with these roles should always go to output, and are not included in the hideduplicates key. -->
   <xsl:when test="@role and not(@role='previous' or @role='next' or @role='cousin' or @role='external' or @role='friend' or @role='other' or @role='sample' or @role='sibling')">
    <xsl:copy-of select="." />
   </xsl:when>

   <!-- If roles do not match, but nearly everything else does, skip the link. -->
   <xsl:when test="(key('hideduplicates', concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ',@href,@scope,@audience,@platform,@product,@otherprops,@rev,@type,normalize-space(child::*))))[2]">
    <xsl:choose>
     <xsl:when test="count( . | key('hideduplicates', concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ',@href,@scope,@audience,@platform,@product,@otherprops,@rev,@type,normalize-space(child::*)))[1]) = 1">
      <xsl:copy-of select="." />
     </xsl:when>

     <!-- If this is filtered out, we may need the duplicate link message anyway. -->
     <xsl:otherwise>
      <xsl:call-template name="linkdupinfo"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>

   <xsl:otherwise>
    <xsl:copy-of select="." />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="linkdupinfo">
  <xsl:if test="(key('linkdup', concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href)))[2]">
   <xsl:if test="count( . | key('linkdup', concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href))[1]) = 1">
    <!-- If the link is exactly the same, do not output message.  The duplicate will automatically be removed. -->
    <xsl:if test="not(key('link', concat(generate-id(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]), ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[2])">
     <xsl:message>
      Duplicate link detected in topic
      &quot;<xsl:value-of select="@xtrf" />&quot;
      pointing to
      &quot;<xsl:value-of select="@href" />&quot;
      .
     </xsl:message>
    </xsl:if>
   </xsl:if>
  </xsl:if>
 </xsl:template>


 <!-- Table column numbers -->
 <!--                      -->
 <xsl:template match="*[contains(@class, ' topic/colspec ')]">
  <!-- Copy colspecs as is -->
  <!--                     -->
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <!-- Add colnum if not present -->
   <!--                           -->
   <xsl:if test="string-length(@colnum) = 0">
    <xsl:attribute name="colnum">
     <xsl:value-of select="count(./preceding-sibling::*[contains(@class, ' topic/colspec ')]) + 1" />
    </xsl:attribute>
   </xsl:if>

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="*[contains(@class, ' topic/entry ')]">
  <!-- DITA-OT PDF output fails when source contains @colsep -->
  <!--                                                      -->
  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'colsep']" />

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>


 <!-- Ensure topic IDs are unique -->
 <!--                             -->
 <xsl:template match="*[contains(@class, ' topic/topic ')]">
  <xsl:choose>
   <xsl:when test="count( . | key('topics_by_id', ./@id)[1]) = 1">
    <xsl:copy>
     <xsl:copy-of select="@*" />

     <xsl:apply-templates />
    </xsl:copy>
   </xsl:when>

   <xsl:otherwise>
    <xsl:copy>
     <xsl:attribute name="id">
      <xsl:value-of select="@id" />
      <xsl:text>_</xsl:text>
      <xsl:value-of select="generate-id(.)" />
     </xsl:attribute>
     <xsl:copy-of select="@*[name() != 'id']" />

     <xsl:apply-templates />
    </xsl:copy>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template match="*" mode="webworks-child-links">
  <xsl:param name="ParamChildLink" select="." />

  <!-- Check child IDs -->
  <!--                 -->
  <xsl:variable name="VarChildTopics" select="$ParamChildLink/ancestor::*[contains(@class, ' topic/related-links ')]/following-sibling::*[contains(@class, ' topic/topic ')]" />
  <xsl:variable name="VarChildTopicID" select="substring-after($ParamChildLink/@href, '#')" />
  <xsl:for-each select="$VarChildTopics[@id = $VarChildTopicID]">
   <xsl:variable name="VarChildTopic" select="." />

   <!-- Check ID for uniqueness -->
   <!--                         -->
   <xsl:variable name="VarHREF">
    <xsl:choose>
     <xsl:when test="count($VarChildTopic | key('topics_by_id', $VarChildTopic/@id)[1]) = 1">
      <xsl:text>#</xsl:text>
      <xsl:value-of select="$VarChildTopic/@id" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:text>#</xsl:text>
      <xsl:value-of select="$VarChildTopic/@id" />
      <xsl:text>_</xsl:text>
      <xsl:value-of select="generate-id($VarChildTopic)" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Emit link -->
   <!--           -->
   <xsl:for-each select="$ParamChildLink">
    <xsl:copy>
     <xsl:copy-of select="@*[name() != 'href']" />
     <xsl:attribute name="href">
      <xsl:value-of select="$VarHREF" />
     </xsl:attribute>

     <xsl:apply-templates />
    </xsl:copy>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <!-- Default matches -->
 <!--                 -->

 <xsl:template match="*">
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="comment() | processing-instruction() | text()">
  <xsl:copy />
 </xsl:template>
</xsl:stylesheet>
