<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xslout="http://www.w3.org/1999/XSL/TransformAlias"
                              xmlns:wwditaconfig="urn:WebWorks-Dita-Configuration-Schema"
                              exclude-result-prefixes="wwditaconfig">
 <xsl:output method="xml" indent="yes" />
 <xsl:strip-space elements="*" />
 <xsl:namespace-alias stylesheet-prefix="xslout" result-prefix="xsl" />


 <xsl:template match="/">
  <xslout:stylesheet version="1.0">
   <xslout:output method="xml" indent="yes"/>

   <xslout:template match="/">
    <wwditaconfig:Styles>

     <xsl:for-each select="/wwditaconfig:DitaConfiguration/wwditaconfig:Styles/wwditaconfig:Style">
      <xsl:variable name="VarStyle" select="." />

      <xslout:for-each select="{$VarStyle/@match}">
       <xslout:variable name="VarNode" select="." />

       <wwditaconfig:Style>
        <xslout:attribute name="id">
         <xslout:value-of select="$VarNode/@wwditaconfig:id" />
        </xslout:attribute>

        <xsl:copy-of select="$VarStyle/*" />
       </wwditaconfig:Style>
      </xslout:for-each>
     </xsl:for-each>

    </wwditaconfig:Styles>
   </xslout:template>
  </xslout:stylesheet>
 </xsl:template>
</xsl:stylesheet>
