<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xslout="http://www.w3.org/1999/XSL/TransformAlias"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwtype="urn:WebWorks-Type-Schema"
                              exclude-result-prefixes="xsl xslout wwmode">
 <xsl:param name="GlobalDitaMapPath" />


 <xsl:output method="xml" indent="no"/>


 <xsl:variable name="GlobalDitaMap" select="document($GlobalDitaMapPath)" />


 <xsl:template match="/">
  <xsl:apply-templates />
 </xsl:template>


 <xsl:template match="comment() | processing-instruction() | text()">
  <xsl:copy />
 </xsl:template>


 <xsl:template match="*[not(contains(@class, ' map/topicref ')) and not(contains(@class, ' topic/title '))]">
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="*[contains(@class, ' map/topicref ')]">
  <xsl:param name="ParamNode" select="." />

  <xsl:copy>
   <xsl:copy-of select="@*[name() != 'wwtype:type']" />

   <xsl:if test="(string-length(@navtitle) &gt; 0) and (@wwtype:type = 'Paragraph')">
    <title class="- topic/title ">
     <xsl:copy-of select="$ParamNode/@*[name() != 'class']" />

     <xsl:value-of select="$ParamNode/@navtitle" />
    </title>
   </xsl:if>

   <xsl:apply-templates />
  </xsl:copy>
 </xsl:template>


 <xsl:template match="*[contains(@class, ' topic/title ')]">
  <xsl:param name="ParamNode" select="." />

  <!-- Copy existing node -->
  <!--                    -->
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:apply-templates />
  </xsl:copy>

  <!-- Handle alternate navigation title -->
  <!--                                   -->
  <xsl:if test="count($ParamNode/following-sibling::*[contains(@class, ' topic/titlealts ')]) = 0">
   <!-- Emit alternate navigation title? -->
   <!--                                  -->
   <xsl:variable name="VarAlternateNavigationTitle">
    <xsl:call-template name="Alternate-Navigation-Title">
     <xsl:with-param name="ParamTopicNode" select="$ParamNode/parent::*" />
    </xsl:call-template>
   </xsl:variable>

   <xsl:if test="string-length($VarAlternateNavigationTitle) &gt; 0">
    <titlealts class="- topic/titlealts ">
     <navtitle class="- topic/navtitle ">
      <xsl:value-of select="$VarAlternateNavigationTitle" />
     </navtitle>
    </titlealts>
   </xsl:if>
  </xsl:if>
 </xsl:template>


 <xsl:template match="*[contains(@class, ' topic/titlealts ')]">
  <xsl:param name="ParamNode" select="." />

  <!-- Copy existing node -->
  <!--                    -->
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:apply-templates />
  </xsl:copy>

  <!-- Handle alternate navigation title -->
  <!--                                   -->
  <xsl:if test="count($ParamNode/*[contains(@class, ' topic/navtitle ')]) = 0">
   <!-- Emit alternate navigation title? -->
   <!--                                  -->
   <xsl:variable name="VarAlternateNavigationTitle">
    <xsl:call-template name="Alternate-Navigation-Title">
     <xsl:with-param name="ParamTopicNode" select="$ParamNode/parent::*/parent::*" />
    </xsl:call-template>
   </xsl:variable>

   <xsl:if test="string-length($VarAlternateNavigationTitle) &gt; 0">
    <navtitle class="- topic/navtitle ">
     <xsl:value-of select="$VarAlternateNavigationTitle" />
    </navtitle>
   </xsl:if>
  </xsl:if>
 </xsl:template>


 <xsl:template match="*[contains(@class, ' topic/navtitle ')]">
  <xsl:param name="ParamNode" select="." />

  <!-- Copy existing node -->
  <!--                    -->
  <xsl:copy>
   <xsl:copy-of select="@*" />

   <!-- Emit alternate navigation title? -->
   <!--                                  -->
   <xsl:variable name="VarAlternateNavigationTitle">
    <xsl:call-template name="Alternate-Navigation-Title">
     <xsl:with-param name="ParamTopicNode" select="$ParamNode/parent::*/parent::*/parent::*" />
    </xsl:call-template>
   </xsl:variable>

   <!-- Handle alternate navigation title -->
   <!--                                   -->
   <xsl:choose>
    <xsl:when test="string-length($VarAlternateNavigationTitle) &gt; 0">
     <xsl:value-of select="$VarAlternateNavigationTitle" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:apply-templates />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:copy>
 </xsl:template>


 <xsl:template name="Alternate-Navigation-Title">
  <xsl:param name="ParamTopicNode" />

  <!-- Determine signature -->
  <!--                     -->
  <xsl:variable name="VarSignature">
   <xsl:call-template name="Signature-Record">
    <xsl:with-param name="ParamNode" select="$ParamTopicNode" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Convert signature to navtitle -->
  <!--                               -->
  <xsl:call-template name="Signature-To-Navigation-Title">
   <xsl:with-param name="ParamParent" select="$GlobalDitaMap" />
   <xsl:with-param name="ParamSignature" select="$VarSignature" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="Signature-Record">
  <xsl:param name="ParamNode" />

  <xsl:if test="$ParamNode">
   <xsl:call-template name="Signature-Record">
    <xsl:with-param name="ParamNode" select="$ParamNode/parent::*" />
   </xsl:call-template>

   <xsl:choose>
    <xsl:when test="contains($ParamNode/@class, ' map/map ')">
     <xsl:text>map#</xsl:text>
     <xsl:value-of select="count($ParamNode/preceding-sibling::*[contains(@class, ' map/map ')]) + 1" />
     <xsl:text>:</xsl:text>
    </xsl:when>

    <xsl:when test="contains($ParamNode/@class, ' map/topicref ')">
     <xsl:text>topicref#</xsl:text>
     <xsl:value-of select="count($ParamNode/preceding-sibling::*[contains(@class, ' map/topicref ')]) + 1" />
     <xsl:text>:</xsl:text>
    </xsl:when>

    <xsl:when test="contains($ParamNode/@class, ' topic/topic ')">
     <xsl:text>topic#</xsl:text>
     <xsl:value-of select="count($ParamNode/preceding-sibling::*[contains(@class, ' topic/topic ')]) + 1" />
     <xsl:text>:</xsl:text>
    </xsl:when>

    <xsl:when test="contains($ParamNode/@class, ' topic/table ')">
     <xsl:text>table#</xsl:text>
     <xsl:value-of select="count($ParamNode/preceding-sibling::*[contains(@class, ' topic/table ')]) + 1" />
     <xsl:text>:</xsl:text>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Signature-To-Navigation-Title">
  <xsl:param name="ParamParent" />
  <xsl:param name="ParamSignature" />

  <xsl:variable name="VarFirstEntry" select="substring-before($ParamSignature, ':')" />
  <xsl:variable name="VarRemainingEntries" select="substring-after($ParamSignature, ':')" />

  <xsl:variable name="VarEntryType" select="substring-before($VarFirstEntry, '#')" />
  <xsl:variable name="VarEntryPosition" select="substring-after($VarFirstEntry, '#')" />

  <xsl:choose>
   <xsl:when test="$VarEntryType = 'map'">
    <xsl:for-each select="$ParamParent/*[contains(@class, ' map/map ')]">
     <xsl:variable name="VarNode" select="." />
     <xsl:variable name="VarPosition" select="position()" />

     <xsl:if test="$VarPosition = $VarEntryPosition">
      <xsl:call-template name="Signature-To-Navigation-Title">
       <xsl:with-param name="ParamParent" select="." />
       <xsl:with-param name="ParamSignature" select="$VarRemainingEntries" />
      </xsl:call-template>
     </xsl:if>
    </xsl:for-each>
   </xsl:when>

   <xsl:when test="$VarEntryType = 'topicref'">
    <xsl:for-each select="$ParamParent/*[contains(@class, ' map/topicref ')]">
     <xsl:variable name="VarNode" select="." />
     <xsl:variable name="VarPosition" select="position()" />

     <xsl:if test="$VarPosition = $VarEntryPosition">
      <xsl:call-template name="Signature-To-Navigation-Title">
       <xsl:with-param name="ParamParent" select="." />
       <xsl:with-param name="ParamSignature" select="$VarRemainingEntries" />
      </xsl:call-template>
     </xsl:if>
    </xsl:for-each>
   </xsl:when>

   <xsl:when test="$VarEntryType = 'topic'">
    <xsl:for-each select="$ParamParent/*[contains(@class, ' map/topicref ')]">
     <xsl:variable name="VarNode" select="." />
     <xsl:variable name="VarPosition" select="position()" />

     <xsl:if test="$VarPosition = $VarEntryPosition">
      <xsl:choose>
       <xsl:when test="string-length($VarRemainingEntries) = 0">
        <xsl:if test="(string-length($VarNode/@navtitle) &gt; 0) and ($VarNode/@locktitle = 'yes')">
         <xsl:value-of select="$VarNode/@navtitle" />
        </xsl:if>
       </xsl:when>

       <xsl:otherwise>
        <xsl:call-template name="Signature-To-Navigation-Title">
         <xsl:with-param name="ParamParent" select="." />
         <xsl:with-param name="ParamSignature" select="$VarRemainingEntries" />
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:if>
    </xsl:for-each>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
