<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xslout="http://www.w3.org/1999/XSL/TransformAlias"
                              xmlns:wwditaconfig="urn:WebWorks-Dita-Configuration-Schema"
                              exclude-result-prefixes="wwditaconfig">
 <xsl:output method="xml" indent="yes"/>
 <xsl:strip-space elements="*" />
 <xsl:namespace-alias stylesheet-prefix="xslout" result-prefix="xsl" />


 <xsl:template match="/">
  <xslout:stylesheet version="1.0">
   <xslout:output method="xml" indent="yes"/>

   <xslout:template match="/">
    <wwditaconfig:Types>

     <xsl:for-each select="/wwditaconfig:DitaConfiguration/wwditaconfig:Types/wwditaconfig:Type">
      <xsl:variable name="VarType" select="." />

      <xslout:for-each select="{$VarType/@match}">
       <xsl:variable name="VarID">
        <xsl:text>{@wwditaconfig:id}</xsl:text>
       </xsl:variable>

       <wwditaconfig:Type id="{$VarID}" value="{$VarType/@value}" />
      </xslout:for-each>
     </xsl:for-each>

    </wwditaconfig:Types>
   </xslout:template>
  </xslout:stylesheet>
 </xsl:template>
</xsl:stylesheet>
