<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xslout="http://www.w3.org/1999/XSL/TransformAlias"
                              xmlns:wwditaconfig="urn:WebWorks-Dita-Configuration-Schema"
                              xmlns:wwtype="urn:WebWorks-Type-Schema"
                              xmlns:wwinfo="urn:WebWorks-Info"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              exclude-result-prefixes="xsl xslout wwinfo">
 <xsl:param name="GlobalStyleMapPath" />
 <xsl:param name="GlobalTypeMapPath" />


 <xsl:output method="xml" indent="no"/>
 <xsl:strip-space elements="wwdoc:*" />


 <xsl:key name="wwditaconfig-styles-by-id" match="wwditaconfig:Style" use="@id" />
 <xsl:key name="wwditaconfig-types-by-id" match="wwditaconfig:Type" use="@id" />


 <xsl:variable name="GlobalStyleMap" select="document($GlobalStyleMapPath)" />
 <xsl:variable name="GlobalTypeMap" select="document($GlobalTypeMapPath)" />


 <xsl:template match="/">
  <xsl:apply-templates />
 </xsl:template>


 <xsl:template match="comment() | processing-instruction() | text()">

  <xsl:copy />
 </xsl:template>


 <xsl:template name="Node-Style">
  <xsl:param name="ParamStyleNode" />
  <xsl:param name="ParamNode" />

  <!-- Determine type -->
  <!--                -->
  <xsl:variable name="VarType">
   <xsl:call-template name="Node-Type">
    <xsl:with-param name="ParamNode" select="$ParamStyleNode" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Determine outputclass -->
  <!--                       -->
  <xsl:for-each select="$GlobalStyleMap[1]">
   <xsl:variable name="VarStyle" select="key('wwditaconfig-styles-by-id', $ParamStyleNode/@wwditaconfig:id)[1]" />

   <!-- Remainder exists? -->
   <!--                   -->
   <xsl:variable name="VarRemainderExistsAsText">
    <xsl:choose>
     <xsl:when test="($VarType = 'Paragraph') and (count($VarStyle/wwditaconfig:Remainder[1]) = 1)">
      <xsl:call-template name="Paragraph-Remainder-Exists">
       <xsl:with-param name="ParamParagraph" select="$ParamStyleNode" />
      </xsl:call-template>
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="false()" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>
   <xsl:variable name="VarRemainderExists" select="$VarRemainderExistsAsText = 'true'" />

   <!-- Use remainder style?             -->
   <!-- Only applies to paragraph styles -->
   <!--                                  -->
   <xsl:variable name="VarUseRemainderStyleAsText">
    <xsl:choose>
     <xsl:when test="($VarRemainderExists) and (count($ParamStyleNode | $ParamNode) &gt; 1)">
      <xsl:choose>
       <xsl:when test="count($ParamNode/preceding-sibling::*) &gt; 0">
        <xsl:value-of select="true()" />
       </xsl:when>

       <xsl:when test="count($ParamNode/preceding-sibling::text()) &gt; 0">
        <xsl:variable name="VarPrecedingTextRaw">
         <xsl:for-each select="$ParamNode/preceding-sibling::text()">
          <xsl:value-of select="." />
         </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="VarPrecedingText" select="normalize-space($VarPrecedingTextRaw)" />

        <xsl:choose>
         <xsl:when test="string-length($VarPrecedingText) &gt; 0">
          <xsl:value-of select="true()" />
         </xsl:when>

         <xsl:otherwise>
          <xsl:value-of select="false()" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="false()" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="false()" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>
   <xsl:variable name="VarUseRemainderStyle" select="$VarUseRemainderStyleAsText = 'true'" />

   <!-- Head -->
   <!--      -->
   <xsl:variable name="VarOutputClass">
    <xsl:choose>
     <!-- DTD outputclass -->
     <!--                 -->
     <xsl:when test="$ParamStyleNode/@outputclass">
      <xsl:value-of select="$ParamStyleNode/@outputclass" />
     </xsl:when>

     <!-- Special paragraph case? -->
     <!--                         -->
     <xsl:when test="($VarRemainderExists) and ($VarUseRemainderStyle)">
      <xsl:value-of select="$VarStyle/wwditaconfig:Remainder[1]/@name" />
     </xsl:when>

     <!-- Custom outputclass -->
     <!--                    -->
     <xsl:when test="count($VarStyle/wwditaconfig:Head[1]) = 1">
      <xsl:value-of select="$VarStyle/wwditaconfig:Head[1]/@name" />
     </xsl:when>
    </xsl:choose>
   </xsl:variable>

   <!-- Copy source -->
   <!--             -->
   <xsl:for-each select="$ParamNode">
    <xsl:copy>
     <xsl:copy-of select="@*[(local-name() != 'outputclass') and (namespace-uri() != 'urn:WebWorks-Dita-Configuration-Schema')]" />

     <!-- outputclass -->
     <!--             -->
     <xsl:if test="string-length($VarOutputClass) &gt; 0">
      <xsl:attribute name="outputclass">
       <xsl:value-of select="$VarOutputClass" />
      </xsl:attribute>
     </xsl:if>

     <!-- wwtype:remainderclass -->
     <!--                       -->
     <xsl:if test="($VarRemainderExists) and not($VarUseRemainderStyle)">
      <xsl:if test="count($VarStyle/wwditaconfig:Remainder[1]) = 1">
       <xsl:attribute name="remainderclass" namespace="urn:WebWorks-Type-Schema">
        <xsl:value-of select="$VarStyle/wwditaconfig:Remainder/@name" />
       </xsl:attribute>
      </xsl:if>
     </xsl:if>

     <!-- wwtype:type -->
     <!--             -->
     <xsl:if test="string-length($VarType) &gt; 0">
      <xsl:attribute name="type" namespace="urn:WebWorks-Type-Schema">
       <xsl:value-of select="$VarType" />
      </xsl:attribute>
     </xsl:if>

     <!-- Mark open? -->
     <!--            -->
     <xsl:variable name="VarMarkOpen" select="$VarStyle/wwditaconfig:Head[1]/@markopen" />
     <xsl:if test="string-length($VarMarkOpen) &gt; 0">
      <xsl:attribute name="markopen" namespace="urn:WebWorks-Type-Schema">
       <xsl:value-of select="$VarMarkOpen" />
      </xsl:attribute>
     </xsl:if>

     <!-- Mark close? -->
     <!--             -->
     <xsl:variable name="VarMarkClose" select="$VarStyle/wwditaconfig:Head[1]/@markclose" />
     <xsl:if test="string-length($VarMarkClose) &gt; 0">
      <xsl:attribute name="markclose" namespace="urn:WebWorks-Type-Schema">
       <xsl:value-of select="$VarMarkClose" />
      </xsl:attribute>
     </xsl:if>

     <!-- Emit style info -->
     <!--                 -->
     <xsl:choose>
      <!-- wwditaconfig:Remainder -->
      <!--                        -->
      <xsl:when test="$VarUseRemainderStyle">
       <xsl:if test="count($VarStyle/wwditaconfig:Remainder[1]) &gt; 0">
        <xsl:copy-of select="$VarStyle/wwditaconfig:Remainder[1]/wwdoc:*" />
       </xsl:if>
      </xsl:when>

      <!-- wwditaconfig:Head -->
      <!--                   -->
      <xsl:otherwise>
       <xsl:if test="count($VarStyle/wwditaconfig:Head[1]) &gt; 0">
        <xsl:copy-of select="$VarStyle/wwditaconfig:Head[1]/wwdoc:*" />
       </xsl:if>
      </xsl:otherwise>
     </xsl:choose>

     <xsl:apply-templates />
    </xsl:copy>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="*">
  <xsl:param name="ParamNode" select="." />

  <!-- Determine type -->
  <!--                -->
  <xsl:variable name="VarType">
   <xsl:call-template name="Node-Type">
    <xsl:with-param name="ParamNode" select="$ParamNode" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Special handling                                                            -->
  <!-- Paragraphs - Paragraph elements within list and table cell paragraph styles -->
  <!-- Characters - Phrase elements within character styles                        -->
  <!--                                                                             -->
  <xsl:variable name="VarOutputClassExists" select="string-length($ParamNode/@outputclass) &gt; 0" />
  <xsl:variable name="VarSpecialParagraph" select="($VarType = 'Paragraph') and (contains($ParamNode/@class, ' topic/p ')) and (string-length($ParamNode/@class) = string-length('+ topic/p ')) and (contains($ParamNode/parent::*/@class, ' topic/li ') or contains($ParamNode/parent::*/@class, ' topic/entry ') or contains($ParamNode/parent::*/@class, ' topic/stentry ') or contains($ParamNode/parent::*/@class, ' topic/dd '))" />
  <xsl:variable name="VarSpecialCharacter" select="($VarType = 'Character') and (contains($ParamNode/@class, ' topic/ph ')) and (string-length($ParamNode/@class) = string-length('+ topic/ph '))" />
  <xsl:variable name="VarSpecialHandling" select="not($VarOutputClassExists) and (($VarSpecialParagraph) or ($VarSpecialCharacter))" />
  <xsl:choose>
   <!-- Special handling? -->
   <!--                   -->
   <xsl:when test="$VarSpecialHandling">
    <!-- Check if parent element is same type -->
    <!--                                      -->
    <xsl:variable name="VarParentType">
     <xsl:call-template name="Node-Type">
      <xsl:with-param name="ParamNode" select="$ParamNode/parent::*" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <!-- Use parent's character style information -->
     <!--                                          -->
     <xsl:when test="$VarParentType = $VarType">
      <xsl:call-template name="Node-Style">
       <xsl:with-param name="ParamStyleNode" select="$ParamNode/parent::*" />
       <xsl:with-param name="ParamNode" select="$ParamNode" />
      </xsl:call-template>
     </xsl:when>

     <!-- Process normally -->
     <!--                  -->
     <xsl:otherwise>
      <xsl:call-template name="Node-Style">
       <xsl:with-param name="ParamStyleNode" select="$ParamNode" />
       <xsl:with-param name="ParamNode" select="$ParamNode" />
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>

   <!-- Process normally -->
   <!--                  -->
   <xsl:otherwise>
    <xsl:call-template name="Node-Style">
     <xsl:with-param name="ParamStyleNode" select="$ParamNode" />
     <xsl:with-param name="ParamNode" select="$ParamNode" />
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="Node-Type">
  <xsl:param name="ParamNode" />

  <xsl:for-each select="$GlobalTypeMap[1]">
   <xsl:variable name="VarTypes" select="key('wwditaconfig-types-by-id', $ParamNode/@wwditaconfig:id)" />

   <xsl:if test="count($VarTypes[1]) = 1">
    <xsl:value-of select="$VarTypes[1]/@value" />
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Paragraph-Remainder-Exists">
  <xsl:param name="ParamParagraph" />

  <xsl:apply-templates select="$ParamParagraph/node()[1]" mode="remainder-exists">
   <xsl:with-param name="ParamPreviousParagraphs" select="0" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="*" mode="remainder-exists">
  <xsl:param name="ParamNode" select="." />
  <xsl:param name="ParamPreviousParagraphs" />

  <xsl:variable name="VarType">
   <xsl:call-template name="Node-Type">
    <xsl:with-param name="ParamNode" select="$ParamNode" />
   </xsl:call-template>
  </xsl:variable>

  <xsl:variable name="VarFollowingNode" select="$ParamNode/following-sibling::node()[1]" />

  <xsl:choose>
   <xsl:when test="$VarType = 'Paragraph'">
    <!-- Remainder found! -->
    <!--                  -->
    <xsl:value-of select="true()" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:apply-templates select="$VarFollowingNode" mode="remainder-exists">
     <xsl:with-param name="ParamPreviousParagraphs" select="$ParamPreviousParagraphs" />
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template match="comment() | processing-instruction()" mode="remainder-exists">
  <xsl:param name="ParamNode" select="." />
  <xsl:param name="ParamPreviousParagraphs" />

  <xsl:variable name="VarFollowingNode" select="$ParamNode/following-sibling::node()[1]" />

  <xsl:apply-templates select="$VarFollowingNode" mode="remainder-exists">
   <xsl:with-param name="ParamPreviousParagraphs" select="$ParamPreviousParagraphs" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="text()" mode="remainder-exists">
  <xsl:param name="ParamNode" select="." />
  <xsl:param name="ParamPreviousParagraphs" />

  <xsl:variable name="VarFollowingNode" select="$ParamNode/following-sibling::node()[1]" />

  <xsl:choose>
   <xsl:when test="$ParamPreviousParagraphs &gt; 0">
    <!-- Remainder found! -->
    <!--                  -->
    <xsl:value-of select="string-length(normalize-space(.)) &gt; 0" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:apply-templates select="$VarFollowingNode" mode="remainder-exists">
     <xsl:with-param name="ParamPreviousParagraphs" select="$ParamPreviousParagraphs" />
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
