<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wwditaconfig="urn:WebWorks-Dita-Configuration-Schema">
 <xsl:param name="GlobalDefaultConfigurationPath" />
 <xsl:param name="GlobalDocumentConfigurationPath" />


 <xsl:output method="xml" indent="yes"/>
 <xsl:strip-space elements="*" />


 <xsl:template match="/">
  <wwditaconfig:DitaConfiguration version="1.0" xmlns="urn:WebWorks-Dita-Configuration-Schema">
   <wwditaconfig:Styles>
    <!-- Document Configuration -->
    <!--                        -->
    <xsl:call-template name="Document-Configuration-Styles">
     <xsl:with-param name="ParamPath" select="$GlobalDocumentConfigurationPath" />
    </xsl:call-template>

    <!-- Default Configuration -->
    <!--                       -->
    <xsl:call-template name="Document-Configuration-Styles">
     <xsl:with-param name="ParamPath" select="$GlobalDefaultConfigurationPath" />
    </xsl:call-template>
   </wwditaconfig:Styles>

   <wwditaconfig:Types>
    <!-- Document Configuration -->
    <!--                        -->
    <xsl:call-template name="Document-Configuration-Types">
     <xsl:with-param name="ParamPath" select="$GlobalDocumentConfigurationPath" />
    </xsl:call-template>

    <!-- Default Configuration -->
    <!--                       -->
    <xsl:call-template name="Document-Configuration-Types">
     <xsl:with-param name="ParamPath" select="$GlobalDefaultConfigurationPath" />
    </xsl:call-template>
   </wwditaconfig:Types>
  </wwditaconfig:DitaConfiguration>
 </xsl:template>


 <xsl:template name="Document-Configuration-Styles">
  <xsl:param name="ParamPath" />

  <xsl:if test="string-length($ParamPath) &gt; 0">
   <xsl:variable name="VarConfiguration" select="document($ParamPath)" />

   <xsl:copy-of select="$VarConfiguration/wwditaconfig:DitaConfiguration/wwditaconfig:Styles/wwditaconfig:Style" />
  </xsl:if>
 </xsl:template>


 <xsl:template name="Document-Configuration-Types">
  <xsl:param name="ParamPath" />

  <xsl:if test="string-length($ParamPath) &gt; 0">
   <xsl:variable name="VarConfiguration" select="document($ParamPath)" />

   <xsl:copy-of select="$VarConfiguration/wwditaconfig:DitaConfiguration/wwditaconfig:Types/wwditaconfig:Type" />
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
