<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-XmlToolAdapter-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                              xmlns:wwxta="urn:WebWorks-XmlToolAdapter-Schema"
                              xmlns:wwenv="urn:WebWorks-XSLT-Extension-Environment"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwstyles="urn:WebWorks-Styles-Schema"
                              xmlns:wwadapterconfig="urn:WebWorks-Adapter-Configuration-Extension"
                              exclude-result-prefixes="xsl msxsl xsd wwxta wwenv wwexsldoc wwfilesystem wwstyles wwadapterconfig"
>
 <xsl:param name="ParameterFileListPath" />
 <xsl:param name="ParameterXmlParamsPath" />
 <xsl:param name="ParameterResultPath" />


 <xsl:include href="wwxmladapter:scripts/dita/xsl/batch-files.xsl" />


 <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />


 <xsl:key name="wwstyles-styles-by-name-type" match="wwstyles:Style" use="concat(@name, ':', @type)" />


 <xsl:template match="/">
  <!-- Load file list -->
  <!--                -->
  <xsl:variable name="VarFileListXml" select="wwexsldoc:LoadXMLWithoutResolver($ParameterFileListPath)" />

  <!-- Temporary directory path -->
  <!--                          -->
  <xsl:variable name="VarTempDirPath" select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($ParameterResultPath), 'doccomps')" />

  <!-- Collect styles -->
  <!--                -->
  <xsl:variable name="VarStylesAsXML">
   <wwstyles:Styles>

    <!-- Iterate file list -->
    <!--                   -->
    <xsl:variable name="VarFileList" select="$VarFileListXml/wwxta:XmlToolAdapter/wwxta:File" />
    <xsl:for-each select="$VarFileList">
     <xsl:variable name="VarFileEntry" select="." />

     <xsl:call-template name="Process-File">
      <xsl:with-param name="ParamTempDirPath" select="$VarTempDirPath" />
      <xsl:with-param name="ParamPath" select="$VarFileEntry/@path" />
     </xsl:call-template>
    </xsl:for-each>

   </wwstyles:Styles>
  </xsl:variable>
  <xsl:variable name="VarStyles" select="msxsl:node-set($VarStylesAsXML)" />

  <!-- Determine unique styles -->
  <!--                         -->
  <xsl:variable name="VarUniqueStylesAsXML">
   <wwstyles:Styles>

    <xsl:for-each select="$VarStyles//wwstyles:Style">
     <xsl:variable name="VarStyle" select="." />

     <!-- Preserve first unique style name/type -->
     <!--                                       -->
     <xsl:variable name="VarStylesWithNameType" select="key('wwstyles-styles-by-name-type', concat($VarStyle/@name, ':', $VarStyle/@type))" />
     <xsl:if test="count($VarStyle | $VarStylesWithNameType[1]) = 1">
      <xsl:copy-of select="$VarStyle" />
     </xsl:if>
    </xsl:for-each>

   </wwstyles:Styles>
  </xsl:variable>
  <xsl:variable name="VarUniqueStyles" select="msxsl:node-set($VarUniqueStylesAsXML)" />

  <!-- Report styles -->
  <!--               -->
  <xsl:variable name="VarResultAsXML">
   <xsl:call-template name="Document-Components">
    <xsl:with-param name="ParamStyles" select="$VarUniqueStyles" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
  <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $ParameterResultPath, 'utf-8', 'xml', '1.0', 'yes')" />
 </xsl:template>


 <xsl:template name="Process-File">
  <xsl:param name="ParamTempDirPath" />
  <xsl:param name="ParamPath" />

  <!-- Script Path -->
  <!--             -->
  <xsl:variable name="VarScriptPath" select="concat(wwfilesystem:GetTempFileName(), '.bat')" />

  <!-- Arguments -->
  <!--           -->
  <xsl:variable name="VarDitaMapWIFPath" select="wwfilesystem:Combine($ParamTempDirPath, concat(wwfilesystem:GetFileName($ParamPath), 'ditamapwif'))" />

  <!-- Create build script -->
  <!--                     -->
  <xsl:call-template name="Write_DITA_Batch_File">
   <xsl:with-param name="ParamBatchFilePath" select="$VarScriptPath" />
   <xsl:with-param name="ParamAntTarget" select="'webworks.ditamapwif'" />
   <xsl:with-param name="ParamInput" select="$ParamPath" />
   <xsl:with-param name="ParamOutput" select="$VarDitaMapWIFPath" />
  </xsl:call-template>

  <!-- Execute DITA command -->
  <!--                      -->
  <xsl:variable name="VarDitaMapWIFReturnCode">
   <xsl:call-template name="Execute_Batch_File">
    <xsl:with-param name="ParamBatchFilePath" select="$VarScriptPath" />
    <xsl:with-param name="ParamCheckForEOFExceptions" select="wwadapterconfig:GetValue('dita-use-strict-topic-processing', 'false') = 'true'" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Continue? -->
  <!--           -->
  <xsl:if test="number($VarDitaMapWIFReturnCode) = 0">
   <!-- Arguments -->
   <!--           -->
   <xsl:variable name="VarStylesPath" select="wwfilesystem:Combine($ParamTempDirPath, concat(wwfilesystem:GetFileName($ParamPath), '.styles'))" />

   <!-- Create build script -->
   <!--                     -->
   <xsl:call-template name="Write_DITA_Batch_File">
    <xsl:with-param name="ParamBatchFilePath" select="$VarScriptPath" />
    <xsl:with-param name="ParamAntTarget" select="'webworks.document.styles'" />
    <xsl:with-param name="ParamInput" select="$VarDitaMapWIFPath" />
    <xsl:with-param name="ParamOutput" select="$VarStylesPath" />
   </xsl:call-template>

   <!-- Execute DITA command -->
   <!--                      -->
   <xsl:variable name="VarDitaStylesReturnCode">
    <xsl:call-template name="Execute_Batch_File">
     <xsl:with-param name="ParamBatchFilePath" select="$VarScriptPath" />
     <xsl:with-param name="ParamCheckForEOFExceptions" select="wwadapterconfig:GetValue('dita-use-strict-topic-processing', 'false') = 'true'" />
    </xsl:call-template>
   </xsl:variable>

   <!-- Continue? -->
   <!--           -->
   <xsl:if test="number($VarDitaStylesReturnCode) = 0">
    <!-- Extract styles -->
    <!--                -->
    <xsl:variable name="VarStyles" select="wwexsldoc:LoadXMLWithoutResolver($VarStylesPath)" />
    <xsl:copy-of select="$VarStyles//wwstyles:Style" />
   </xsl:if>
  </xsl:if>

  <!-- Clean up -->
  <!--          -->
  <xsl:variable name="VarDeleteScript" select="wwfilesystem:DeleteFile($VarScriptPath)" />
  <xsl:variable name="VarDeleteDirectory" select="wwfilesystem:DeleteDirectory($ParamTempDirPath)" />
 </xsl:template>


 <xsl:template name="Document-Components">
  <xsl:param name="ParamStyles" />

  <wwxta:XmlToolAdapter>
   <!-- Paragraph Styles -->
   <!--                  -->
   <wwxta:mParagraphStyles>
    <xsl:call-template name="Document-Styles">
     <xsl:with-param name="ParamStyles" select="$ParamStyles//wwstyles:Style[@type = 'Paragraph']" />
    </xsl:call-template>
   </wwxta:mParagraphStyles>

   <!-- Character Styles -->
   <!--                  -->
   <wwxta:mCharacterStyles>
    <xsl:call-template name="Document-Styles">
     <xsl:with-param name="ParamStyles" select="$ParamStyles//wwstyles:Style[@type = 'Character']" />
    </xsl:call-template>
   </wwxta:mCharacterStyles>

   <!-- Table Styles -->
   <!--              -->
   <wwxta:mTableStyles>
    <xsl:call-template name="Document-Styles">
     <xsl:with-param name="ParamStyles" select="$ParamStyles//wwstyles:Style[@type = 'Table']" />
    </xsl:call-template>
   </wwxta:mTableStyles>

   <!-- Graphic Styles -->
   <!--                -->
   <wwxta:mGraphicStyles>
    <xsl:call-template name="Document-Styles">
     <xsl:with-param name="ParamStyles" select="$ParamStyles//wwstyles:Style[@type = 'Graphic']" />
    </xsl:call-template>
   </wwxta:mGraphicStyles>

   <!-- Page Styles -->
   <!--             -->
   <wwxta:mPageStyles>
    <xsl:call-template name="Document-Styles">
     <xsl:with-param name="ParamStyles" select="$ParamStyles//wwstyles:Style[@type = 'Page']" />
    </xsl:call-template>
   </wwxta:mPageStyles>

   <!-- Marker Styles -->
   <!--               -->
   <wwxta:mMarkerTypes>
    <xsl:call-template name="Document-Styles">
     <xsl:with-param name="ParamStyles" select="$ParamStyles//wwstyles:Style[@type = 'Marker']" />
    </xsl:call-template>
   </wwxta:mMarkerTypes>

   <!-- Conditions -->
   <!--            -->
   <wwxta:mConditions />

   <!-- Variables -->
   <!--           -->
   <wwxta:mVariables />

   <!-- XREFs -->
   <!--            -->
   <wwxta:mXRefs />
  </wwxta:XmlToolAdapter>
 </xsl:template>


 <xsl:template name="Document-Styles">
  <xsl:param name="ParamStyles" />

  <xsl:for-each select="$ParamStyles">
   <xsl:variable name="VarStyle" select="." />

   <wwxta:DictionaryEntry>
    <wwxta:Key type="xsd:string"><xsl:value-of select="$VarStyle/@name" /></wwxta:Key>
    <wwxta:Value type="xsd:string"></wwxta:Value>
   </wwxta:DictionaryEntry>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
