<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ww="urn:WebWorks-Publish-Project"
    xmlns="urn:WebWorks-Publish-Project"
    xmlns:html="http://www.w3.org/1999/xhtml"
    >

<xsl:param name="filename" />
<xsl:param name="current-date" />
<xsl:param name="comment" />


<xsl:template match="/">
  <html >
  <html:link rel="StyleSheet" href="webworks-project.css" type="text/css" media="all" />
  <html:body>

    <html:h1>Project: <xsl:value-of select="$filename" /> </html:h1>
    <html:p class="asOfDate">as of <xsl:value-of select="$current-date" /> </html:p>
    <html:p class="wwVersion">WebWorks Project Version: <xsl:value-of select="ww:Project/@Version"/> </html:p>

    <xsl:if test="string($comment) != '' ">
        <html:div class="comment">
        <html:p class="comment">Comment: <xsl:value-of select="$comment" /></html:p>
        </html:div>
    </xsl:if>

    <xsl:apply-templates/>
  </html:body>
  </html>
</xsl:template>


<xsl:template match="ww:Origin">
  <html:h2>Origin</html:h2>

  <html:div class="rule-type">
  <html:table border="0" >
  <html:tr>
  <html:td><xsl:value-of select="."/></html:td>
  </html:tr>
  </html:table>
  </html:div>

</xsl:template>



<xsl:template match="ww:Formats/ww:Format">
  <html:h2>Formats</html:h2>

  <html:div class="rule-type">
  <html:table border="0" >
  <html:tr><html:td>TargetName:&#160;&#160;</html:td><html:td><xsl:value-of select="@TargetName"/></html:td></html:tr>
  <html:tr><html:td>Name:&#160;&#160;</html:td><html:td><xsl:value-of select="@Name"/></html:td></html:tr>
  <html:tr><html:td>Type:&#160;&#160;</html:td><html:td><xsl:value-of select="@Type"/></html:td></html:tr>
  </html:table>
  </html:div>

</xsl:template>




<xsl:template match="ww:GlobalConfiguration">
  <html:h2>Rules</html:h2>
     <xsl:apply-templates/>
</xsl:template>


<!-- ****** -->
<xsl:template match="ww:Rules">
  <html:h3><xsl:value-of select="@Type"/>s&#160;&#160;<html:span style="font-size:small;font-weight:normal"><html:em>Default is</html:em>&#160;&#160;<html:b><xsl:value-of select="@Default"/></html:b></html:span></html:h3>

  <html:div class="rule-type">
      <xsl:apply-templates/>
  </html:div>
</xsl:template>

<xsl:template match="ww:Rule">

    <html:table border="0" cellpadding="0" cellspacing="0" width="100%">
    <html:tr>
    <html:td align="left"><html:b><xsl:value-of select="@Key"/> </html:b></html:td>
    <html:td align="right">&#160;<xsl:if test="@ParentRule"><html:em>Parent rule is </html:em>&#160;&#160;<html:b><xsl:value-of select="@ParentRule"/>&#160;</html:b></xsl:if></html:td>
    </html:tr>
    </html:table>

    <html:div class="rule">
    <xsl:if test='ww:Options[.!=""]'>
    <html:table border="0" width="100%">
      <html:tr bgcolor="#ddffdd">
        <html:th width="220pt">Option</html:th>
        <html:th width="">Value</html:th>
        <html:th width="80pt">Source</html:th>
      </html:tr>
      <xsl:apply-templates  select="ww:Options"/>
    </html:table>
    </xsl:if>


    <xsl:if test='ww:Properties[.!=""]'>
    <html:table border="0" width="100%">
      <html:tr bgcolor="#dddddd">
        <html:th width="220pt">Property</html:th>
        <html:th width="">Value</html:th>
        <html:th width="80pt">Source</html:th>
      </html:tr>
      <xsl:apply-templates  select="ww:Properties"/>
    </html:table>
    </xsl:if>
    </html:div>

</xsl:template>

<xsl:template match="ww:Option">
  <html:tr>
    <html:td><xsl:value-of select="@Name"/></html:td>
    <html:td><xsl:value-of select="@Value"/></html:td>
    <html:td><xsl:value-of select="@Source"/></html:td>
  </html:tr>
</xsl:template>

<xsl:template match="ww:Property">
  <html:tr>
    <html:td><xsl:value-of select="@Name"/></html:td>
    <html:td><xsl:value-of select="@Value"/></html:td>
    <html:td><xsl:value-of select="@Source"/></html:td>
  </html:tr>
</xsl:template>

<!-- **** FormatConditions **** -->
<xsl:template match="ww:FormatConfigurations">
  <html:h2>Format Configurations</html:h2>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="ww:Conditions">
  <html:h4>Conditions</html:h4>
  <html:div class="rule">
  <html:table border="0" width="100%">
    <html:tr bgcolor="#dddddd">
      <html:th width="220pt">Condition</html:th>
      <html:th width="">Value</html:th>
      <html:th width="">Passthrough</html:th>
      <html:th width="80pt">UseDocumentValue</html:th>
    </html:tr>
    <xsl:apply-templates />
  </html:table>
  </html:div>
</xsl:template>

<xsl:template match="ww:Condition">
  <html:tr>
    <html:td><xsl:value-of select="@Name"/></html:td>
    <html:td><xsl:value-of select="@Value"/></html:td>
    <html:td><xsl:value-of select="@Passthrough"/></html:td>
    <html:td><xsl:value-of select="@UseDocumentValue"/></html:td>
  </html:tr>
</xsl:template>


<xsl:template match="ww:Variables">
  <html:h4>Variables</html:h4>
  <html:div class="rule">
  <html:table border="0" width="100%">
    <html:tr bgcolor="#dddddd">
      <html:th width="220pt">Variable</html:th>
      <html:th width="">Value</html:th>
      <html:th width="80pt">UseDocumentValue</html:th>
    </html:tr>
    <xsl:apply-templates />
  </html:table>
  </html:div>
</xsl:template>

<xsl:template match="ww:Variable">
  <html:tr>
    <html:td><xsl:value-of select="@Name"/></html:td>
    <html:td><xsl:value-of select="@Value"/></html:td>
    <html:td><xsl:value-of select="@UseDocumentValue"/></html:td>
  </html:tr>
</xsl:template>

<xsl:template match="ww:XRefFormatSet">
    <xsl:apply-templates />
</xsl:template>


<xsl:template match="ww:XRefFormats">
  <html:h4><xsl:value-of select="@Adapter"/> adapter</html:h4>
  <html:div class="rule">
  <html:table border="0" width="100%">
    <html:tr bgcolor="#dddddd">
      <html:th width="220pt">Format</html:th>
      <html:th width="">Value</html:th>
    </html:tr>
    <xsl:apply-templates />
  </html:table>
  </html:div>
</xsl:template>

<xsl:template match="ww:XRefFormat">
  <html:tr>
    <html:td><xsl:value-of select="@Key"/></html:td>
    <html:td><xsl:value-of select="@Value"/></html:td>
  </html:tr>
</xsl:template>

<xsl:template match="ww:FormatSettings">
  <html:h4>Format Settings</html:h4>
  <html:div class="rule">
  <html:table border="0" width="100%">
    <html:tr bgcolor="#dddddd">
      <html:th width="220pt">Setting</html:th>
      <html:th width="">Value</html:th>
    </html:tr>
    <xsl:apply-templates />
  </html:table>
  </html:div>
</xsl:template>

<xsl:template match="ww:FormatSetting">
  <html:tr>
    <html:td><xsl:value-of select="@Name"/></html:td>
    <html:td><xsl:value-of select="@Value"/></html:td>
  </html:tr>
</xsl:template>


<xsl:template match="ww:MergeSettings">
    <!-- We don't use this, I think ... -->
</xsl:template>


<!-- **** ProjectSettings **** -->
<xsl:template match="ww:ProjectSettings">
    <!-- We don't use this, I think ... -->
    <!--
    <h2>ProjectSettings</h2>
    -->
</xsl:template>



</xsl:stylesheet>