<?php
// we will save values in the session vars to make sure refreshes don't repost.
session_start();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xmlns:wwpage="urn:WebWorks-Page-Template-Schema" xml:lang="en" wwpage:attribute-xml-lang="locale" lang="en" wwpage:attribute-lang="locale">
  <head>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8" wwpage:attribute-content="content-type" />
    <meta http-equiv="Content-Style-Type" content="text/css" />
    <!-- MOTW-DISABLED saved from url=(0014)about:internet -->

    <title wwpage:content="title">Title</title>

    <link wwpage:condition="catalog-css" rel="StyleSheet" href="css/catalog.css" wwpage:attribute-href="catalog-css" type="text/css" media="all" />
    <link rel="StyleSheet" href="css/webworks.css" wwpage:attribute-href="copy-relative-to-output" type="text/css" media="all" />
    <link wwpage:condition="document-css" rel="StyleSheet" href="css/document.css" wwpage:attribute-href="document-css" type="text/css" media="all" />

    <script type="text/javascript" language="JavaScript1.2" src="scripts/expand.js" wwpage:attribute-src="copy-relative-to-output"></script>
    <script type="text/javascript" language="JavaScript1.2" src="scripts/seealso.js" wwpage:attribute-src="copy-relative-to-output"></script>

    <script type="text/javascript" language="JavaScript1.2" wwpage:content="webworks-root">
      <!--
        var  WebWorksRootPath = "";
      // -->
    </script>

    <script type="text/javascript" language="JavaScript1.2">
      <!--
        var  WebWorksSeeAlso = "xxx";
      // -->
    </script>
  </head>

  <body style="text-align: left;" wwpage:attribute-style="body-style">
    <table wwpage:condition="company-info-top" align="left" wwpage:attribute-align="company-info-top-alignment">
      <tr wwpage:condition="company-logo-src-exists">
        <td style="text-align: left;">
          <a wwpage:condition="company-link-exists" href="http://www.webworks.com" target="_blank" wwpage:attribute-href="company-link">
            <img src="images/logo.gif" border="0" wwpage:attribute-src="company-logo-src" />
          </a>

          <img wwpage:condition="company-link-not-exists" src="images/logo.gif" wwpage:attribute-src="company-logo-src" />
        </td>
      </tr>

      <tr wwpage:condition="company-name-exists">
        <td style="text-align: left; font-size: 16px; font-weight:bold">
          <a wwpage:condition="company-link-exists" href="http://www.webworks.com" target="_blank" wwpage:attribute-href="company-link" wwpage:content="company-name">
            Company Name
          </a>
          <a wwpage:condition="company-link-not-exists" wwpage:replace="company-name">
            Company Name
          </a>
        </td>
      </tr>

      <tr wwpage:condition="company-phone-exists">
        <td style="text-align: left; font-size: 12px" wwpage:content="company-phone">
          Phone: 512-555-1234
        </td>
      </tr>

      <tr wwpage:condition="company-fax-exists">
        <td style="text-align: left; font-size: 12px" wwpage:content="company-fax">
          Fax: 512-555-5678
        </td>
      </tr>

      <tr wwpage:condition="company-email-exists">
       <td style="text-align: left; font-size: 12px">
          <a href="mailto:sales@webworks.com" wwpage:attribute-href="company-email-href" wwpage:content="company-email">
            sales@webworks.com
          </a>
        </td>
      </tr>
    </table>

    <div wwpage:condition="navigation-top" style="text-align: right;" wwpage:attribute-style="navigation-top-style">
      <table cellspacing="0">
        <tr>
          <td wwpage:condition="navigation-toc-current">
            <img src="images/tocx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Table of Contents" wwpage:attribute-alt="navigation-toc-title" border="0"/>
          </td>
          <td wwpage:condition="navigation-toc-not-current">
            <a href="toc" wwpage:attribute-href="navigation-toc-link">
              <img src="images/toc.gif" wwpage:attribute-src="copy-relative-to-output" alt="Table of Contents" wwpage:attribute-alt="navigation-toc-title" border="0" />
            </a>
          </td>
          <td wwpage:condition="navigation-previous-exists">
            <a href="previous" wwpage:attribute-href="navigation-previous-link">
              <img src="images/prev.gif" wwpage:attribute-src="copy-relative-to-output" alt="Previous" wwpage:attribute-alt="navigation-previous-title" border="0" />
            </a>
          </td>
          <td wwpage:condition="navigation-previous-not-exists">
            <img src="images/prevx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Previous" wwpage:attribute-alt="navigation-previous-title" border="0" />
          </td>
          <td wwpage:condition="navigation-next-exists">
            <a href="next" wwpage:attribute-href="navigation-next-link">
              <img src="images/next.gif" wwpage:attribute-src="copy-relative-to-output" alt="Next" wwpage:attribute-alt="navigation-next-title" border="0" />
            </a>
          </td>
          <td wwpage:condition="navigation-next-not-exists">
            <img src="images/nextx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Next" wwpage:attribute-alt="navigation-next-title" border="0" />
          </td>
          <td wwpage:condition="navigation-index-current">
            <img src="images/indexx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Index" wwpage:attribute-alt="navigation-index-title" border="0"/>
          </td>
          <td wwpage:condition="navigation-index-not-current">
            <a href="index" wwpage:attribute-href="navigation-index-link">
              <img src="images/index.gif" wwpage:attribute-src="copy-relative-to-output" alt="Index" wwpage:attribute-alt="navigation-index-title" border="0" />
            </a>
          </td>
        </tr>
      </table>
    </div>

    <br wwpage:condition="company-info-top" clear="all" />

    <br wwpage:condition="breadcrumbs-top" />
    <div wwpage:condition="breadcrumbs-top" wwpage:content="breadcrumbs" class="WebWorks_Breadcrumbs" style="text-align: left;" wwpage:attribute-style="breadcrumbs-top-style">
      Breadcrumbs go here
    </div>

    <hr wwpage:condition="header-exists" align="left" />

    <blockquote wwpage:condition="header-footer-exists" wwpage:content="content">
      Page content with header/footer.
    </blockquote>

    <div wwpage:condition="header-footer-not-exists" wwpage:replace="content">
      Page content with no header/footer.
    </div>

    <hr wwpage:condition="footer-exists" align="left" />

    <div wwpage:condition="breadcrumbs-bottom" wwpage:content="breadcrumbs" class="WebWorks_Breadcrumbs" style="text-align: left;" wwpage:attribute-style="breadcrumbs-bottom-style">
      Breadcrumbs go here
    </div>
    <br wwpage:condition="breadcrumbs-bottom" />

    <div wwpage:condition="navigation-bottom" style="text-align: left;" wwpage:attribute-style="navigation-bottom-style">
      <table cellspacing="0">
        <tr>
          <td wwpage:condition="navigation-toc-current">
            <img src="images/tocx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Table of Contents" wwpage:attribute-alt="navigation-toc-title" border="0"/>
          </td>
          <td wwpage:condition="navigation-toc-not-current">
            <a href="toc" wwpage:attribute-href="navigation-toc-link">
              <img src="images/toc.gif" wwpage:attribute-src="copy-relative-to-output" alt="Table of Contents" wwpage:attribute-alt="navigation-toc-title" border="0" />
            </a>
          </td>
          <td wwpage:condition="navigation-previous-exists">
            <a href="previous" wwpage:attribute-href="navigation-previous-link">
              <img src="images/prev.gif" wwpage:attribute-src="copy-relative-to-output" alt="Previous" wwpage:attribute-alt="navigation-previous-title" border="0" />
            </a>
          </td>
          <td wwpage:condition="navigation-previous-not-exists">
            <img src="images/prevx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Previous" wwpage:attribute-alt="navigation-previous-title" border="0" />
          </td>
          <td wwpage:condition="navigation-next-exists">
            <a href="next" wwpage:attribute-href="navigation-next-link">
              <img src="images/next.gif" wwpage:attribute-src="copy-relative-to-output" alt="Next" wwpage:attribute-alt="navigation-next-title" border="0" />
            </a>
          </td>
          <td wwpage:condition="navigation-next-not-exists">
            <img src="images/nextx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Next" wwpage:attribute-alt="navigation-next-title" border="0" />
          </td>
          <td wwpage:condition="navigation-index-current">
            <img src="images/indexx.gif" wwpage:attribute-src="copy-relative-to-output" alt="Index" wwpage:attribute-alt="navigation-index-title" border="0"/>
          </td>
          <td wwpage:condition="navigation-index-not-current">
            <a href="index" wwpage:attribute-href="navigation-index-link">
              <img src="images/index.gif" wwpage:attribute-src="copy-relative-to-output" alt="Index" wwpage:attribute-alt="navigation-index-title" border="0" />
            </a>
          </td>
        </tr>
      </table>
    </div>

    <table wwpage:condition="company-info-bottom" align="right" wwpage:attribute-align="company-info-bottom-alignment">
      <tr wwpage:condition="company-logo-src-exists">
        <td style="text-align: left;">
          <a wwpage:condition="company-link-exists" href="http://www.webworks.com" target="_blank" wwpage:attribute-href="company-link">
            <img src="images/logo.gif" border="0" wwpage:attribute-src="company-logo-src" />
          </a>

          <img wwpage:condition="company-link-not-exists" src="images/logo.gif" wwpage:attribute-src="company-logo-src" />
        </td>
      </tr>

      <tr wwpage:condition="company-name-exists">
        <td style="text-align: left; font-size: 16px ; font-weight: bold">
          <a wwpage:condition="company-link-exists" href="http://www.webworks.com" target="_blank" wwpage:attribute-href="company-link" wwpage:content="company-name">
            Company Name
          </a>
          <a wwpage:condition="company-link-not-exists" wwpage:replace="company-name">
            Company Name
          </a>
        </td>
      </tr>

      <tr wwpage:condition="company-phone-exists">
        <td style="text-align: left; font-size: 12px" wwpage:content="company-phone">
          Phone: 512-555-1234
        </td>
      </tr>

      <tr wwpage:condition="company-fax-exists">
        <td style="text-align: left; font-size: 12px" wwpage:content="company-fax">
          Fax: 512-555-5678
        </td>
      </tr>

      <tr wwpage:condition="company-email-exists">
       <td style="text-align: left; font-size: 12px">
          <a href="mailto:sales@webworks.com" wwpage:attribute-href="company-email-href" wwpage:content="company-email">
            sales@webworks.com
          </a>
        </td>
      </tr>
    </table>

    <hr />
    <!-- Comment Section -->
<?php
      // Helpful Functions

     /* 
      * Simple function to display input forms for comments. 
      * 
      * We are just printing/echo'ing some forms. You could change them here.
      */
     function display_forms() {
         echo "<form action='" . $_SERVER['PHP_SELF'] . "' method='post'>\n";
         echo "  <fieldset name='comment-forms'>\n";
         echo "    <legend>Add a Comment</legend>\n";
         echo "    <label for='comment-title'>Title:</label>\n";
         echo "    <input type='text' id='comment-title' name='title' maxlength='255' value='" . $_POST['title'] . "'/><br />\n";
         echo "    <label for='comment-content'>Comment:</label><br />\n";
         echo "    <textarea name='content' id='comment-content' rows='10' cols='40'>" . $_POST['content'] . "</textarea><br />\n";
         echo "    <input type='submit' name='submit' value='Add Comment' />\n";
         echo "  </fieldset>\n";
         echo "</form>\n";
     }

     /*
      * This displays the comments by reading the comments file for the
      * the specific file and prints it out.
      */
     function display_comments() {
         $comment_file = rtrim(__FILE__, '.php') . '.comments.txt';
         if (is_file($comment_file)) {
                 echo file_get_contents($comment_file);
         }
     }


     /*
      * Adds a comment to the comment file. 
      * The comment file is a simple text file in the same directory as the file
      * 
      * So, if the filename is MyFrameDoc.1.4.html
      * In ePublisher we change the extension to .php -> MyFrameDoc.1.4.php
      * Which makes the comment file -> MyFrameDoc.1.4.comments.txt
      */
     function add_comment($title, $content) {

         // Check the session to see if this is a repost by the same user. 
	 // 
         if ($_SESSION['comment-title'] == $title && $_SESSION['comment-content'] == $content) {
             return "";
         }

         /*
	  * Create a quick bit of HTML to save in the comment file.
          * There should probably be some more checking here but for now it should be ok
	  * 
          * WARNING: Your sys-admin will say this is a security hole. Please listen to him/her 
          *          and try to improve things.
	  /*
         $new_comment_string = "<div class='comment-block>\n";
         $new_comment_string .= "  <h4>" . htmlentities($title) . "</h4>\n";
         // making new lines actual line breaks
         $new_comment_string .= "  <div class='comment-content'>" . nl2br(htmlentities($content)) . "</div>\n";
         $new_comment_string .= "</div>\n";

         // Comment filename is the same as the requested file except with an extension
         // of 'comments.txt'
         $comment_file = rtrim(__FILE__, '.php') . '.comments.txt';

         // open the comment file for writing only at the beginning, if it is not there create it.
         $comment_file_handle = fopen($comment_file, "a+");
         if (fwrite($comment_file_handle, $new_comment_string)) {
             fclose($comment_file_handle);
             $_SESSION['comment-title'] = $title;
             $_SESSION['comment-content'] = $content;
             return "Comment Added!";
         } else {
             fclose($comment_file_handle);
             return "Error writing comment file. Please contact myemail@somedomain.com.";
         }
     }


     /* 
      * This is the actual logic of the script.
      */
     if ($_POST['submit'] == "Add Comment") {
          if ($_POST['title'] != '' && $_POST['content'] != '') {
             echo add_comment($_POST['title'], $_POST['content']);
             display_forms();
          } else {
             echo "Please fill in the title and the content fields.";
             display_forms();
          }
      } else {
          display_forms();
      }
      display_comments();
    ?>
    <!-- end comment section -->
  </body>
</html>
