/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.wwhelp4;

import com.webworks.wwhelp4.ButtonBase;
import com.webworks.wwhelp4.ColorUtils;
import com.webworks.wwhelp4.GeneralUtils;
import com.webworks.wwhelp4.PropertyChangeSupport;
import com.webworks.wwhelp4.VetoableChangeSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;

public class DirectionButton
extends ButtonBase
implements Serializable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    public Boolean bIsNetscape = null;
    protected Color arrowColor = null;
    protected Color disabledArrowColor = null;
    protected int direction;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected int indent;
    protected int tempIndent;
    private SizeVeto sizeVeto = null;
    private IndntVeto indentVeto = null;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public DirectionButton() {
        this(0);
    }

    public DirectionButton(int n) {
        this.direction = n;
        this.left = 0;
        this.right = 0;
        this.bottom = 0;
        this.tempIndent = this.indent = 0;
        try {
            this.setArrowColor(SystemColor.controlText);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setDirection(int n) throws PropertyVetoException {
        if (this.direction != n) {
            Integer n2 = new Integer(this.direction);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("direction", n2, n3);
            this.direction = n;
            this.repaint();
            this.changes.firePropertyChange("direction", n2, n3);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setArrowIndent(int n) throws PropertyVetoException {
        if (this.isAdded) {
            if (this.indent != n) {
                Integer n2 = new Integer(this.indent);
                Integer n3 = new Integer(n);
                this.vetos.fireVetoableChange("arrowIndent", n2, n3);
                this.indent = n;
                this.tempIndent = n;
                this.shrinkTriangle(this.left, this.right, this.top, this.bottom);
                this.repaint();
                this.changes.firePropertyChange("arrowIndent", n2, n3);
            }
        } else {
            this.tempIndent = n;
        }
    }

    public void setArrowColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.arrowColor, color)) {
            Color color2 = this.arrowColor;
            this.vetos.fireVetoableChange("arrowColor", color2, color);
            this.arrowColor = color;
            try {
                this.disabledArrowColor = ColorUtils.fade(this.arrowColor, Color.lightGray, 0.5);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.repaint();
            this.changes.firePropertyChange("arrowColor", color2, color);
        }
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public int getArrowIndent() {
        return this.isAdded ? this.indent : this.tempIndent;
    }

    public void shrinkTriangle(int n, int n2, int n3, int n4) {
        if (this.isAdded) {
            Dimension dimension = this.getSize();
            int n5 = dimension.width - this.bevel - this.bevel - 2;
            int n6 = dimension.height - this.bevel - this.bevel - 2;
            if (n5 - (n + n2 + this.indent + this.indent) >= 3) {
                this.left = n;
                this.right = n2;
            } else {
                this.right = this.left = (n5 - this.indent - this.indent - 3) / 2;
            }
            if (n6 - (n3 + n4 + this.indent + this.indent) >= 3) {
                this.top = n3;
                this.bottom = n4;
            } else {
                this.bottom = this.top = (n6 - this.indent - this.indent - 3) / 2;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 7, dimension.height + 7);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 3, dimension.height + 3);
    }

    public synchronized void addNotify() {
        if (this.sizeVeto == null) {
            this.sizeVeto = new SizeVeto();
            this.addDirectionListener(this.sizeVeto);
        }
        if (this.indentVeto == null) {
            this.indentVeto = new IndntVeto();
            this.addArrowIndentListener(this.indentVeto);
        }
        super.addNotify();
    }

    public synchronized void removeNotify() {
        if (this.sizeVeto != null) {
            this.removeDirectionListener(this.sizeVeto);
            this.sizeVeto = null;
        }
        if (this.indentVeto != null) {
            this.removeArrowIndentListener(this.indentVeto);
            this.indentVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addDirectionListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("direction", propertyChangeListener);
    }

    public synchronized void removeDirectionListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("direction", propertyChangeListener);
    }

    public synchronized void addDirectionListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("direction", vetoableChangeListener);
    }

    public synchronized void removeDirectionListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("direction", vetoableChangeListener);
    }

    public synchronized void addArrowIndentListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("arrowIndent", propertyChangeListener);
    }

    public synchronized void removeArrowIndentListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("arrowIndent", propertyChangeListener);
    }

    public synchronized void addArrowIndentListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("arrowIndent", vetoableChangeListener);
    }

    public synchronized void removeArrowIndentListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("arrowIndent", vetoableChangeListener);
    }

    public boolean isNetscape() {
        if (this.bIsNetscape == null) {
            SecurityManager securityManager = System.getSecurityManager();
            this.bIsNetscape = securityManager.getClass().getName().equals("com.ms.security.StandardSecurityManager") ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.bIsNetscape;
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Graphics graphics = this.buttonImage.getGraphics();
        int n = this.size().width / 2;
        int n2 = this.size().height / 2;
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        switch (this.direction) {
            case 3: {
                graphics.drawLine(n - 4, n2 - 2, n + 4, n2 - 2);
                graphics.drawLine(n - 3, n2 - 1, n + 3, n2 - 1);
                graphics.drawLine(n - 2, n2, n + 2, n2);
                graphics.drawLine(n - 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n, n2 + 2, n, n2 + 2);
                break;
            }
            case 1: {
                graphics.drawLine(n - 2, n2 - 4, n - 2, n2 + 4);
                graphics.drawLine(n - 1, n2 - 3, n - 1, n2 + 3);
                graphics.drawLine(n, n2 - 2, n, n2 + 2);
                graphics.drawLine(n + 1, n2 - 1, n + 1, n2 + 1);
                graphics.drawLine(n + 2, n2, n + 2, n2);
                break;
            }
            case 0: {
                graphics.drawLine(--n + 2, n2 - 4, n + 2, n2 + 4);
                graphics.drawLine(n + 1, n2 - 3, n + 1, n2 + 3);
                graphics.drawLine(n, n2 - 2, n, n2 + 2);
                graphics.drawLine(n - 1, n2 - 1, n - 1, n2 + 1);
                graphics.drawLine(n - 2, n2, n - 2, n2);
                break;
            }
        }
    }

    protected boolean isValidBevelSize(int n) {
        Dimension dimension = this.size();
        int n2 = n * 2 + 4;
        return n >= 0 && dimension.width >= n2 && dimension.height >= n2;
    }

    protected boolean isValidDirection(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidArrowIndent(int n) {
        Dimension dimension = this.size();
        int n2 = n * 2 + (this.bevel + 1) * 2 + 4;
        return n >= 0 && dimension.width >= n2 && dimension.height >= n2;
    }

    protected void verifyContstrainedPropertyValues() {
        super.verifyContstrainedPropertyValues();
        try {
            this.setArrowIndent(this.tempIndent);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    class SizeVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!DirectionButton.this.isValidDirection(n)) {
                throw new PropertyVetoException("InvalidDirection" + n, propertyChangeEvent);
            }
        }

        SizeVeto() {
        }
    }

    class IndntVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!DirectionButton.this.isValidArrowIndent(n)) {
                throw new PropertyVetoException("InvalidArrowIndent" + n, propertyChangeEvent);
            }
        }

        IndntVeto() {
        }
    }
}

