/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.wwhelp4;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.webworks.wwhelp4.InvalidTreeNodeException;
import com.webworks.wwhelp4.OS;
import com.webworks.wwhelp4.TreeNode;
import com.webworks.wwhelp4.WWHelp;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class TreeView
extends Panel
implements ItemSelectable,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener,
AdjustmentListener {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public static final int NODE_TOGGLED = 2001;
    public static final int NODE_EXPANDED = 2002;
    public static final int NODE_COLLAPSED = 2003;
    public static final int SEL_CHANGED = 1006;
    public Color bkColor;
    public Font f = null;
    int sbVPosition = 0;
    int sbVWidth;
    int sbHPosition = 0;
    int sbHHeight = 0;
    long sbVTimer = -1L;
    int cellSize = 16;
    int clickSize = 8;
    int imageInset = 3;
    int textInset = 6;
    int textBaseLine = 3;
    int doubleClickResolution = 333;
    protected TreeNode rootNode;
    protected TreeNode selectedNode;
    protected TreeNode topVisibleNode;
    protected Scrollbar verticalScrollBar;
    protected boolean sbVShow = false;
    protected int count = 0;
    protected int viewCount = 0;
    protected Scrollbar horizontalScrollBar;
    protected int sbHSize;
    protected int newWidth = 0;
    protected boolean sbHShow = false;
    protected boolean needResetVector;
    protected int sbHLineIncrement = 4;
    protected int viewHeight = 300;
    protected int viewWidth = 300;
    protected int viewWidest = 0;
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected Vector v;
    protected Vector e;
    protected transient boolean redrawTriggered = false;
    transient boolean hasFocus = false;
    protected transient FontMetrics fm;
    transient long timeMouseDown;
    protected transient Image im1;
    protected transient Graphics g1 = null;
    protected static boolean isSun1_1;
    Rectangle popupRect = null;
    Vector hoverStrings = new Vector();

    static {
        String string = System.getProperty("java.vendor");
        String string2 = System.getProperty("java.version");
        isSun1_1 = !(!string.startsWith("Sun Microsystems Inc.") && !string.startsWith("Apple") && !string.startsWith("Symantec Corporation") && !string.startsWith("Microsoft Corp.") && !string.startsWith("Netscape") || !string2.startsWith("11") && !string2.startsWith("1.1"));
    }

    public TreeView() {
        super.setLayout(null);
        this.verticalScrollBar = new Scrollbar(1);
        this.verticalScrollBar.hide();
        this.add(this.verticalScrollBar);
        this.horizontalScrollBar = new Scrollbar(0);
        this.horizontalScrollBar.hide();
        this.add(this.horizontalScrollBar);
        this.needResetVector = true;
        if (WWHelp.getSecurityType().equals("ms_ie")) {
            try {
                this.f = WWHelp.getFontX(WWHelp.fontName, 0, WWHelp.fontSize);
            }
            catch (Exception exception) {}
        } else {
            this.f = new Font(WWHelp.fontName, 0, WWHelp.fontSize);
        }
    }

    public TreeView(TreeNode treeNode) {
        this();
        PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        this.selectedNode = this.rootNode = treeNode;
        this.count = 1;
    }

    public void setTreeStructure(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.clear();
            return;
        }
        this.selectedNode = null;
        this.rootNode = null;
        try {
            this.parseTreeStructure(stringArray);
        }
        catch (InvalidTreeNodeException invalidTreeNodeException) {
            System.err.println(invalidTreeNodeException);
        }
        this.triggerRedraw();
        this.invalidate();
    }

    public String[] getTreeStructure() {
        if (this.rootNode == null) {
            return null;
        }
        Vector vector = new Vector(this.count);
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, false, false, vector);
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode = (TreeNode)vector.elementAt(n2);
            String string = "";
            int n3 = 0;
            while (n3 < treeNode.depth) {
                string = String.valueOf(string) + ' ';
                ++n3;
            }
            stringArray[n2] = string = String.valueOf(string) + treeNode.text;
            ++n2;
        }
        return stringArray;
    }

    public Color getFgHilite() {
        return SystemColor.textHighlightText;
    }

    public Color getBgHilite() {
        return SystemColor.textHighlight;
    }

    public Object[] getSelectedObjects() {
        if (this.selectedNode == null) {
            return null;
        }
        Object[] objectArray = new TreeNode[]{this.selectedNode};
        return objectArray;
    }

    public void deleteRootAndPromoteChildren() {
        this.rootNode = this.rootNode.child;
    }

    public void insert(TreeNode treeNode, TreeNode treeNode2, int n) {
        if (treeNode == null || treeNode2 == null) {
            return;
        }
        if (!this.exists(treeNode2)) {
            return;
        }
        switch (n) {
            case 0: {
                this.addChild(treeNode, treeNode2);
                break;
            }
            case 1: {
                this.addSibling(treeNode, treeNode2, false);
                break;
            }
            case 2: {
                this.addSibling(treeNode, treeNode2, true);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void clear() {
        this.selectedNode = null;
        this.rootNode = null;
        this.count = 0;
        this.v = new Vector();
        this.e = new Vector();
        this.triggerRedraw();
        this.invalidate();
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public int getCount() {
        return this.count;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    boolean viewable(TreeNode treeNode) {
        int n = 0;
        while (n < this.viewCount) {
            if (treeNode == this.v.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean viewable(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < this.viewCount) {
            TreeNode treeNode = (TreeNode)this.v.elementAt(n);
            if (treeNode.text != null && string.equals(treeNode.text)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean exists(TreeNode treeNode) {
        this.recount();
        int n = 0;
        while (n < this.count) {
            if (treeNode == this.e.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean exists(String string) {
        this.recount();
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < this.count) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(n);
            if (treeNode.text != null && string.equals(treeNode.text)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public TreeNode getNode(String string) {
        this.recount();
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.count) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(n);
            if (treeNode.text != null && string.equals(treeNode.text)) {
                return treeNode;
            }
            ++n;
        }
        return null;
    }

    public void append(TreeNode treeNode) {
        if (this.rootNode == null) {
            this.selectedNode = this.rootNode = treeNode;
            this.count = 1;
            this.redrawTriggered = true;
        } else {
            this.recount();
            if (this.e.contains(treeNode)) {
                System.err.println(new InvalidTreeNodeException("append: NodeAlreadyExists"));
            } else {
                this.addSibling(treeNode, this.rootNode, true);
            }
        }
    }

    public void addChild(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode2.child == null) {
            treeNode2.child = treeNode;
            treeNode.parent = treeNode2;
            ++this.count;
            this.redrawTriggered = true;
        } else {
            this.addSibling(treeNode, treeNode2.child, true);
        }
        ++treeNode2.numberOfChildren;
    }

    public void addSibling(TreeNode treeNode, TreeNode treeNode2) {
        this.addSibling(treeNode, treeNode2, true);
    }

    public void addSibling(TreeNode treeNode, TreeNode treeNode2, boolean bl) {
        if (bl) {
            TreeNode treeNode3 = treeNode2;
            while (treeNode3.sibling != null) {
                treeNode3 = treeNode3.sibling;
            }
            treeNode3.sibling = treeNode;
        } else {
            treeNode.sibling = treeNode2.sibling;
            treeNode2.sibling = treeNode;
        }
        treeNode.parent = treeNode2.parent;
        ++this.count;
        this.redrawTriggered = true;
    }

    public TreeNode remove(String string) {
        this.recount();
        int n = 0;
        while (n < this.count) {
            TreeNode treeNode = (TreeNode)this.e.elementAt(n);
            if (treeNode.text != null && string.equals(treeNode.text)) {
                this.remove(treeNode);
                this.redrawTriggered = true;
                return treeNode;
            }
            ++n;
        }
        return null;
    }

    public void removeSelected() {
        if (this.selectedNode != null) {
            this.remove(this.selectedNode);
        }
    }

    public void remove(TreeNode treeNode) {
        if (!this.exists(treeNode)) {
            return;
        }
        if (treeNode == this.selectedNode) {
            int n = this.v.indexOf(this.selectedNode);
            if (n == -1) {
                n = this.e.indexOf(this.selectedNode);
            }
            if (n > this.viewCount - 1) {
                n = this.viewCount - 1;
            }
            if (n > 0) {
                this.setSelectedNode((TreeNode)this.v.elementAt(n - 1));
            } else if (this.viewCount > 1) {
                this.setSelectedNode((TreeNode)this.v.elementAt(1));
            }
        }
        if (treeNode.parent != null) {
            if (treeNode.parent.child == treeNode) {
                if (treeNode.sibling != null) {
                    treeNode.parent.child = treeNode.sibling;
                } else {
                    treeNode.parent.child = null;
                    treeNode.parent.collapse();
                }
            } else {
                TreeNode treeNode2 = treeNode.parent.child;
                while (treeNode2.sibling != treeNode) {
                    treeNode2 = treeNode2.sibling;
                }
                treeNode2.sibling = treeNode.sibling != null ? treeNode.sibling : null;
            }
        } else if (treeNode == this.rootNode) {
            this.rootNode = treeNode.sibling == null ? null : treeNode.sibling;
        } else {
            TreeNode treeNode3 = this.rootNode;
            while (treeNode3.sibling != treeNode) {
                treeNode3 = treeNode3.sibling;
            }
            treeNode3.sibling = treeNode.sibling != null ? treeNode.sibling : null;
        }
        this.recount();
        this.redrawTriggered = true;
    }

    public void printTree(TreeNode treeNode) {
        this.printTree(treeNode, false);
    }

    public void printTree(TreeNode treeNode, boolean bl) {
        if (treeNode == null) {
            return;
        }
        String string = new String();
        if (bl) {
            int n = 0;
            while (n < treeNode.depth) {
                string = "  " + string;
                ++n;
            }
        }
        System.out.println(String.valueOf(string) + treeNode.text);
        this.printTree(treeNode.child, bl);
        this.printTree(treeNode.sibling, bl);
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (this.redrawTriggered || dimension.width != this.viewWidth || dimension.height != this.viewHeight) {
            this.redraw(graphics);
        }
        graphics.translate(-this.sbHPosition, 0);
        graphics.clearRect(this.sbHPosition, 0, dimension.width - this.sbVWidth, dimension.height - this.sbHHeight);
        if (this.sbVShow && this.sbHShow) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(this.sbHPosition + dimension.width - this.sbVWidth, dimension.height - this.sbHHeight, this.sbVWidth, this.sbHHeight);
        }
        graphics.clipRect(this.sbHPosition, 0, dimension.width - this.sbVWidth, dimension.height - this.sbHHeight);
        graphics.drawImage(this.im1, 0, 0, this);
        graphics.setColor(Color.black);
        graphics.drawRect(this.sbHPosition, 0, dimension.width - this.sbVWidth - 1, dimension.height - this.sbHHeight - 1);
        if (this.popupRect != null) {
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.f);
            int n = fontMetrics.getHeight();
            graphics.setColor(new Color(255, 255, 200));
            graphics.fillRect(this.popupRect.x + this.sbHPosition, this.popupRect.y, this.popupRect.width, this.popupRect.height);
            graphics.setColor(Color.black);
            graphics.drawRect(this.popupRect.x + this.sbHPosition, this.popupRect.y, this.popupRect.width, this.popupRect.height);
            graphics.setColor(Color.black);
            int n2 = 0;
            while (n2 < this.hoverStrings.size()) {
                graphics.drawString((String)this.hoverStrings.elementAt(n2), this.popupRect.x + 2 + this.sbHPosition, this.popupRect.y + (n + 2) * (n2 + 1) - 5);
                ++n2;
            }
        }
    }

    public void redraw() {
        this.triggerRedraw();
    }

    public void repaint(boolean bl) {
        if (bl) {
            this.needResetVector = true;
        }
        this.triggerRedraw();
    }

    public void redraw(Graphics graphics) {
        Dimension dimension = this.size();
        this.redrawTriggered = false;
        if (this.needResetVector) {
            this.resetVector();
        } else {
            this.needResetVector = true;
        }
        this.newWidth = this.compWidth(graphics);
        int n = (dimension.height - this.sbHHeight) / this.cellSize;
        if (this.viewCount > n) {
            this.sbVShow = true;
            this.sbVWidth = this.verticalScrollBar.preferredSize().width;
        } else {
            this.sbVShow = false;
            this.sbVWidth = 0;
            this.sbVPosition = 0;
        }
        if (this.newWidth > dimension.width - this.sbVWidth) {
            this.sbHShow = true;
            this.sbHHeight = this.horizontalScrollBar.preferredSize().height;
        } else {
            this.sbHShow = false;
            this.sbHHeight = 0;
            this.sbHPosition = 0;
        }
        this.drawTree();
        if (this.sbVShow) {
            this.verticalScrollBar.reshape(dimension.width - this.sbVWidth, 0, this.sbVWidth, dimension.height - this.sbHHeight);
            this.verticalScrollBar.setValues(this.sbVPosition, n, 0, this.viewCount);
            this.verticalScrollBar.setPageIncrement(n - 1);
            this.verticalScrollBar.show();
        } else {
            this.verticalScrollBar.hide();
        }
        if (this.sbHShow) {
            this.horizontalScrollBar.reshape(0, dimension.height - this.sbHHeight, dimension.width - this.sbVWidth, this.sbHHeight);
            this.horizontalScrollBar.setValues(this.sbHPosition, dimension.width - this.sbVWidth, 0, this.sbHSize);
            this.horizontalScrollBar.setPageIncrement(dimension.width - this.sbVWidth);
            this.horizontalScrollBar.setLineIncrement(this.sbHLineIncrement);
            this.horizontalScrollBar.show();
        } else {
            this.horizontalScrollBar.hide();
        }
    }

    public void drawTree() {
        Dimension dimension = this.size();
        if (this.needResetVector) {
            this.resetVector();
        }
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight || this.g1 == null || this.sbHSize != this.newWidth) {
            this.sbHSize = this.newWidth;
            this.im1 = this.createImage(Math.max(this.sbHSize, dimension.width), dimension.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            if (this.g1.getClip() == null) {
                this.sbHSize = this.newWidth;
                this.g1.clipRect(0, 0, Math.max(this.sbHSize, dimension.width), dimension.height);
            }
            this.viewWidth = dimension.width;
            this.viewHeight = dimension.height;
        }
        this.g1.setFont(this.f);
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(this.bkColor);
        this.g1.fillRect(0, 0, this.im1.getWidth(this), dimension.height);
        int n = this.sbVPosition + this.viewHeight / this.cellSize + 1;
        if (n > this.viewCount) {
            n = this.viewCount;
        }
        TreeNode treeNode = null;
        if (!this.v.isEmpty()) {
            treeNode = (TreeNode)this.v.elementAt(this.sbVPosition);
        }
        int n2 = this.sbVPosition;
        while (n2 < n) {
            Object object;
            int n3;
            TreeNode treeNode2 = (TreeNode)this.v.elementAt(n2);
            int n4 = this.cellSize * (treeNode2.depth + 1);
            int n5 = (n2 - this.sbVPosition) * this.cellSize;
            this.g1.setColor(this.getForeground());
            if (treeNode2.sibling != null && treeNode2.isASiblingVisible()) {
                n3 = this.v.indexOf(treeNode2.sibling) - n2;
                if (n3 > n) {
                    n3 = n;
                }
                this.drawDotLine(n4 - this.cellSize / 2, n5 + this.cellSize / 2, n4 - this.cellSize / 2, n5 + this.cellSize / 2 + n3 * this.cellSize);
            }
            n3 = 0;
            while (n3 < n2) {
                object = (TreeNode)this.v.elementAt(n3);
                if (((TreeNode)object).sibling == treeNode2 && n3 < this.sbVPosition) {
                    this.drawDotLine(n4 - this.cellSize / 2, 0, n4 - this.cellSize / 2, n5 + this.cellSize / 2);
                }
                ++n3;
            }
            if (treeNode2.isExpanded() && treeNode2.isAChildVisible()) {
                this.drawDotLine(n4 + this.cellSize / 2, n5 + this.cellSize - 2, n4 + this.cellSize / 2, n5 + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(this.getForeground());
            this.drawDotLine(n4 - this.cellSize / 2, n5 + this.cellSize / 2, n4 + this.cellSize / 2, n5 + this.cellSize / 2);
            this.drawNodeToggle(treeNode2, n4, n5);
            object = treeNode2.getImage();
            if (object != null) {
                int n6 = (this.cellSize - ((Image)object).getHeight(this)) / 2;
                this.g1.drawImage((Image)object, n4 + this.imageInset, n5 + n6, this);
            }
            if (treeNode2.text != null) {
                this.drawNodeText(treeNode2, n5, treeNode2 == this.selectedNode, false);
            }
            if (treeNode.depth > treeNode2.depth) {
                treeNode = treeNode2;
            }
            ++n2;
        }
        if (treeNode != null) {
            while ((treeNode = treeNode.parent) != null) {
                if (treeNode.sibling == null || !treeNode.isASiblingVisible()) continue;
                this.drawDotLine(this.cellSize * (treeNode.depth + 1) - this.cellSize / 2, 0, this.cellSize * (treeNode.depth + 1) - this.cellSize / 2, dimension.height);
            }
        }
        this.needResetVector = true;
    }

    protected void drawNodeToggle(TreeNode treeNode, int n, int n2) {
        if (treeNode.isExpandable() && treeNode.isAChildVisible()) {
            this.g1.setColor(this.getBackground());
            this.g1.fillRect(this.cellSize * treeNode.depth + this.cellSize / 4, n2 + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(this.cellSize * treeNode.depth + this.cellSize / 4, n2 + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.drawLine(this.cellSize * treeNode.depth + this.cellSize / 4 + 2, n2 + this.cellSize / 2, this.cellSize * treeNode.depth + this.cellSize / 4 + this.clickSize - 2, n2 + this.cellSize / 2);
            if (!treeNode.isExpanded()) {
                this.g1.drawLine(this.cellSize * treeNode.depth + this.cellSize / 2, n2 + this.clickSize / 2 + 2, this.cellSize * treeNode.depth + this.cellSize / 2, n2 + this.clickSize / 2 + this.clickSize - 2);
            }
        }
    }

    public synchronized Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public synchronized Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public synchronized Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 507) {
            try {
                Method method = aWTEvent.getClass().getMethod("getWheelRotation", null);
                Integer n = (Integer)method.invoke((Object)aWTEvent, null);
                if (n > 0) {
                    if (this.sbVPosition < this.verticalScrollBar.getMaximum() - 1) {
                        ++this.sbVPosition;
                        this.verticalScrollBar.setValue(this.sbVPosition);
                    }
                } else if (this.sbVPosition > 0) {
                    --this.sbVPosition;
                    this.verticalScrollBar.setValue(this.sbVPosition);
                }
                this.triggerRedraw();
                this.repaint();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.enableEvents(131072L);
        this.addKeyListener(this);
        this.verticalScrollBar.addAdjustmentListener(this);
        this.horizontalScrollBar.addAdjustmentListener(this);
        this.addFocusListener(this);
    }

    public synchronized void removeNotify() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.verticalScrollBar.removeAdjustmentListener(this);
        this.horizontalScrollBar.removeAdjustmentListener(this);
        this.removeFocusListener(this);
        super.removeNotify();
    }

    public void triggerRedraw() {
        this.redrawTriggered = true;
        this.repaint();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.handleAdjustmentEvent(adjustmentEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.handleMousePressed(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n2 / this.cellSize + this.sbVPosition;
        if (n3 > this.viewCount - 1) {
            return;
        }
        TreeNode treeNode = this.selectedNode;
        TreeNode treeNode2 = (TreeNode)this.v.elementAt(n3);
        int n4 = treeNode2.getDepth();
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.f);
        int n5 = fontMetrics.stringWidth(treeNode2.getText());
        int n6 = fontMetrics.getHeight();
        Rectangle rectangle = new Rectangle(this.cellSize * n4 - this.sbHPosition + this.cellSize / 4 + 32, (n3 - this.sbVPosition) * this.cellSize + 1, n5 + 5, n6 + 2);
        int n7 = this.getSize().width - 10;
        if (rectangle.inside(n, n2)) {
            if (rectangle.width + rectangle.x > n7 && (this.popupRect == null || this.popupRect != null && this.popupRect.y != rectangle.y)) {
                if (this.popupRect != null) {
                    this.repaint(this.popupRect.x, this.popupRect.y, this.popupRect.width + 1, this.popupRect.height + 1);
                }
                this.popupRect = rectangle;
                this.popupRect.x += this.sbHPosition;
                String string = treeNode2.getText();
                int n8 = 0;
                this.hoverStrings.removeAllElements();
                int n9 = 0;
                int n10 = 0;
                while (n8 < 100) {
                    ++n8;
                    if ((n9 = string.indexOf(32, n9)) == -1) {
                        if (n10 != 0) {
                            this.hoverStrings.addElement(string.substring(0, n10));
                        }
                        this.hoverStrings.addElement(string.substring(n10));
                        break;
                    }
                    if (fontMetrics.stringWidth(string.substring(0, ++n9)) + rectangle.x > n7 - 10) {
                        if (n10 == 0) {
                            n10 = n9;
                        }
                        this.hoverStrings.addElement(string.substring(0, n10));
                        string = string.substring(n10);
                        n10 = 0;
                        continue;
                    }
                    n10 = n9;
                }
                this.popupRect.height *= this.hoverStrings.size();
                this.popupRect.width = n7 - this.popupRect.x - 10;
                this.repaint(this.popupRect.x, this.popupRect.y, this.popupRect.width + 1, this.popupRect.height + 1);
            }
        } else if (this.popupRect != null) {
            this.repaint(this.popupRect.x, this.popupRect.y, this.popupRect.width + 1, this.popupRect.height + 1);
            this.popupRect = null;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.handleKeyPressed(keyEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.handleFocusGained(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.handleFocusLost(focusEvent);
    }

    protected void handleMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n2 / this.cellSize + this.sbVPosition;
        if (n3 > this.viewCount - 1) {
            return;
        }
        TreeNode treeNode = this.selectedNode;
        TreeNode treeNode2 = (TreeNode)this.v.elementAt(n3);
        int n4 = treeNode2.getDepth();
        Rectangle rectangle = new Rectangle(this.cellSize * n4 + this.cellSize / 4, (n3 - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
        if (rectangle.inside(n, n2)) {
            treeNode2.toggle();
            this.resetVector();
            if (!treeNode2.isExpanded() && !this.v.contains(this.selectedNode)) {
                this.setSelectedNode(treeNode2);
            }
            this.triggerRedraw();
            this.invalidate();
            this.sendActionEvent();
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 2001, treeNode2, treeNode2.isExpanded ? 2002 : 2003));
            }
        } else {
            this.setSelectedNode(treeNode2);
            long l = mouseEvent.getWhen();
            if (treeNode2 == treeNode && mouseEvent.getWhen() - this.timeMouseDown < (long)this.doubleClickResolution) {
                treeNode2.toggle();
                this.resetVector();
                this.triggerRedraw();
                this.invalidate();
                this.sendActionEvent();
                if (this.itemListener != null) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 2001, treeNode2, treeNode2.isExpanded ? 2002 : 2003));
                }
                return;
            }
            this.timeMouseDown = mouseEvent.getWhen();
        }
    }

    protected void handleMouseMoved(MouseEvent mouseEvent) {
    }

    protected void handleAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.verticalScrollBar) {
            if (this.sbVPosition != this.verticalScrollBar.getValue()) {
                this.sbVPosition = this.verticalScrollBar.getValue();
                this.triggerRedraw();
            }
        } else if (adjustmentEvent.getAdjustable() == this.horizontalScrollBar && this.sbHPosition != this.horizontalScrollBar.getValue()) {
            this.sbHPosition = this.horizontalScrollBar.getValue();
            this.triggerRedraw();
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (this.selectedNode != null) {
            int n = this.v.indexOf(this.selectedNode);
            switch (keyEvent.getKeyCode()) {
                case 10: 
                case 13: {
                    this.sendActionEvent();
                    this.requestFocus();
                    break;
                }
                case 37: {
                    if (keyEvent.isControlDown()) {
                        if (this.sbHPosition <= 0) break;
                        this.horizontalScrollBar.setValue(Math.max(this.sbHPosition -= this.sbHLineIncrement, 0));
                        this.repaint();
                        break;
                    }
                    if (this.selectedNode.isExpanded()) {
                        this.selectedNode.toggle();
                        if (this.itemListener == null) break;
                        this.itemListener.itemStateChanged(new ItemEvent(this, 2001, this.selectedNode, this.selectedNode.isExpanded ? 2002 : 2003));
                        this.triggerRedraw();
                        break;
                    }
                }
                case 38: {
                    if (n <= 0) break;
                    this.setSelectedNode((TreeNode)this.v.elementAt(--n));
                    this.requestFocus();
                    break;
                }
                case 39: {
                    if (keyEvent.isControlDown()) {
                        int n2 = this.horizontalScrollBar.getMaximum() - (isSun1_1 ? this.size().width - this.sbVWidth : 0);
                        if (!this.sbHShow || this.sbHPosition >= n2) break;
                        this.horizontalScrollBar.setValue(Math.min(this.sbHPosition += this.sbHLineIncrement, n2));
                        this.repaint();
                        break;
                    }
                    if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                        this.selectedNode.toggle();
                        this.sendActionEvent();
                        if (this.itemListener == null) break;
                        this.itemListener.itemStateChanged(new ItemEvent(this, 2001, this.selectedNode, this.selectedNode.isExpanded ? 2002 : 2003));
                        this.triggerRedraw();
                        break;
                    }
                    if (!this.selectedNode.isExpandable()) break;
                }
                case 40: {
                    if (n >= this.viewCount - 1) break;
                    this.setSelectedNode((TreeNode)this.v.elementAt(++n));
                    this.requestFocus();
                    break;
                }
            }
        }
    }

    protected void handleFocusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true, false);
        }
    }

    protected void handleFocusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true, false);
        }
    }

    protected void drawNodeText(TreeNode treeNode, int n, boolean bl, boolean bl2) {
        Color color;
        Color color2;
        if (treeNode == null) {
            return;
        }
        int n2 = treeNode.depth;
        Image image = treeNode.getImage();
        int n3 = (n2 + 1) * this.cellSize + this.cellSize + this.textInset - (image == null ? 12 : 0);
        if (treeNode == this.selectedNode && this.hasFocus) {
            color2 = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
            color = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
        } else {
            color2 = this.getForeground();
            color = this.getBackground();
        }
        if (bl) {
            this.g1.setColor(color);
            this.g1.fillRect(n3 - 1, n + 1, this.fm.stringWidth(treeNode.text) + 4, this.cellSize - 1);
        }
        if (treeNode == this.selectedNode) {
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(n3 - 1, n + 1, this.fm.stringWidth(treeNode.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, n3 - 1 - this.sbHPosition), n + 1, this.fm.stringWidth(treeNode.text) + 4, this.cellSize - 1);
        }
        if (bl2) {
            this.g1.setColor(this.getBackground());
            this.g1.drawRect(n3 - 1, n + 1, this.fm.stringWidth(treeNode.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, n3 - 1 - this.sbHPosition), n + 1, this.fm.stringWidth(treeNode.text) + 4, this.cellSize - 1);
        }
        this.g1.setFont(this.f);
        this.g1.setColor(color2);
        this.g1.drawString(treeNode.text, n3, n + this.cellSize - this.textBaseLine);
    }

    protected void sendActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, new String(this.selectedNode.getText())));
        }
    }

    protected int compWidth(Graphics graphics) {
        int n = 0;
        Font font = this.getFont();
        this.fm = graphics == null ? null : graphics.getFontMetrics();
        if (this.fm == null) {
            this.fm = this.getFontMetrics(font);
        }
        if (this.fm == null || this.v == null) {
            n = 100;
        } else {
            int n2 = 0;
            while (n2 < this.v.size()) {
                TreeNode treeNode = (TreeNode)this.v.elementAt(n2);
                int n3 = (treeNode.depth + 1) * this.cellSize + this.cellSize + this.textInset - (treeNode.getImage() == null ? 12 : 0);
                if (n < n3 + this.fm.stringWidth(treeNode.text) + 6) {
                    n = n3 + this.fm.stringWidth(treeNode.text) + 6;
                }
                ++n2;
            }
        }
        return n;
    }

    protected void drawDotLine(int n, int n2, int n3, int n4) {
        if (n2 == n4) {
            int n5 = n;
            while (n5 < n3) {
                this.g1.drawLine(n5, n2, n5, n4);
                n5 += 2;
            }
        } else {
            int n6 = n2;
            while (n6 < n4) {
                this.g1.drawLine(n, n6, n3, n6);
                n6 += 2;
            }
        }
    }

    protected void changeSelection(TreeNode treeNode) {
        this.setSelectedNode(treeNode);
    }

    public void setSelectedNode(TreeNode treeNode, boolean bl) {
        if (treeNode == null) {
            if (this.selectedNode != null) {
                this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true, true);
                if (this.itemListener != null && bl) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 2));
                }
                this.selectedNode = null;
            }
            return;
        }
        if (treeNode == this.selectedNode) {
            return;
        }
        TreeNode treeNode2 = this.selectedNode;
        this.selectedNode = treeNode;
        if (this.v.indexOf(treeNode) == -1) {
            return;
        }
        if (treeNode2 != null) {
            this.drawNodeText(treeNode2, (this.v.indexOf(treeNode2) - this.sbVPosition) * this.cellSize, true, false);
        }
        this.drawNodeText(treeNode, (this.v.indexOf(treeNode) - this.sbVPosition) * this.cellSize, true, false);
        int n = this.v.indexOf(this.selectedNode);
        if (this.itemListener != null && bl) {
            if (treeNode2 != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, treeNode2, 2));
            }
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
        }
        if (n < this.sbVPosition) {
            --this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (n >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.repaint();
    }

    public void setSelectedNode(TreeNode treeNode) {
        this.setSelectedNode(treeNode, true);
    }

    protected TreeNode newTreeNode(String string, TreeView treeView) {
        return new TreeNode(string, treeView);
    }

    protected void parseTreeStructure(String[] stringArray) throws InvalidTreeNodeException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = this.findLastPreSpace(string);
            if (n2 == -1) {
                throw new InvalidTreeNodeException("EmptyStrings");
            }
            TreeNode treeNode = this.newTreeNode(string.trim(), this);
            treeNode.setDepth(n2);
            if (this.rootNode == null) {
                if (n2 != 0) {
                    throw new InvalidTreeNodeException("NoRootLevelNode");
                }
                this.append(treeNode);
            } else {
                int n3;
                TreeNode treeNode2 = this.rootNode;
                while (treeNode2.sibling != null) {
                    treeNode2 = treeNode2.sibling;
                }
                int n4 = 1;
                while (n4 < n2) {
                    n3 = treeNode2.numberOfChildren;
                    TreeNode treeNode3 = null;
                    if (n3 > 0) {
                        treeNode3 = treeNode2.child;
                        while (treeNode3.sibling != null) {
                            treeNode3 = treeNode3.sibling;
                        }
                    }
                    if (treeNode3 == null) break;
                    treeNode2 = treeNode3;
                    ++n4;
                }
                if ((n3 = n2 - treeNode2.getDepth()) > 1) {
                    throw new InvalidTreeNodeException("NoParent" + string.trim());
                }
                if (n3 == 1) {
                    this.insert(treeNode, treeNode2, 0);
                } else {
                    this.insert(treeNode, treeNode2, 1);
                }
            }
            ++n;
        }
    }

    protected void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    protected void traverse(TreeNode treeNode) {
        ++this.count;
        if (!treeNode.isHidden()) {
            this.e.addElement(treeNode);
            if (treeNode.child != null) {
                treeNode.child.depth = treeNode.depth + 1;
                this.traverse(treeNode.child);
            }
        }
        if (treeNode.sibling != null) {
            treeNode.sibling.depth = treeNode.depth;
            this.traverse(treeNode.sibling);
        }
    }

    protected void resetVector() {
        this.v = new Vector(this.count);
        this.viewWidest = 30;
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, true, true, this.v);
        this.viewCount = this.v.size();
        this.needResetVector = false;
    }

    protected void vectorize(TreeNode treeNode, boolean bl, boolean bl2, Vector vector) {
        if (treeNode == null) {
            return;
        }
        if (!bl2 || !treeNode.isHidden()) {
            vector.addElement(treeNode);
            if (!bl && treeNode.child != null || treeNode.isExpanded()) {
                treeNode.child.depth = treeNode.depth + 1;
                this.vectorize(treeNode.child, bl, bl2, vector);
            }
        }
        if (treeNode.sibling != null) {
            treeNode.sibling.depth = treeNode.depth;
            this.vectorize(treeNode.sibling, bl, bl2, vector);
        }
    }

    protected void debugVector() {
        int n = this.v.size();
        int n2 = 0;
        while (n2 < this.count) {
            TreeNode treeNode = (TreeNode)this.v.elementAt(n2);
            System.out.println(treeNode.text);
            ++n2;
        }
    }

    protected int findLastPreSpace(String string) {
        if (string != null && string.length() > 0) {
            int n = string.length();
            if (string.charAt(0) != ' ' && string.charAt(0) != '\t') {
                return 0;
            }
            int n2 = 1;
            while (n2 < n) {
                if (string.charAt(n2) != ' ' && string.charAt(n2) != '\t') {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }
}

