' Copyright (c) 2003-2007 Quadralay Corporation.  All rights reserved.
'
'$Id: wwh5merge.vbs,v 1.2 2007-01-26 23:22:03 staples Exp $
'

' ###############################################

Set GlobalFileSystem = CreateObject("Scripting.FileSystemObject")

WScript.Quit(Not WWHelp_Main)

' ###############################################

Function WW_Strings_Replace(ParamString, _
                            ParamPattern, _
                            ParamReplacement)
  Dim VarString
  Dim VarIndex


  ' Search for pattern
  '
  VarString = ParamString
  VarIndex = InStr(1, VarString, ParamPattern, 1)

  ' Replace pattern and advance
  '
  While (VarIndex > 0)
    VarString = Left(VarString, VarIndex - 1) & ParamReplacement & Mid(VarString, VarIndex + Len(ParamPattern))
    VarIndex = InStr(VarIndex + Len(ParamReplacement), VarString, ParamPattern, 1)
  Wend

  ' Return the result
  '
  WW_Strings_Replace = VarString
End Function

' ###############################################

Function WWHelp_ValidHelpFolder(ParamFolder)
  Dim bVarSuccess
  Dim VarInfoFileName


  ' Initialize return value
  '
  bVarSuccess = False

  VarInfoFileName = ParamFolder.Path
  VarInfoFileName = GlobalFileSystem.BuildPath(VarInfoFileName, "wwhdata")
  VarInfoFileName = GlobalFileSystem.BuildPath(VarInfoFileName, "info.txt")

  If (GlobalFileSystem.FileExists(VarInfoFileName)) Then
    ' Success!
    '
    bVarSuccess = True
  End If

  WWHelp_ValidHelpFolder = bVarSuccess
End Function

' ###############################################

Function WWHelp_GetSortOrder(ParamHelpFolder)
  Dim VarSortOrder
  Dim VarInfoFileName
  Dim VarInfoStream
  Dim VarLine


  ' Initialize return value
  '
  VarSortOrder = "9999"

  VarInfoFileName = ParamHelpFolder.Path
  VarInfoFileName = GlobalFileSystem.BuildPath(VarInfoFileName, "wwhdata")
  VarInfoFileName = GlobalFileSystem.BuildPath(VarInfoFileName, "info.txt")

  If (GlobalFileSystem.FileExists(VarInfoFileName)) Then
    ' Open the file and get the info
    '
    Set VarInfoStream = GlobalFileSystem.OpenTextFile(VarInfoFileName, 1)
    VarLine = ""
    If (Not VarInfoStream.AtEndOfStream) Then
      VarLine = VarInfoStream.ReadLine
    End If
    VarInfoStream.Close

    If (Len(VarLine) > 0) Then
      If (CInt(VarLine) > 0) Then
        VarSortOrder = CStr(CInt(VarLine))

        While (Len(VarSortOrder) < 4)
          VarSortOrder = "0" & VarSortOrder
        Wend
      End If
    End If
  End If

  WWHelp_GetSortOrder = VarSortOrder
End Function

' ###############################################

Function WWHelp_GetGrouping(ParamHelpFolder)
  Dim VarGrouping
  Dim VarInfoFileName
  Dim VarInfoStream
  Dim VarLine


  ' Initialize return value
  '
  VarGrouping = ""

  VarInfoFileName = ParamHelpFolder.Path
  VarInfoFileName = GlobalFileSystem.BuildPath(VarInfoFileName, "wwhdata")
  VarInfoFileName = GlobalFileSystem.BuildPath(VarInfoFileName, "info.txt")

  If (GlobalFileSystem.FileExists(VarInfoFileName)) Then
    ' Open the file and get the info
    '
    Set VarInfoStream = GlobalFileSystem.OpenTextFile(VarInfoFileName, 1)
    VarLine = ""
    If (Not VarInfoStream.AtEndOfStream) Then
      VarLine = VarInfoStream.ReadLine
    End If
    VarLine = ""
    If (Not VarInfoStream.AtEndOfStream) Then
      VarLine = VarInfoStream.ReadLine
    End If
    VarInfoStream.Close

    If (Len(VarLine) > 0) Then
      VarGrouping = VarLine
    End If
  End If

  WWHelp_GetGrouping = VarGrouping
End Function

' ###############################################

Sub WWHelp_SortArray(ParamArrayToSort)
  Dim bVarSwapOccurred
  Dim VarIndex
  Dim VarTemp


  If (UBound(ParamArrayToSort) > 0) Then
    bVarSwapOccurred = True
    While (bVarSwapOccurred)
      bVarSwapOccurred = False

      For VarIndex = LBound(ParamArrayToSort) To (UBound(ParamArrayToSort) - 1)
        If (ParamArrayToSort(VarIndex) > ParamArrayToSort(VarIndex + 1)) Then
          VarTemp = ParamArrayToSort(VarIndex)
          ParamArrayToSort(VarIndex) = ParamArrayToSort(VarIndex + 1)
          ParamArrayToSort(VarIndex + 1) = VarTemp

          bVarSwapOccurred = True
        End If
      Next
    Wend
  End If
End Sub

' ###############################################

Sub WWHelp_GetHelpFolders(ParamBaseFolderPath, _
                          ParamSelectedFolderRelativePath, _
                          ParamSortDictionary)
  Dim VarSelectedFolderPath
  Dim VarSelectedFolder
  Dim VarSelectedFolderRelativePath
  Dim VarSubFolder
  Dim VarSubFolderRelativePath


  ' Determine absolute name of selected folder
  '
  If (Len(ParamSelectedFolderRelativePath) > 0) Then
    VarSelectedFolderPath = GlobalFileSystem.BuildPath(ParamBaseFolderPath, ParamSelectedFolderRelativePath)
  Else
    VarSelectedFolderPath = ParamBaseFolderPath
  End If

  ' Check selected folder
  '
  If (GlobalFileSystem.FolderExists(VarSelectedFolderPath)) Then
    Set VarSelectedFolder = GlobalFileSystem.GetFolder(VarSelectedFolderPath)

    ' Valid folder?
    '
    If ((VarSelectedFolder.Name = "wwhdata") Or _
        (VarSelectedFolder.Name = "wwhelp")) Then
      ' Skip the wwhdata and wwhelp folders
      '
    Else
      ' Confirm the info entry is defined
      '
      If (WWHelp_ValidHelpFolder(VarSelectedFolder)) Then
        ' Handle case where the base folder is a help folder
        '
        If (Len(ParamSelectedFolderRelativePath) = 0) Then
          VarSelectedFolderRelativePath = "."
        Else
          VarSelectedFolderRelativePath = ParamSelectedFolderRelativePath
        End If

        ' Add help folder
        '
        WScript.Echo "  Adding: " & VarSelectedFolderRelativePath
        VarSortOrder = WWHelp_GetSortOrder(VarSelectedFolder)
        Call ParamSortDictionary.Add(VarSortOrder & " " & ParamSelectedFolderRelativePath, VarSelectedFolderRelativePath)
      Else
        ' Check sub-folders
        '
        For Each VarSubFolder In VarSelectedFolder.SubFolders
          VarSubFolderRelativePath = GlobalFileSystem.BuildPath(ParamSelectedFolderRelativePath, VarSubFolder.Name)
          Call WWHelp_GetHelpFolders(ParamBaseFolderPath, VarSubFolderRelativePath, ParamSortDictionary)
        Next
      End If
    End If
  End If
End Sub

' ###############################################

Function WWHelp_GetBookFolders(ParamHelpFolder, _
                               ParamBookInfoArray)
  Dim VarSortDictionary
  Dim VarSortArray
  Dim VarIndex
  Dim VarKey
  Dim VarSubFolderRelativePath
  Dim VarSubFolderPath


  ' Initialize return value
  '
  bVarSuccess = False

  ' Get directory and sort info
  '
  Set VarSortDictionary = CreateObject("Scripting.Dictionary")
  Call WWHelp_GetHelpFolders(ParamHelpFolder, "", VarSortDictionary)

  ' Push folder entries into book directory array in order
  '
  If (VarSortDictionary.Count > 0) Then
    ' Determine the book directory sort order
    '
    VarSortArray = Array()
    Redim VarSortArray(VarSortDictionary.Count - 1)
    VarIndex = 0
    For Each VarKey In VarSortDictionary
      VarSortArray(VarIndex) = VarKey

      VarIndex = VarIndex + 1
    Next
    Call WWHelp_SortArray(VarSortArray)

    ' Emit the book directories in the correct sort order
    '
    ReDim ParamBookInfoArray(VarSortDictionary.Count - 1, 2)
    For VarIndex = LBound(VarSortArray) To UBound(VarSortArray)
      VarKey = VarSortArray(VarIndex)
      VarSubFolderRelativePath = VarSortDictionary.Item(VarKey)
      VarSubFolderPath = GlobalFileSystem.BuildPath(ParamHelpFolder, VarSubFolderRelativePath)
      Set VarSubFolder = GlobalFileSystem.GetFolder(VarSubFolderPath)

      ParamBookInfoArray(VarIndex, 0) = VarSubFolderRelativePath
      ParamBookInfoArray(VarIndex, 1) = WWHelp_GetGrouping(VarSubFolder)
    Next

    bVarSuccess = True
  End If

  WWHelp_GetBookFolders = bVarSuccess
End Function

' ###############################################

Function WWHelp_GetGroupingLevel(ParamGrouping)
  Dim RetLevel
  Dim VarIndex


  ' Initialize return value
  '
  RetLevel = 0

  If (Len(ParamGrouping) > 0) Then
    RetLevel = 1

    VarIndex = InStr(1, ParamGrouping, "/")
    While (VarIndex > 0)
      RetLevel = RetLevel + 1

      If ((VarIndex + 1) <= Len(ParamGrouping)) Then
        VarIndex = InStr(VarIndex + 1, ParamGrouping, "/")
      Else
        VarIndex = 0
      End If
    Wend
  End If

  WWHelp_GetGroupingLevel = RetLevel
End Function

' ###############################################

Function WWHelp_GetGroupingWhitespace(ParamGrouping, _
                                      ParamWhitespaceIncrement)
  Dim RetWhitespace
  Dim VarLevel


  ' Initialize return value
  '
  RetWhitespace = ParamWhitespaceIncrement

  VarLevel = WWHelp_GetGroupingLevel(ParamGrouping)
  While (VarLevel > 1)
    RetWhitespace = RetWhitespace & ParamWhitespaceIncrement

    VarLevel = VarLevel - 1
  Wend

  WWHelp_GetGroupingWhitespace = RetWhitespace
End Function

' ###############################################

Function WWHelp_ContinueClosing(ParamCurrentGrouping, _
                                ParamGrouping)
  Dim bVarContinueClosing


  ' Initialize return value
  '
  bVarContinueClosing = False

  If (Len(ParamCurrentGrouping) > 0) Then
    If (ParamGrouping <> ParamCurrentGrouping) Then
      If (InStr(ParamGrouping, ParamCurrentGrouping & "/") <= 0) Then
        bVarContinueClosing = True
      End If
    End If
  End If

  WWHelp_ContinueClosing = bVarContinueClosing
End Function

' ###############################################

Function WWHelp_HandleGroupingChange(ParamTextStream, _
                                     ParamPreviousGrouping, _
                                     ParamGrouping, _
                                     ParamContainer, _
                                     ParamOpen, _
                                     ParamClose, _
                                     ParamWhitespaceIncrement)
  Dim RetContainer
  Dim VarCurrentGrouping
  Dim VarWhitespace
  Dim VarIndex
  Dim VarStartIndex
  Dim VarEndIndex
  Dim VarGroup
  Dim VarLevel
  Dim VarParentContainer
  Dim VarContainer
  Dim VarOpen


  ' Initialize return value
  '
  RetContainer = ParamContainer

  ' Handle groupings
  '
  If (ParamGrouping <> ParamPreviousGrouping) Then
    ' Close previous grouping
    '
    VarCurrentGrouping = ParamPreviousGrouping
    While (WWHelp_ContinueClosing(VarCurrentGrouping, ParamGrouping))
      VarWhitespace = WWHelp_GetGroupingWhitespace(VarCurrentGrouping, ParamWhitespaceIncrement)
      If (Len(ParamClose) > 0) Then
        ParamTextStream.WriteLine(VarWhitespace & ParamClose)
      End If

      VarIndex = InStrRev(VarCurrentGrouping, "/")
      If (VarIndex > 0) Then
        VarCurrentGrouping = Left(VarCurrentGrouping, VarIndex - 1)
      Else
        VarCurrentGrouping = ""
      End If
    Wend

    ' Open new grouping
    '
    If ((Len(ParamGrouping) = 0) And _
        (Len(VarCurrentGrouping) = 0)) Then
      ' Same strings, but they are empty
      '
      RetContainer = "ParamTop"
    Else
      ' Process until strings are equivalent
      '
      While (ParamGrouping <> VarCurrentGrouping)
        VarStartIndex = Len(VarCurrentGrouping) + 1
        If (Mid(ParamGrouping, VarStartIndex, 1) = "/") Then
          VarStartIndex = VarStartIndex + 1
        End If
        VarEndIndex = InStr(VarStartIndex, ParamGrouping, "/")
        If (VarEndIndex <= 0) Then
          VarEndIndex = Len(ParamGrouping) + 1
        End If
        VarGroup = Mid(ParamGrouping, VarStartIndex, VarEndIndex - VarStartIndex)

        If (Len(VarCurrentGrouping) > 0) Then
          VarCurrentGrouping = VarCurrentGrouping & "/" & VarGroup
        Else
          VarCurrentGrouping = VarGroup
        End If

        ' Determine container
        '
        VarLevel = WWHelp_GetGroupingLevel(VarCurrentGrouping)
        If (VarLevel = 1) Then
          VarParentContainer = "ParamTop"
          VarContainer = "BookGrouping" & VarLevel
        Else
          VarParentContainer = "BookGrouping" & (VarLevel - 1)
          VarContainer = "BookGrouping" & VarLevel
        End If
        RetContainer = VarContainer

        VarOpen = ParamOpen
        VarOpen = WW_Strings_Replace(VarOpen, "${VarParentContainer}", VarParentContainer)
        VarOpen = WW_Strings_Replace(VarOpen, "${VarContainer}", VarContainer)
        VarOpen = WW_Strings_Replace(VarOpen, "${VarGroup}", VarGroup)
        VarWhitespace = WWHelp_GetGroupingWhitespace(VarCurrentGrouping, ParamWhitespaceIncrement)
        ParamTextStream.WriteLine(VarWhitespace + VarOpen)
      Wend
    End If
  End If

  ' Ensure container is always specified
  '
  If (Len(RetContainer) = 0) Then
    RetContainer = "ParamTop"
  End If

  WWHelp_HandleGroupingChange = RetContainer
End Function

' ###############################################

Sub WWHelp_WriteBooksFile(ParamHelpFolder, _
                          ParamBookInfoArray)
  Dim VarBooksFileName
  Dim VarBooksStream
  Dim VarShowBooks
  Dim VarPreviousGrouping
  Dim VarOpen
  Dim VarClose
  Dim VarWhitespaceIncrement
  Dim VarIndex
  Dim VarWhitespace
  Dim VarFolderName
  Dim VarGrouping


  ' Access the books.xml file
  '
  VarBooksFileName = ParamHelpFolder
  VarBooksFileName = GlobalFileSystem.BuildPath(VarBooksFileName, "wwhelp")
  VarBooksFileName = GlobalFileSystem.BuildPath(VarBooksFileName, "books.xml")

  ' Confirm the file exists
  '
  If (GlobalFileSystem.FileExists(VarBooksFileName)) Then
    Set VarBooksStream = GlobalFileSystem.OpenTextFile(VarBooksFileName, 2)

    ' Show books?
    '
    If (UBound(ParamBookInfoArray, 1) > 0) Then
      VarShowBooks = "true"
    Else
      VarShowBooks = "false"
    End If

    ' Open the books element
    '
    VarBooksStream.WriteLine("<?xml version='1.0' encoding='UTF-8'?>")
    VarBooksStream.WriteLine("<WebWorksHelpBooks version=""5.0"" name=""WebWorks Help 5.0"" expandalltopentries=""false"" showbooks=""" & VarShowBooks & """>")

    ' Open/close levels
    '
    VarOpen = "<BookGroup name=""${VarGroup}"">"
    VarClose = "</BookGroup>"
    VarWhitespaceIncrement = "  "

    ' Write book directory entires
    '
    VarPreviousGrouping = ""
    For VarIndex = LBound(ParamBookInfoArray, 1) To UBound(ParamBookInfoArray, 1)
      ' Access record
      '
      VarFolderName = WW_Strings_Replace(ParamBookInfoArray(VarIndex, 0), "\", "/")
      VarGrouping   = ParamBookInfoArray(VarIndex, 1)

      ' Handle groupings
      '
      Call WWHelp_HandleGroupingChange(VarBooksStream, VarPreviousGrouping, VarGrouping, "", _
                                       VarOpen, VarClose, VarWhitespaceIncrement)

      ' Handle book
      '
      VarWhitespace = WWHelp_GetGroupingWhitespace(VarGrouping, VarWhitespaceIncrement)
      If (WWHelp_GetGroupingLevel(VarGrouping) > 0) Then
        VarWhitespace = VarWhitespace & VarWhitespaceIncrement
      End If
      VarBooksStream.WriteLine(VarWhitespace & "<Book directory=""" & VarFolderName & """ />")

      VarPreviousGrouping = VarGrouping
    Next

    ' Close open groupings
    '
    Call WWHelp_HandleGroupingChange(VarBooksStream, VarPreviousGrouping, "", "", _
                                     VarOpen, VarClose, VarWhitespaceIncrement)

    ' Close the books element
    '
    VarBooksStream.WriteLine("</WebWorksHelpBooks>")

    VarBooksStream.Close
  End If
End Sub

' ###############################################

Sub WWHelp_WriteBooksForJavaScript(ParamHelpFolder, _
                                   ParamBookInfoArray)
  Dim VarBooksFileName
  Dim VarBooksStream
  Dim VarOpen
  Dim VarClose
  Dim VarWhitespaceIncrement
  Dim VarPreviousGrouping
  Dim VarIndex
  Dim VarFolderName
  Dim VarGrouping
  Dim VarMaxLevel
  Dim VarLevel
  Dim VarContainer
  Dim VarWhitespace
  Dim VarShowBooks


  ' Access the books.js file
  '
  VarBooksFileName = ParamHelpFolder
  VarBooksFileName = GlobalFileSystem.BuildPath(VarBooksFileName, "wwhelp")
  VarBooksFileName = GlobalFileSystem.BuildPath(VarBooksFileName, "wwhimpl")
  VarBooksFileName = GlobalFileSystem.BuildPath(VarBooksFileName, "common")
  VarBooksFileName = GlobalFileSystem.BuildPath(VarBooksFileName, "private")
  VarBooksFileName = GlobalFileSystem.BuildPath(VarBooksFileName, "books.js")

  ' Confirm the file exists
  '
  If (GlobalFileSystem.FileExists(VarBooksFileName)) Then
    Set VarBooksStream = GlobalFileSystem.OpenTextFile(VarBooksFileName, 2)

    ' Open up the WWHBookGroups_Books function
    '
    VarBooksStream.WriteLine("// Copyright (c) 2001-2009 Quadralay Corporation.  All rights reserved.")
    VarBooksStream.WriteLine("//")
    VarBooksStream.WriteLine("")
    VarBooksStream.WriteLine("function  WWHBookGroups_Books(ParamTop)")
    VarBooksStream.WriteLine("{")

    ' Determine max grouping level
    '
    VarMaxLevel = 0
    For VarIndex = LBound(ParamBookInfoArray, 1) To UBound(ParamBookInfoArray, 1)
      ' Access record
      '
      VarFolderName = WW_Strings_Replace(ParamBookInfoArray(VarIndex, 0), "\", "/")
      VarGrouping   = ParamBookInfoArray(VarIndex, 1)

      VarLevel = WWHelp_GetGroupingLevel(VarGrouping)
      If (VarLevel > VarMaxLevel) Then
        VarMaxLevel = VarLevel
      End If
    Next

    ' Write variable declarations
    '
    For VarLevel = 1 To VarMaxLevel
      VarBooksStream.WriteLine("  var  BookGrouping" & VarLevel & ";")
    Next
    VarBooksStream.WriteLine("")
    VarBooksStream.WriteLine("")

    ' Open/close levels
    '
    VarOpen = "${VarContainer} = ${VarParentContainer}.fAddGrouping(""${VarGroup}"", null, null, null);"
    VarClose = ""
    VarWhitespaceIncrement = "  "

    ' Write book directory entries
    '
    VarPreviousGrouping = ""
    For VarIndex = LBound(ParamBookInfoArray, 1) To UBound(ParamBookInfoArray, 1)
      ' Access record
      '
      VarFolderName = WW_Strings_Replace(ParamBookInfoArray(VarIndex, 0), "\", "/")
      VarGrouping   = ParamBookInfoArray(VarIndex, 1)

      ' Handle groupings
      '
      VarContainer = WWHelp_HandleGroupingChange(VarBooksStream, VarPreviousGrouping, VarGrouping, VarContainer, _
                                                 VarOpen, VarClose, VarWhitespaceIncrement)

      ' Handle book
      '
      VarWhitespace = WWHelp_GetGroupingWhitespace(VarGrouping, VarWhitespaceIncrement)
      If (WWHelp_GetGroupingLevel(VarGrouping) > 0) Then
        VarWhitespace = VarWhitespace & VarWhitespaceIncrement
      End If
      VarBooksStream.WriteLine(VarWhitespace & VarContainer & ".fAddDirectory(""" & VarFolderName & """, null, null, null, null);")

      VarPreviousGrouping = VarGrouping
    Next

    ' Close open groupings
    '
    Call WWHelp_HandleGroupingChange(VarBooksStream, VarPreviousGrouping, "", "", _
                                     VarOpen, VarClose, VarWhitespaceIncrement)

    ' Show books?
    '
    If (UBound(ParamBookInfoArray, 1) > 0) Then
      VarShowBooks = "true"
    Else
      VarShowBooks = "false"
    End If

    ' Close out the WWHBookGroups_Books function
    '
    VarBooksStream.WriteLine("}")
    VarBooksStream.WriteLine("")
    VarBooksStream.WriteLine("function  WWHBookGroups_ShowBooks()")
    VarBooksStream.WriteLine("{")
    VarBooksStream.WriteLine("  return " & VarShowBooks & ";")
    VarBooksStream.WriteLine("}")
    VarBooksStream.WriteLine("")
    VarBooksStream.WriteLine("function  WWHBookGroups_ExpandAllAtTop()")
    VarBooksStream.WriteLine("{")
    VarBooksStream.WriteLine("  return false;")
    VarBooksStream.WriteLine("}")

    VarBooksStream.Close
  End If
End Sub

' ###############################################

Sub WWHelp_WriteToWWHDir(ParamHelpFolder, _
                         ParamBookInfoArray)
  Dim VarIndex
  Dim VarRelativeBookDirectoryPath
  Dim VarToWWHDirPath
  Dim VarToWWHDirStream
  Dim VarToWWHDirReturnResult
  Dim VarStringIndex


  ' Determine max grouping level
  '
  For VarIndex = LBound(ParamBookInfoArray, 1) To UBound(ParamBookInfoArray, 1)
    ' Access book directory
    '
    VarRelativeBookDirectoryPath = ParamBookInfoArray(VarIndex, 0)

    ' Access towwhdir.js
    '
    VarToWWHDirPath = ParamHelpFolder
    VarToWWHDirPath = GlobalFileSystem.BuildPath(VarToWWHDirPath, VarRelativeBookDirectoryPath)
    VarToWWHDirPath = GlobalFileSystem.BuildPath(VarToWWHDirPath, "wwhdata")
    VarToWWHDirPath = GlobalFileSystem.BuildPath(VarToWWHDirPath, "common")
    VarToWWHDirPath = GlobalFileSystem.BuildPath(VarToWWHDirPath, "towwhdir.js")

    ' Confirm the file exists
    '
    If (GlobalFileSystem.FileExists(VarToWWHDirPath)) Then
      Set VarToWWHDirStream = GlobalFileSystem.OpenTextFile(VarToWWHDirPath, 2)

      ' Open up the WWHToWWHelpDirectory function
      '
      VarToWWHDirStream.WriteLine("function  WWHToWWHelpDirectory()")
      VarToWWHDirStream.WriteLine("{")

      ' Determine return result
      '
      VarToWWHDirReturnResult = "../"
      VarStringIndex = InStr(1, VarRelativeBookDirectoryPath, "\", 1)
      While (VarStringIndex > 0)
        VarToWWHDirReturnResult = "../" & VarToWWHDirReturnResult
        VarStringIndex = InStr(VarStringIndex + 1, VarToWWHDirReturnResult, "\", 1)
      Wend

      ' Write return result
      '
      VarToWWHDirStream.WriteLine("  return """ & VarToWWHDirReturnResult & """;")

      ' Close out the WWHToWWHelpDirectory function
      '
      VarToWWHDirStream.WriteLine("}")

      VarToWWHDirStream.Close
    End If
  Next
End Sub

' ###############################################

Sub WWHelp_ClearHelpRuntimes(ParamHelpFolder, _
                             ParamBookInfoArray)
  Dim VarIndex
  Dim VarRelativeBookDirectoryPath
  Dim VarHelpRuntimePath


  ' Determine max grouping level
  '
  For VarIndex = LBound(ParamBookInfoArray, 1) To UBound(ParamBookInfoArray, 1)
    ' Access book directory
    '
    VarRelativeBookDirectoryPath = ParamBookInfoArray(VarIndex, 0)

    ' Clear it!
    '
    VarHelpRuntimePath = ParamHelpFolder
    VarHelpRuntimePath = GlobalFileSystem.BuildPath(VarHelpRuntimePath, VarRelativeBookDirectoryPath)
    VarHelpRuntimePath = GlobalFileSystem.BuildPath(VarHelpRuntimePath, "wwhsec.htm")
    If (GlobalFileSystem.FileExists(VarHelpRuntimePath)) Then
      GlobalFileSystem.DeleteFile(VarHelpRuntimePath)
    End If

    VarHelpRuntimePath = ParamHelpFolder
    VarHelpRuntimePath = GlobalFileSystem.BuildPath(VarHelpRuntimePath, VarRelativeBookDirectoryPath)
    VarHelpRuntimePath = GlobalFileSystem.BuildPath(VarHelpRuntimePath, "wwhelp")
    If (GlobalFileSystem.FolderExists(VarHelpRuntimePath)) Then
      GlobalFileSystem.DeleteFolder(VarHelpRuntimePath)
    End If
  Next
End Sub

' ###############################################

Function WWHelp_UpdateBooks(ParamHelpFolderName)
  Dim bVarSuccess
  Dim VarHelpFolder
  Dim VarBookInfoArray
  Dim VarExistingHelpSetIndex
  Dim VarExistingHelpSetPath
  Dim VarExistingRuntimePath
  Dim VarMergedRuntimePath


  ' Initialize return value
  '
  bVarSuccess = False

  If (GlobalFileSystem.FolderExists(ParamHelpFolderName)) Then
    Set VarHelpFolder = GlobalFileSystem.GetFolder(ParamHelpFolderName)
    VarBookInfoArray = Array()

    ' Get book directory information
    '
    If (WWHelp_GetBookFolders(VarHelpFolder, VarBookInfoArray)) Then
      ' Create top-level support files
      '
      VarExistingHelpSetIndex = LBound(VarBookInfoArray, 1)
      VarExistingHelpSetPath = GlobalFileSystem.BuildPath(VarHelpFolder, VarBookInfoArray(VarExistingHelpSetIndex, 0))
      VarExistingRuntimePath = GlobalFileSystem.BuildPath(VarExistingHelpSetPath, "wwhelp")
      VarMergedRuntimePath = GlobalFileSystem.BuildPath(VarHelpFolder, "wwhelp")
      If (Not GlobalFileSystem.FolderExists(VarMergedRuntimePath)) Then
        If (GlobalFileSystem.FolderExists(VarExistingRuntimePath)) Then
          Call GlobalFileSystem.CopyFolder(VarExistingRuntimePath, VarMergedRuntimePath)
        End If
      End If
      VarExistingRuntimePath = GlobalFileSystem.BuildPath(VarExistingHelpSetPath, "wwhsec.htm")
      VarMergedRuntimePath = GlobalFileSystem.BuildPath(VarHelpFolder, "index.html")
      If (Not GlobalFileSystem.FileExists(VarMergedRuntimePath)) Then
        If (GlobalFileSystem.FileExists(VarExistingRuntimePath)) Then
          Call GlobalFileSystem.CopyFile(VarExistingRuntimePath, VarMergedRuntimePath)
        End If
      End If
      VarExistingRuntimePath = GlobalFileSystem.BuildPath(VarExistingHelpSetPath, "wwhsec.htm")
      VarMergedRuntimePath = GlobalFileSystem.BuildPath(VarHelpFolder, "wwhsec.htm")
      If (Not GlobalFileSystem.FileExists(VarMergedRuntimePath)) Then
        If (GlobalFileSystem.FileExists(VarExistingRuntimePath)) Then
          Call GlobalFileSystem.CopyFile(VarExistingRuntimePath, VarMergedRuntimePath)
        End If
      End If

      ' Update books.xml and books.js
      '
      Call WWHelp_WriteBooksFile(VarHelpFolder, VarBookInfoArray)
      Call WWHelp_WriteBooksForJavaScript(VarHelpFolder, VarBookInfoArray)

      ' Update towwhdir.js
      '
      Call WWHelp_WriteToWWHDir(VarHelpFolder, VarBookInfoArray)

      ' Clear help runtimes
      '
      Call WWHelp_ClearHelpRuntimes(VarHelpFolder, VarBookInfoArray)

      bVarSuccess = True
    End If
  End If

  WWHelp_UpdateBooks = bVarSuccess
End Function

' ###############################################

Function WWHelp_Main()
  Dim bVarSuccess


  ' Initialize return value
  '
  bVarSuccess = False

  ' Check arguements
  '
  If (WScript.Arguments.Count = 1) Then
    ' Update books.xml and books.js
    '
    bVarSuccess = WWHelp_UpdateBooks(WScript.Arguments(0))
  End If

  ' Report errors
  '
  If (Not bVarSuccess) Then
    WScript.Echo "ERROR: books.js, books.xml, and/or options.xml not updated."
  End If

  WWHelp_Main = bVarSuccess
End Function

' ###############################################
