 <xsl:template name="Breadcrumbs">
  <xsl:param name="ParamPageRule" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />

  <!-- Determine separator -->
  <!--                     -->
  <xsl:variable name="VarBreadcrumbsSeparator">
   <xsl:variable name="VarBreadcrumbsSeparatorProperty" select="$ParamPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-separator']/@Value" />
   <xsl:choose>
    <xsl:when test="string-length($VarBreadcrumbsSeparatorProperty) &gt; 0">
     <xsl:value-of select="$VarBreadcrumbsSeparatorProperty" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:text> : </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Emit merge groups? -->
  <!--                    -->
  <xsl:if test="true()">
   <!-- Locate merge group settings -->
   <!--                             -->
   <xsl:variable name="VarMergeGroup" select="$GlobalProject/wwproject:Project/wwproject:FormatConfigurations/wwproject:FormatConfiguration[@TargetID = wwprojext:GetFormatID()]/wwproject:MergeSettings//wwproject:MergeGroup[@GroupID = $ParamSplit/@groupID]" />

   <!-- Emit merge groups hierarchy -->
   <!--                             -->
   <xsl:apply-templates select="$VarMergeGroup" mode="breadcrumbs-merge-hierarchy">
    <xsl:with-param name="ParamBreadcrumbsSeparator" select="$VarBreadcrumbsSeparator" />
   </xsl:apply-templates>

   <!-- Emit separator -->
   <!--                -->
   <xsl:if test="count($ParamBreadcrumbTOCEntry) &gt; 0">
    <xsl:value-of select="$VarBreadcrumbsSeparator" />
   </xsl:if>
  </xsl:if>

  <!-- Emit TOC breadcrumb entries -->
  <!--                             -->
  <xsl:apply-templates select="$ParamBreadcrumbTOCEntry" mode="breadcrumbs-toc-hierarchy">
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   <xsl:with-param name="ParamBreadcrumbTOCEntry" select="$ParamBreadcrumbTOCEntry" />
   <xsl:with-param name="ParamBreadcrumbsSeparator" select="$VarBreadcrumbsSeparator" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template name="BreadcrumbEntry">
  <xsl:param name="ParamTOCEntry" />

  <xsl:for-each select="$ParamTOCEntry/wwdoc:Paragraph/wwdoc:Number/wwdoc:Text | $ParamTOCEntry/wwdoc:Paragraph/wwdoc:TextRun/wwdoc:Text">
   <xsl:variable name="VarText" select="." />

   <xsl:value-of select="$VarText/@value" />
  </xsl:for-each>
 </xsl:template>


 <!-- breadcrumbs-merge-hierarchy -->
 <!--                             -->

 <xsl:template match="wwproject:TOC" mode="breadcrumbs-merge-hierarchy">
  <xsl:param name="ParamBreadcrumbsSeparator" />
  <xsl:param name="ParamMergeTOC" select="." />

  <!-- Process parent -->
  <!--                -->
  <xsl:apply-templates select="$ParamMergeTOC/parent::*" mode="breadcrumbs-merge-hierarchy">
   <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamBreadcrumbsSeparator" />
  </xsl:apply-templates>

  <!-- Emit separator -->
  <!--                -->
  <xsl:if test="count($ParamMergeTOC/parent::wwproject:TOC) &gt; 0">
   <xsl:value-of select="$ParamBreadcrumbsSeparator" />
  </xsl:if>

  <!-- Emit entry -->
  <!--            -->
  <xsl:value-of select="$ParamMergeTOC/@Name" />
 </xsl:template>


 <xsl:template match="wwproject:MergeGroup" mode="breadcrumbs-merge-hierarchy">
  <xsl:param name="ParamBreadcrumbsSeparator" />
  <xsl:param name="ParamMergeGroup" select="." />

  <!-- Process parent -->
  <!--                -->
  <xsl:apply-templates select="$ParamMergeGroup/parent::*" mode="breadcrumbs-merge-hierarchy">
   <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamBreadcrumbsSeparator" />
  </xsl:apply-templates>

  <!-- Emit separator -->
  <!--                -->
  <xsl:if test="count($ParamMergeGroup/parent::wwproject:TOC) &gt; 0">
   <xsl:value-of select="$ParamBreadcrumbsSeparator" />
  </xsl:if>

  <!-- Emit entry -->
  <!--            -->
  <xsl:variable name="VarMergeGroupTitle">
   <xsl:choose>
    <!-- Title exists? -->
    <!--               -->
    <xsl:when test="string-length($ParamMergeGroup/@Title) &gt; 0">
     <xsl:value-of select="$ParamMergeGroup/@Title" />
    </xsl:when>

    <!-- Use group name -->
    <!--                -->
    <xsl:otherwise>
     <xsl:value-of select="wwprojext:GetGroupName($ParamMergeGroup/@GroupID)" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:value-of select="$VarMergeGroupTitle" />
 </xsl:template>


 <xsl:template match="*" mode="breadcrumbs-merge-hierarchy">
  <xsl:param name="ParamBreadcrumbsSeparator" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="breadcrumbs-merge-hierarchy">
  <xsl:param name="ParamBreadcrumbsSeparator" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <!-- breadcrumbs-toc-hierarchy -->
 <!--                           -->

 <xsl:template match="wwtoc:Entry" mode="breadcrumbs-toc-hierarchy">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />
  <xsl:param name="ParamBreadcrumbsSeparator" />
  <xsl:param name="ParamTOCEntry" select="." />


  <!-- Process parent -->
  <!--                -->
  <xsl:apply-templates select="$ParamTOCEntry/parent::*" mode="breadcrumbs-toc-hierarchy">
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   <xsl:with-param name="ParamBreadcrumbTOCEntry" select="$ParamBreadcrumbTOCEntry" />
   <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamBreadcrumbsSeparator" />
  </xsl:apply-templates>

  <!-- Emit separator if necessary -->
  <!--                             -->
  <xsl:if test="count($ParamTOCEntry/parent::wwtoc:Entry) &gt; 0">
   <xsl:value-of select="$ParamBreadcrumbsSeparator" />
  </xsl:if>

  <!-- Emit entry -->
  <!--            -->
  <xsl:choose>
   <xsl:when test="(string-length($ParamTOCEntry/@path) &gt; 0) and (count($ParamBreadcrumbTOCEntry | $ParamTOCEntry) &gt; 1)">
    <!-- Entry with link -->
    <!--                 -->
    <xsl:variable name="VarRelativePath" select="wwuri:GetRelativeTo($ParamTOCEntry/@path, $ParamSplit/@path)" />

    <html:a class="WebWorks_Breadcrumb_Link" href="{$VarRelativePath}#{$ParamBreadcrumbTOCEntry/@linkid}">
     <xsl:call-template name="BreadcrumbEntry">
      <xsl:with-param name="ParamTOCEntry" select="$ParamTOCEntry" />
     </xsl:call-template>
    </html:a>
   </xsl:when>

   <xsl:otherwise>
    <!-- Entry without link -->
    <!--                    -->
    <xsl:call-template name="BreadcrumbEntry">
     <xsl:with-param name="ParamTOCEntry" select="$ParamTOCEntry" />
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template match="*" mode="breadcrumbs-toc-hierarchy">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />
  <xsl:param name="ParamBreadcrumbsSeparator" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="breadcrumbs-toc-hierarchy">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />
  <xsl:param name="ParamBreadcrumbsSeparator" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>
