<!-- Modifications for complete breadcrumbs path in multivolume (merged) helpsets -->
<!-- Replace the original "Breadcrumbs" and "BreadcrumbEntry" template code in    -->
<!-- your custom "content.xsl" file with the following code.                      -->

<!-- Process merge settings hierarchy (mode="complete-toc"). -->
 <xsl:template match="wwproject:TOC | wwproject:MergeGroup" mode="complete-toc">
   <xsl:param name="ParamBreadcrumbsSeparator" />
   <!-- Process parent -->
   <xsl:apply-templates select="parent::*" mode="complete-toc">
     <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamBreadcrumbsSeparator" />
   </xsl:apply-templates>
   <!-- Emit yourself -->
   <xsl:apply-templates select="." mode="complete-toc-entry">
     <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamBreadcrumbsSeparator" />
   </xsl:apply-templates>
 </xsl:template>

 <xsl:template match="*" mode="complete-toc">
   <xsl:param name="ParamBreadcrumbsSeparator" />
   <!-- Ignore everything that is not a MergeGroup or a TOC element. -->
 </xsl:template>

 <xsl:template match="text() | comment() | processing-instruction()" mode="complete-toc">
   <xsl:param name="ParamBreadcrumbsSeparator" />
   <!-- Ignore text nodes, comments, and processing instructions. -->
 </xsl:template>

 <!-- Emit breadcrumbs entries based on merge settings (mode="complete-toc-entry"). -->
 <!-- Emit breadcrumb entry for TOC element and append separator. -->
 <xsl:template match="wwproject:TOC" mode="complete-toc-entry">
   <xsl:param name="ParamBreadcrumbsSeparator" />
   <xsl:value-of select="./@Name" />
   <xsl:value-of select="$ParamBreadcrumbsSeparator" />
 </xsl:template>
 
 <!-- Emit breadcrumb entry for MergeGroup element (without separator). -->
 <xsl:template match="wwproject:MergeGroup" mode="complete-toc-entry">
   <xsl:param name="ParamBreadcrumbsSeparator" />
   <xsl:choose>
     <!-- Emit MergeGroup title. -->
     <xsl:when test="string-length(./@Title) &gt; 0">
       <xsl:value-of select="./@Title" />
     </xsl:when>
     <!-- Emit GroupName -->
     <xsl:otherwise>
       <xsl:value-of select="wwprojext:GetGroupName(./@GroupID)" />
     </xsl:otherwise>
   </xsl:choose>
 </xsl:template>

 <xsl:template match="*" mode="complete-toc-entry">
   <!-- Ignore everything that is not a MergeGroup or a TOC element. -->
 </xsl:template>

 <xsl:template match="text() | comment() | processing-instruction()" mode="complete-toc-entry">
   <!-- Ignore text nodes, comments, and processing instructions. -->
 </xsl:template>

 <xsl:template name="Breadcrumbs">
  <xsl:param name="ParamPageRule" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />

  <!-- Locate MergeGroup specified in merge settings. -->
  <xsl:variable name="VarMergeGroup" select="$GlobalProject/wwproject:Project/wwproject:FormatConfigurations/wwproject:FormatConfiguration[@TargetID = wwprojext:GetFormatID()]/wwproject:MergeSettings//wwproject:MergeGroup[@GroupID = $ParamSplit/@groupID]" />

  <!-- Process merge settings hierarchy starting with the current MergeGroup. -->
  <xsl:apply-templates select="$VarMergeGroup" mode="complete-toc">
   <xsl:with-param name="ParamBreadcrumbsSeparator">
    <!-- Determine separator -->
    <xsl:variable name="VarBreadcrumbsSeparator" select="$ParamPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-separator']/@Value" />
    <xsl:choose>
     <xsl:when test="string-length($VarBreadcrumbsSeparator) &gt; 0">
      <xsl:value-of select="$VarBreadcrumbsSeparator" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:text> : </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
  </xsl:apply-templates>

  <!-- Process regular TOC entries. -->
  <xsl:for-each select="$ParamBreadcrumbTOCEntry/../ancestor-or-self::wwtoc:Entry">
   <xsl:variable name="VarTOCEntry" select="." />

   <!-- Emit entry -->
   <xsl:choose>
    <xsl:when test="string-length($VarTOCEntry/@path) &gt; 0">
     <!-- Entry with link -->
     <xsl:variable name="VarRelativePath" select="wwuri:GetRelativeTo($VarTOCEntry/@path, $ParamSplit/@path)" />
     <html:a class="WebWorks_Breadcrumb_Link" href="{$VarRelativePath}#{$ParamBreadcrumbTOCEntry/@linkid}">
      <xsl:call-template name="BreadcrumbEntry">
       <xsl:with-param name="ParamTOCEntry" select="$VarTOCEntry" />
	   <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-separator']/@Value" />
      </xsl:call-template>
     </html:a>
    </xsl:when>

    <xsl:otherwise>
     <!-- Entry without link -->
     <xsl:call-template name="BreadcrumbEntry">
      <xsl:with-param name="ParamTOCEntry" select="$VarTOCEntry" />
	  <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-separator']/@Value" />
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>

   <!-- Emit a separator after each TOC entry.                               -->
   <!--                                                                      -->
   <!-- Note: If you have a project where not all top-level TOC Entries are  -->
   <!-- based on a first level heading (i.e. have a "@level = 1"), but where -->
   <!-- also TOC Entries with a "@level = 2" might be the direct ancestors   -->
   <!-- of MergeGroup elements, remove the comment characters of the if-     -->
   <!-- statement.                                                           -->
   <!-- Then, a separator is emitted after each entry, but not for level 1   -->
   <!-- entries. In this case you also have to modify the "BreadcrumbEntry"  -->
   <!-- template to also add a separator before each level 2 entry.          -->
   <!-- See the comments in the "BreadcrumbEntry" template below fr details. -->
   
   <!-- <xsl:if test="($VarTOCEntry/@level != 1)"> -->
     <xsl:variable name="VarBreadcrumbsSeparator" select="$ParamPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-separator']/@Value" />
	 <xsl:choose>
	   <xsl:when test="string-length($VarBreadcrumbsSeparator) &gt; 0">
	     <xsl:value-of select="$VarBreadcrumbsSeparator" />
	   </xsl:when>

	   <xsl:otherwise>
	     <xsl:text> : </xsl:text>
	   </xsl:otherwise>
	 </xsl:choose>
   <!-- </xsl:if> -->
  </xsl:for-each>
   
  <!-- Emit entry -->
  <!--            -->
  <xsl:call-template name="BreadcrumbEntry">
   <xsl:with-param name="ParamTOCEntry" select="$ParamBreadcrumbTOCEntry" />
   <xsl:with-param name="ParamBreadcrumbsSeparator" select="$ParamPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-separator']/@Value" />
  </xsl:call-template>
 </xsl:template>

 <xsl:template name="BreadcrumbEntry">
 <!-- Emit regular TOC entry as breadcrumb. -->
  <xsl:param name="ParamTOCEntry" />
  <xsl:param name="ParamBreadcrumbsSeparator" />

  <xsl:for-each select="$ParamTOCEntry/wwdoc:Paragraph/wwdoc:Number/wwdoc:Text | $ParamTOCEntry/wwdoc:Paragraph/wwdoc:TextRun/wwdoc:Text">
   <xsl:variable name="VarText" select="." />
   
   <!-- Emit separator if this is a merged/multivolume project and this is   -->
   <!-- a first level TOC entry ("@level = 1" as specified in the Paragraph  -->
   <!-- Designer settings).                                                  -->
   <!--                                                                      -->
   <!-- Note: Use the commented if-statement to also check for "@level = 2"  -->
   <!-- TOC Entries. This is needed if not all top-level TOC Entries of your -->
   <!-- project have a "@level = 1", but if there might also be TOC Entries  -->
   <!-- with a  "@level = 2" as direct ancestors of MergeGroup elements.     -->
   <!--                                                                      -->
   <!-- Important: Use the alternative if-statement only in conjunction with -->
   <!-- the respective if-statement of the "Breadcrumbs" template            -->
   <!-- (<xsl:if test="($VarTOCEntry/@level != 1)">)!                        -->
   <xsl:if test="string-length($GlobalProject/wwproject:Project/wwproject:FormatConfigurations/wwproject:FormatConfiguration[@TargetID = wwprojext:GetFormatID()]/wwproject:MergeSettings/wwproject:TOC/@Name) &gt; 0">
	 <xsl:if test="($ParamTOCEntry/@level = 1)">
	 <!-- <xsl:if test="($ParamTOCEntry/@level = 1) or ($ParamTOCEntry/@level = 2)"> -->
	   <xsl:value-of select="$ParamBreadcrumbsSeparator" />
     </xsl:if>
   </xsl:if>
   
   <!-- Emit breadcrumb text. -->
   <xsl:value-of select="$VarText/@value" />
  </xsl:for-each>
 </xsl:template>
 <!-- End of breadcrumbs modifications. -->
